/*
 *  - MOD list menu tab
 */


#include <stdio.h>
#include "../ithelib.h"
#include "../gui/igui.hpp"
#include "../console.h"
#include "../core.hpp"
#include "../gamedata.h"
#include "../init.h"
#include "../gui/menusys.h"
#include "../sound.h"

// defines

#define STR_LEN 32

// variables

extern int focus,MO_Id,Songs,mus_total;
extern char **musfiles;
static int curmus=0;

static int MusName_Id,MusPath_Id;
static char str32[STR_LEN+1];

// functions

extern void Toolbar();
static void Nothing();

void GetMusName();
void GetMusPath();
void MusUpdate();                       // Update the displays
void NewMus();
void PickMus();
void DelMus();
static int CMP(char *a, char *b);

static int GetNumForFilename(char *str);

// GoFocal - The menu tab function.  This is called from the toolbar

void MO_GoFocal()
{
if(focus==6)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;  // Make a 255 character string

focus=6;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(MO_Id);     // And make the button stick inwards

// MOD list editor.
// In the top-left corner is the sprite ID number and two movement buttons.

IG_TextButton(32,64," Add New Song      ",NewMus,NULL,NULL);
IG_TextButton(32,96," Pick a Song       ",PickMus,NULL,NULL);
IG_TextButton(32,128," Delete a Song     ",DelMus,NULL,NULL);

IG_AddKey(KEY_A,NewMus);
IG_AddKey(KEY_P,PickMus);
IG_AddKey(KEY_D,DelMus);

DrawSunkBox3D(300,56,620,460);

setcolor(ITG_WHITE);
DrawScreenText(320,64,"Music file name:");
MusName_Id = IG_InputButton(320,80,str32,GetMusName,NULL,NULL);

DrawScreenText(320,112,"Music filename:");
MusPath_Id = IG_InputButton(320,128,str32,GetMusPath,NULL,NULL);

IG_AddKey(KEY_N,GetMusName);
IG_AddKey(KEY_F,GetMusPath);

MusUpdate();
}

// Callback for a null event

void Nothing()
{
return;
}


// Callback for Setting the sprite description

void GetMusName()
{
//if(curspr<SPtot)
    InputString(-1,-1,"Enter the new description of the music",32,mustab[curmus].name);
MusUpdate();
}

// Callback for Setting the sprite filename

void GetMusPath()
{
char oldpath[128];

strcpy(oldpath,mustab[curmus].fname);
InputNameFromListWithFunc(-1,-1,"Choose a music file:",mus_total-1,musfiles,5,mustab[curmus].fname,0,0,NULL);
if(!mustab[curmus].fname[0])
    strcpy(mustab[curmus].fname,oldpath);
MusUpdate();
}

// Function for updating the display

void MusUpdate()
{
int num;
// Clear the name and path, set to proper value later, if valid no.
IG_UpdateText(MusPath_Id,"");
IG_UpdateText(MusName_Id,"");

if(!mustab[curmus].name || !mustab[curmus].fname)
    num = -1;
else
    {
    num = GetNumForFilename(mustab[curmus].fname);
    IG_UpdateText(MusPath_Id,mustab[curmus].fname);
    IG_UpdateText(MusName_Id,mustab[curmus].name);
    }
}

int GetNumForFilename(char *str)
{
if(!str)
    return -1;
for(int ctr=0;ctr<mus_total;ctr++)
    if(mustab[ctr].fname)
    if(!stricmp(mustab[ctr].fname,str))
        return ctr;
return -1;
}

void PickMus()
{
char name[512];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(mus_alloc,sizeof(char *));

for(ctr=0;ctr<mus_alloc;ctr++)
    if(mustab[ctr].name && mustab[ctr].fname)
        mlist[num++]=mustab[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,mustab[curmus].name);
InputNameFromListWithFunc(-1,-1,"Choose a song:              ",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,mustab[curmus].name);

M_free(mlist);

for(ctr=0;ctr<mus_alloc;ctr++)
    if(mustab[ctr].name != NULL)
    if(!stricmp(mustab[ctr].name,name))
        {
        curmus=ctr;
        MusUpdate();
        return;
        }
Notify(-1,-1,"Oh Bugger!",NULL);
}

void NewMus()
{
for(long ctr=0;ctr<mus_alloc;ctr++)
    if(!mustab[ctr].name)
        {
        curmus=ctr;
        mustab[curmus].fname = (char *)M_get(1,64);
        mustab[curmus].name = (char *)M_get(1,64);
        strcpy(mustab[curmus].fname,"NONE");
        strcpy(mustab[curmus].name,"NONE");
        MusUpdate();

        GetMusPath();
        GetMusName();

        return;
        }

Notify(-1,-1,"Cannot create a new music file.","Increase the value of MAX_MODS in SCRIPTER.INI");
}

void DelMus()
{
if(curmus == 0)
    {
    Notify(-1,-1,"This entry is special and cannot be deleted.","You can still change it to something else though..");
    return;
    }

if(Confirm(-1,-1,"Really delete this song?",mustab[curmus].name))
    {
    M_free(mustab[curmus].fname);
    M_free(mustab[curmus].name);
    mustab[curmus].fname = NULL;
    mustab[curmus].name = NULL;
    curmus=0;
    MusUpdate();
    }

}

int CMP(char *a,char *b)
{
return strcmp(a,b);
}


