/*
 *
 * $Id: postgre.c, v 0.9 2001/04/06 23:22:45 kaiser Exp $
 *
 * postgresql backend to ipac
 * Copyright (C) 2001 Al Zaharov
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author can be reached via email: kaiser13@mail2000.ru, or by 
 * fido: Al_Zaharov@p88.f58.n5005.z2.fidonet.org
 *
*/

#include "ipac.h"
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/param.h>
#include <unistd.h>
#include <libpq-fe.h>

//#define DEBUG_POST
#undef DEBUG_POST

extern char *ahost;

static char *pgoptions = NULL;
static char *pgtty = NULL;

static char *dbname = DBASE;
static char *pgport = DBASE_PORT;

#ifdef DEBUG_POST
static char *log_file = "/post_log";
static FILE *logs;
#endif

static PGconn *conn;
static PGresult *res;

/* plain file ipac interface entries */
int postgre_stor_open(int flag);
int postgre_stor_store_record(const data_record_type *data);
int postgre_stor_list_timestamps(timestamp_t start, timestamp_t end,
		timestamp_t **data, timestamp_t *just_before,
		timestamp_t *just_after, char *ahost);
int postgre_stor_get_records(timestamp_t timestamp_b, timestamp_t timestamp_e, 
		data_record_type **data, char *filter);
int postgre_stor_delete_record(timestamp_t timestamp);
void postgre_stor_close();

static const storage_method_t interface_entry = {
	"postgre",
	postgre_stor_open,
	postgre_stor_store_record,
	postgre_stor_list_timestamps,
	postgre_stor_get_records,
	postgre_stor_delete_record,
	postgre_stor_close
};

const storage_method_t *ipac_sm_interface_postgre() {
	return &interface_entry;
}

int postgre_stor_open(int flag)
{
        conn=PQsetdbLogin(dbhost, dbport, pgoptions, pgtty, dbname, dbuser,
                                                                    dbpass);
	if (PQstatus(conn) == CONNECTION_BAD) {
    		fprintf(stderr, "Connection to database '%s' failed.\n", dbname);
    		fprintf(stderr, "%s", PQerrorMessage(conn));
    		PQfinish(conn);
    		return(1);
	}
#ifdef DEBUG_POST
	logs=fopen(log_file, "a+");
	fprintf(logs, "%lu : postgre_stor_open\n", time(NULL));
#endif        
	storage_opened = 1;
	return(0);
}

int postgre_stor_store_record(const data_record_type *data)
{
    rule_type *rule, *firstrule;
    char wh_exec[380];

    firstrule = data->firstrule;

    if (firstrule == NULL)
	    return 0;
    for (rule = firstrule; rule; rule=rule->next)
    {
        sprintf(wh_exec, "insert into logs (rule_name, bytes, pkts, that_time, hostname) "
          	"values ('%s', '%llu', '%llu', '%lu', '%s')", 
		rule->name, rule->bytes, rule->pkts, data->timestamp, hostname);
#ifdef DEBUG_POST
	fprintf(logs, "%lu : postgre_stor_store_record\n", time(NULL));
	fprintf(logs, "%s\n", wh_exec);
	fflush(logs);
#endif	
        res = PQexec(conn, wh_exec);
	PQclear(res);
    }
    return 0;
}

int postgre_stor_list_timestamps(timestamp_t start, timestamp_t end,
		timestamp_t **data, timestamp_t *just_before,
		timestamp_t *just_after, char *ahost)
{
    int i;    
    timestamp_t *ts_list=NULL;
    int ts_list_len = 0;
    char wh_exec[250];

    if (!ahost)
	    sprintf(wh_exec, "SELECT distinct that_time from logs where that_time between "
		    "%lu::bigint and %lu::bigint order by that_time asc", start, end);
    else
	    sprintf(wh_exec, "select distinct that_time from logs where hostname = '%s' and "
				"that_time between %lu::bigint and %lu::bigint order by that_time asc", 
				ahost, start, end);

    res = PQexec(conn, wh_exec);

    ts_list_len = PQntuples(res);

    if (ts_list_len>0) {
	    ts_list = xmalloc(PQntuples(res) * sizeof(timestamp_t));
	    for (i=0; i<ts_list_len; i++)
		    ts_list[i] = strtoul((char *) PQgetvalue(res, i, 0), NULL, 0);
	    PQclear(res);
	    if (just_before != NULL) {
		    sprintf(wh_exec, "select that_time from logs where "
				    "that_time <%lu::bigint order by that_time desc limit 1", start);
		    PQexec(conn, wh_exec);
		    if (PQntuples(res)>0)
			    *just_before = strtoul((char *) PQgetvalue(res, 0, 0), NULL, 0);
		    else
			    *just_before = (timestamp_t) -1 ;
		    PQclear(res);
	    }
	    if (just_after != NULL) {
		    sprintf(wh_exec, "select that_time from logs where "
				    "that_time >%lu::bigint order by that_time asc limit 1", end);
		    PQexec(conn, wh_exec);
		    if (PQntuples(res)>0)
			    *just_after = strtoul((char *) PQgetvalue(res, 0, 0), NULL, 0);
		    else
			    *just_after = (timestamp_t) -1;
		    PQclear(res);
	    }
    } else {
	    return 0;
    }
    
    *data = ts_list;

    return ts_list_len;
}

int postgre_stor_get_records(timestamp_t timestamp_b, timestamp_t timestamp_e, 
		data_record_type **data, char *filter)
{
	rule_type *r, *r1=NULL;
	char *buf;
	int i, nr_timestamps, index;
	timestamp_t timestamp_akt;
	char wh_exec[320];
	char *pkts;
	char *bytes;

	if (!timestamp_e) timestamp_e=timestamp_b;

	if (ahost)
		sprintf(wh_exec, "select count(distinct that_time) from logs "
			"where hostname = '%s' and "
			"that_time between '%lu' and '%lu'", 
		     	ahost, timestamp_b, timestamp_e);
	else
		sprintf(wh_exec, "select count(distinct that_time) from logs "
				"where "
				"that_time between '%lu' and '%lu'",
				timestamp_b, timestamp_e);
	if (filter)
		sprintf(wh_exec+strlen(wh_exec), " and rule_name like '%%%s%%'", filter);
	res = PQexec(conn, wh_exec);
	if (!res || PQresultStatus(res) != PGRES_TUPLES_OK) {
		fprintf(stderr, "PQexec of (%s) command didn't return tuples"
				" properly\nlibpq says: %s", wh_exec, 
				PQresultErrorMessage(res));
		exit(-1);
	}
	nr_timestamps=strtol(PQgetvalue(res,0,0),0,0);
	PQclear(res);
    
	/* create record_data_type. */
	*data = (data_record_type *)xmalloc(sizeof(data_record_type) * nr_timestamps);

	if (ahost)
		sprintf(wh_exec, "select rule_name, bytes, pkts, that_time, hostname from logs "
	             "where "
		     "hostname = '%s' and that_time between '%lu' and '%lu' ",
		     ahost, timestamp_b, timestamp_e);
	else
		sprintf(wh_exec, "select rule_name, bytes, pkts, that_time, hostname from logs "
				"where "
				"that_time between '%lu' and '%lu' ",
				timestamp_b, timestamp_e);
	if (filter)
		sprintf(wh_exec+strlen(wh_exec), " and rule_name like '%%%s%%'", filter);
	sprintf(wh_exec+strlen(wh_exec), " order by that_time");
	printf("quering: %s\n", wh_exec);
#ifdef DEBUG_POST
	fprintf(logs, "%lu : postgre_stor_get_record\n", time(NULL));
	fprintf(logs, "%s\n", wh_exec);
	fflush(logs);
#endif	

	res = PQexec(conn, wh_exec);
	timestamp_akt=0;index=-1;
	for (i=0; i<PQntuples(res); i++) {
        	timestamp_t tstamp_new = strtoull((char *) PQgetvalue(res,i,3),NULL,0);
		if (tstamp_new != timestamp_akt) { // do we have a new timestamp?
			timestamp_akt=tstamp_new;
	                index++;
        	        if (index > nr_timestamps) {
                	        fprintf(stderr,"We got more records then timestamps "
				    "were reported before. This should not happen\n");
				exit (-1);
        	        }
	                (*data)[index].timestamp = timestamp_akt;
			(*data)[index].machine_name = xstrdup((char *) PQgetvalue(res, i, 4));
	                (*data)[index].firstrule = NULL;
	                r1 = NULL;
	        }
		r = new_rule();
		if (r1 == NULL)
			(*data)[index].firstrule = r;
		else
			r1->next = r;
		r1 = r;
		buf = (char *) PQgetvalue(res, i, 0);
		bytes = (char *) PQgetvalue(res, i, 1);
		r->bytes = strtoull(bytes, &pkts, 0);
		pkts = (char *) PQgetvalue(res, i, 2);
		r->pkts =  strtoull(pkts, &bytes, 0);
		strncpy(r->name, buf, PQgetlength(res, i, 0));
#ifdef DEBUG_POST
	fprintf(logs, "Record: %s, bytes %s, pkts %s\n", r->name, bytes, pkts);
	fflush(logs);
#endif	
		r->name[PQgetlength(res, i, 0)] = '\0';
	}
	PQclear(res);

	return index+1;
}

int postgre_stor_delete_record(timestamp_t timestamp)
{
        char wh_exec[320];

        res = PQexec(conn, "BEGIN");
        PQclear(res);

        sprintf(wh_exec, "delete from logs where that_time='%lu'", timestamp);
#ifdef DEBUG_POST
        fprintf(logs, "%lu : postgre_stor_delete_record\n", time(NULL));
        fprintf(logs, "%s\n", wh_exec);
        fflush(logs);
#endif	
        PQexec(conn, wh_exec);
        PQclear(res);
        res = PQexec(conn, "COMMIT");
        PQclear(res);
        return 0;
}

int postgre_stor_rule_active(char *rule_name)
{
	int tmp=1;
	char wh_exec[300];

	res = PQexec(conn, "BEGIN");
	PQclear(res);

	sprintf(wh_exec, "declare mycursor binary cursor for "
                     "SELECT active FROM active WHERE rule_name='%s'", rule_name);
	res = PQexec(conn, wh_exec);
	PQclear(res);
    
	res = PQexec(conn, "FETCH ALL in mycursor");
	if (PQntuples(res) != 0) 
	        tmp = *(int *) PQgetvalue(res, 0, 0);
	PQclear(res);

#ifdef DEBUG_POST
        fprintf(logs, "%lu : postgre_stor_rule_active\n", time(NULL));
        fflush(logs);
#endif	
	res = PQexec(conn, "CLOSE mycursor");
	PQclear(res);
	res = PQexec(conn, "COMMIT");
	PQclear(res);
    
	return tmp;
}

void postgre_stor_close()
{
#ifdef DEBUG_POST
	fprintf(logs, "%lu : postgre_stor_close\n", time(NULL));
	fclose(logs);
	fflush(logs);
#endif    
	
        PQfinish(conn);
	storage_opened = 0;
}
