/*
******************************************************************************
*
*   Copyright (C) 2000-2003, International Business Machines
*   Corporation and others.  All Rights Reserved.
*
******************************************************************************
*
* File sscanf.h
*
* Modification History:
*
*   Date        Name        Description
*   02/08/00    george      Creation. Copied from uscanf.h
******************************************************************************
*/

#ifndef _USSCANF_H
#define _USSCANF_H

#include "unicode/utypes.h"

#if !UCONFIG_NO_FORMATTING

#include "unicode/ustdio.h"
#include "ufmt_cmn.h"
#include "locbund.h"
#include "uscanf.h"

struct u_localized_string {
  UChar     *str;   /* Place to write the string */
  int32_t   pos;    /* Number of codeunits available to write to */
  int32_t   len;    /* Maximum number of code units that can be written to output */

  ULocaleBundle  fBundle;     /* formatters */
};
typedef struct u_localized_string u_localized_string;

/**
 * A u_scanf handler function.  
 * A u_scanf handler is responsible for handling a single u_scanf 
 * format specification, for example 'd' or 's'.
 * @param stream The UFILE to which to write output.
 * @param info A pointer to a <TT>u_scanf_spec_info</TT> struct containing
 * information on the format specification.
 * @param args A pointer to the argument data
 * @param fmt A pointer to the first character in the format string
 * following the spec.
 * @param consumed On output, set to the number of characters consumed
 * in <TT>fmt</TT>.
 * @return The number of arguments converted and assigned, or -1 if an
 * error occurred.
 */
typedef int32_t (*u_sscanf_handler) (u_localized_string    *input,
                   const u_scanf_spec_info     *info,
                   ufmt_args  *args,
                   const UChar            *fmt,
                   int32_t            *consumed);

#endif /* #if !UCONFIG_NO_FORMATTING */

#endif
