/* debug.c - Debugging facilities.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#include <config.h>

#include <stdio.h>
#include "debug.h"

/**
 * If debugging is enabled, print a debugging message.
 *
 * @param msg
 *   Debug message.
 */
void
debug(const char *msg, ...)
{
	if (DEBUG_ENABLED) {
		va_list ap;

		va_start(ap, msg);
		vfprintf(stderr, msg, ap);
		fprintf(stderr, "\n");
		va_end(ap);
	}
}
