/* checkerstubs.c - Additional stubs for gccchecker.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#include <config.h>
#include "checker_api.h"
#include <string.h>			/* for strndup */
#include <wordexp.h>		/* for wordexp, wordfree */
#include <libgen.h>			/* for dirname */
#include <stdlib.h>			/* for getsubopt */
#include "common.h"

typedef char *rl_compentry_func_t(const char *, int);

extern char **rl_completion_matches (const char *text, rl_compentry_func_t *entry_func);
extern size_t strnsize(const char *s, size_t size);
extern long long int chkr_stub_strtoq (const char *nptr, char **endptr, int base)
		__asm__ (CHKR_PREFIX ("strtoq"));

char * chkr_stub_strndup (const char *s, size_t size)
		__asm__ (CHKR_PREFIX ("strndup"));
char *
chkr_stub_strndup (const char *s, size_t size)
{
	char *res;

	if (size > 0) {
		size_t len = strnsize (s, size);
		stubs_chkr_check_addr (s, len, CHKR_RO, "s");
	}
	res = strndup (s, size);
	stubs_chkr_set_right (res, strlen (s) + 1, CHKR_RW);
	return res;
}

long long int chkr_stub_strtoll (const char *nptr, char **endptr, int base)
		__asm__ (CHKR_PREFIX ("strtoll"));
long long int
chkr_stub_strtoll (const char *nptr, char **endptr, int base)
{
	return chkr_stub_strtoq(nptr, endptr, base);
}

int chkr_stub_wordexp (const char *words, wordexp_t *we, int flags)
		__asm__ (CHKR_PREFIX ("wordexp"));
int
chkr_stub_wordexp (const char *words, wordexp_t *we, int flags)
{
	stubs_chkr_check_str(words, CHKR_RO, "words");
	stubs_chkr_check_addr(we, sizeof(wordexp_t), CHKR_RW, "we");
	return wordexp(words, we, flags);
}

void chkr_stub_wordfree (wordexp_t *we)
		__asm__ (CHKR_PREFIX ("wordfree"));
void
chkr_stub_wordfree (wordexp_t *we)
{
	stubs_chkr_check_addr(we, sizeof(wordexp_t), CHKR_RW, "we");
	if (we->we_wordc > 0) {
		int c;
		stubs_chkr_check_addr(we->we_wordv, sizeof(char *) * (we->we_wordc+1), CHKR_RW, "we_wordv");
		for	(c = 0; c < we->we_wordc; c++)
			stubs_chkr_check_str(we->we_wordv[c], CHKR_RW, "*we_wordv");
	}
	wordfree(we);
}

#ifdef HAVE_LIBREADLINE
char **chkr_stub_completion_matches (const char *text, rl_compentry_func_t *entry_func)
		__asm__ (CHKR_PREFIX ("rl_completion_matches"));
char **
chkr_stub_completion_matches (const char *text, rl_compentry_func_t *entry_func)
{
	char ** res;

	stubs_chkr_check_str (text, CHKR_RO, "text");
	stubs_chkr_check_exec (entry_func, "entry_func");

	res = rl_completion_matches (text, entry_func);
	if (res) {
		char **iter;

		for (iter = res; ; iter++) {
			stubs_chkr_set_right (iter, sizeof (char *), CHKR_RW);
			if (!*iter)
				break;
			stubs_chkr_set_right (*iter, strlen (*iter) + 1, CHKR_RW);
		}
	}
	return res;
}
#endif

int chkr_stub_getsubopt(char **option, char* const *tokens, char **value)
		__asm__ (CHKR_PREFIX ("getsubopt"));
int
chkr_stub_getsubopt(char **option, char* const *tokens, char **value)
{
	int c;

	stubs_chkr_check_addr(option, sizeof(char *), CHKR_RW, "option");
	stubs_chkr_check_str(*option, CHKR_RW, "*option");

	stubs_chkr_check_addr(tokens, sizeof(char *), CHKR_RO, "tokens");
	
	for (c = 0; true; c++) {
		stubs_chkr_check_addr(tokens[c], sizeof(char *), CHKR_RO, "*tokens");
		if (tokens[c] == NULL)
			break;
	}

	stubs_chkr_check_addr(option, sizeof(char *), CHKR_RW, "value");

	return getsubopt(option, tokens, value);
}

char *chkr_stub_dirname(char *path)
		__asm__ (CHKR_PREFIX ("dirname"));
char *
chkr_stub_dirname(char *path)
{
	stubs_chkr_check_str(path, CHKR_RW, "path");
	return dirname(path);
}
