/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: PatternEditorPanel.h,v 1.35 2004/07/07 14:49:56 comix Exp $
 *
 */


#ifndef PATTERN_EDITOR_PANEL_H
#define PATTERN_EDITOR_PANEL_H

#include <map>
using namespace std;

#include "lib/EngineListener.h"
#include "lib/Object.h"

#include "qwidget.h"
#include "qpixmap.h"
#include "qcombobox.h"
#include "qmessagebox.h"
#include "qtooltip.h"
#include "qscrollview.h"
#include "qscrollbar.h"
#include "qframe.h"
#include "qspinbox.h"
#include "qlabel.h"

#include "PatternEditor.h"

class Button;
class ToggleButton;
class Fader;

class PatternEditor;
class PatternEditorRuler;
class PatternEditorInstrumentList;
class NotePropertiesRuler;



///
/// Pattern Editor Panel
///
class PatternEditorPanel : public QWidget, public EngineListener, public Object
{
	Q_OBJECT

	public:
		PatternEditorPanel(QWidget *parent);
		~PatternEditorPanel();
		void updateStart(bool start);

		void resizeEvent ( QResizeEvent *ev );
		void showEvent ( QShowEvent *ev );

		PatternEditor* getPatternEditor() {	return m_pPatternEditor;	}
		NotePropertiesRuler* getVelocityRuler() {	return m_pNotePropertiesRuler;	}
		PatternEditorInstrumentList* getInstrumentList() {	return m_pInstrumentList;	}

		void setSelectedInstrument( int nInstr );

		Pattern* getPattern() {	return m_pPattern;	}

	public slots:
		void gridResolutionChanged();
		void hearNotesBtnClick(Button *ref);
		void patternSizeComboChanged();
		void recordEventsBtnClick(Button *ref);
		void quantizeEventsBtnClick(Button *ref);

		void showVelocityBtnClick(Button *ref);
		void showPitchBtnClick(Button *ref);
		
		void syncToExternalHorizontalScrollbar(int);
		void contentsMoving(int dummy);

	private:
		Pattern *m_pPattern;
		uint m_nPanelWidth;
		uint m_nPanelHeight;
		QPixmap m_backgroundPixmap;

		// editor
		QScrollView* m_pEditorScrollView;
		QFrame* m_pEditorFrame;
		PatternEditor *m_pPatternEditor;

		// ruler
		QScrollView* m_pRulerScrollView;
		PatternEditorRuler *m_pPatternEditorRuler;

		// instr list
		QScrollView* m_pInstrListScrollView;
		PatternEditorInstrumentList  *m_pInstrumentList;

		// note properties ruler
		QScrollView* m_pNotePropertiesScrollView;
		NotePropertiesRuler *m_pNotePropertiesRuler;


		QScrollBar *m_pPatternEditorHScrollBar;
		QScrollBar *m_pPatternEditorVScrollBar;


		QComboBox* gridResolutionCombo;
		QComboBox* pPatternSizeCombo;
		QLabel *patternNameLbl;
		ToggleButton *hearNotesBtn;
		ToggleButton *recordEventsBtn;
		ToggleButton *quantizeEventsBtn;

		ToggleButton *m_pShowVelocityBtn;
		ToggleButton *m_pShowPitchBtn;
		
		// implements EngineListener interface
		virtual void patternModified();
		virtual void stateChanged(int state);
		virtual void selectedPatternChanged();
		virtual void selectedInstrumentChanged();
		//~ implements EngineListener interface
		
		void customEvent( QCustomEvent *ev );
		void setupPattern();
};





#endif


