<?php

include_once 'Horde/SyncML/Sync.php';
include_once 'Horde/SyncML/Command/Sync/ContentSyncElement.php';

/**
 * $Horde: framework/SyncML/SyncML/Sync/TwoWaySync.php,v 1.13.4.2 2005/02/28 15:52:30 jan Exp $
 *
 * Copyright 2003-2005 Anthony Mills <amills@pyramid6.com>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Anthony Mills <amills@pyramid6.com>
 * @author  Karsten Fourmont <fourmont@gmx.de>
 *
 * @version $Revision: 1.13.4.2 $
 * @since   Horde 3.0
 * @package Horde_SyncML
 */
class Horde_SyncML_Sync_TwoWaySync extends Horde_SyncML_Sync {

    function endSync($currentCmdID, &$output)
    {
        global $registry;

        $state = &$_SESSION['SyncML.state'];

        $syncType = $this->_targetLocURI;
        $hordeType = $syncType;

        $refts = $state->getServerAnchorLast($syncType);
        $currentCmdID = $this->handleSync($currentCmdID,
                                          $hordeType,
                                          $syncType,
                                          $output,
                                          $refts);
        if ($syncType == 'calendar' && $state->handleTasksInCalendar()) {
            Horde::logMessage("SyncML: handling tasks in calendar sync", __FILE__, __LINE__, PEAR_LOG_DEBUG);

            $currentCmdID = $this->handleSync($currentCmdID, 'tasks', $syncType,
                                              $output, $refts);
        }
    }

    function handleSync($currentCmdID, $hordeType, $syncType,&$output, $refts)
    {
        global $registry;

        require_once 'Horde/History.php';
        $history = &Horde_History::singleton();

        $state = &$_SESSION['SyncML.state'];

        // Get changes.
        $changes = $registry->call($hordeType. '/listBy', array('action' => 'modify', 'timestamp' => $refts));
        if (is_a($changes, 'PEAR_Error')) {
            Horde::logMessage($changes, __FILE__, __LINE__, PEAR_LOG_ERR);
            return $changes;
        }

        foreach ($changes as $guid) {
            $guid_ts = $history->getTSforAction($guid, 'modify');
            $sync_ts = $state->getChangeTS($syncType, $guid);
            if ($sync_ts && $sync_ts == $guid_ts) {
                // Change was done by us upon request of client.
                // Don't mirror that back to the client.
                Horde::logMessage("SyncML: change: $guid ignored, came from client", __FILE__, __LINE__, PEAR_LOG_DEBUG);
                continue;
            }
            $locid = $state->getLocID($syncType, $guid);
            if (!$locid) {
                Horde::logMessage("SyncML: unable to create change for $guid: locid not found in map", __FILE__, __LINE__, PEAR_LOG_WARNING);
                continue;
            }

            // Create a replace request for client.
            $contentType = $state->getPreferedContentTypeClient($syncType);
            $c = $registry->call($hordeType. '/export',
                                 array('guid' => $guid, 'contentType' => $contentType));
            if (!is_a($c, 'PEAR_Error')) {
                // Item in history but not in database. Strange, but
                // can happen.
                Horde::logMessage("SyncML: change: $guid", __FILE__, __LINE__, PEAR_LOG_DEBUG);
                $cmd = &new Horde_SyncML_Command_Sync_ContentSyncElement();
                $cmd->setContent($state->convertServer2Client($c, $contentType));
                $cmd->setSourceURI($guid);
                $cmd->setTargetURI($locid);
                $cmd->setContentType($contentType);
                $currentCmdID = $cmd->outputCommand($currentCmdID, $output, 'Replace');
                $state->log('Server-Replace');
            }
        }

        // Get deletes.
        $deletes = $registry->call($hordeType. '/listBy', array('action' => 'delete', 'timestamp' => $refts));
        foreach ($deletes as $guid) {
            $guid_ts = $history->getTSforAction($guid, 'delete');
            $sync_ts = $state->getChangeTS($syncType, $guid);
            if ($sync_ts && $sync_ts == $guid_ts) {
                // Change was done by us upon request of client.
                // Don't mirror that back to the client.
                Horde::logMessage("SyncML: delete $guid ignored, came from client", __FILE__, __LINE__, PEAR_LOG_DEBUG);
                continue;
            }
            $locid = $state->getLocID($syncType, $guid);
            if (!$locid) {
                Horde::logMessage("SyncML: unable to create delete for $guid: locid not found in map", __FILE__, __LINE__, PEAR_LOG_WARNING);
                continue;
            }

            Horde::logMessage("SyncML: delete: $guid", __FILE__, __LINE__, PEAR_LOG_DEBUG);
            // Create a Delete request for client.
            $cmd = &new Horde_SyncML_Command_Sync_ContentSyncElement();
            $cmd->setTargetURI($locid);
            $cmd->setSourceURI($guid);
            $currentCmdID = $cmd->outputCommand($currentCmdID, $output, 'Delete');
            $state->log('Server-Delete');
        }

        // Get adds.
        $adds = $registry->call($hordeType. '/listBy', array('action' => 'add', 'timestamp' => $refts));
        foreach ($adds as $guid) {
            $guid_ts = $history->getTSforAction($guid, 'add');
            $sync_ts = $state->getChangeTS($syncType, $guid);
Horde::logMessage("SyncML: add: guid_ts: $guid_ts sync_ts:$sync_ts", __FILE__, __LINE__, PEAR_LOG_DEBUG);

            if ($sync_ts && $sync_ts == $guid_ts) {
                // Change was done by us upon request of client.
                // Don't mirror that back to the client.
                Horde::logMessage("SyncML: add: $guid ignored, came from client", __FILE__, __LINE__, PEAR_LOG_DEBUG);
                continue;
            }

            $locid = $state->getLocID($syncType, $guid);

            if ($locid && $refts == 0) {
                // For slow sync (ts=0): do not add data for which we
                // have a locid again.  This is a heuristic to avoid
                // duplication of entries.
                Horde::logMessage("SyncML: skipping add of guid $guid as there already is a locid $locid", __FILE__, __LINE__, PEAR_LOG_DEBUG);
                continue;
            }
            Horde::logMessage("SyncML: add: $guid", __FILE__, __LINE__, PEAR_LOG_DEBUG);

            // Create an Add request for client.
            $contentType = $state->getPreferedContentTypeClient($syncType);

            $cmd = &new Horde_SyncML_Command_Sync_ContentSyncElement();
            $c = $registry->call($hordeType . '/export',
                                 array('guid' => $guid,
                                       'contentType' => $contentType));
            if (!is_a($c, 'PEAR_Error')) {
                // Item in history but not in database. Strange, but
                // can happen.
                $cmd->setContent($state->convertServer2Client($c, $contentType));
                $cmd->setContentType($contentType);
                $cmd->setSourceURI($guid);
                $currentCmdID = $cmd->outputCommand($currentCmdID, $output, 'Add');
                $state->log('Server-Add');
            } else {
                Horde::logMessage('SyncML: api export call for ' . $guid . ' failed:  '
                                  . $c->getMessage() ,
                                  __FILE__, __LINE__, PEAR_LOG_DEBUG);

            }
        }

        return $currentCmdID;
    }

}
