<?php
/*
 * $Horde: horde/login.php,v 2.55.2.24 2005/01/03 11:25:44 jan Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';

if (Horde::getFormData('reason') == 'logout') {
    if ($registry->hasMethod('auth/logout')) {
        $url = Horde::getFormData('url', Horde::selfURL());
        header('Location: ' . str_replace('&amp;', '&', Horde::url($registry->link('auth/logout', array('url' => Horde::url($url, true))), true)));
        exit;
    } else {
        $entry = sprintf('User %s [%s] logged out of Horde',
                         Auth::getAuth(), $_SERVER['REMOTE_ADDR']);
        Horde::logMessage($entry, __FILE__, __LINE__, LOG_NOTICE);
        Auth::clearAuth();
        session_destroy();
        Horde::setupSessionHandler();
        @session_start();
    }
}

if (isset($_POST['horde_user']) &&
    isset($_POST['horde_pass'])) {
    /* Destroy any existing session on login and make sure to use a
       new session ID, to avoid session fixation issues. */
    Horde::getCleanSession();

    $auth = &Auth::singleton($conf['auth']['driver'], $conf['auth']['params']);
    if ($auth->authenticate(Horde::getFormData('horde_user'),
                            array('password' => Horde::getFormData('horde_pass')))) {
        $entry = sprintf('Login success for %s [%s] to Horde',
                         Auth::getAuth(), $_SERVER['REMOTE_ADDR']);
        $level = LOG_INFO;
    } else {
        $entry = sprintf('FAILED LOGIN for %s [%s] to Horde',
                         Horde::getFormData('horde_user'), $_SERVER['REMOTE_ADDR']);
        $level = LOG_ERR;
    }
    Horde::logMessage($entry, __FILE__, __LINE__, $level);
}

if (Auth::getAuth()) {
    if (Horde::getFormData('url')) {
        header('Location: ' . Horde::url(Horde::getFormData('url'), true));
        exit;
    }
}

if ($browser->hasFeature('wml')) {
    $registry->applications['horde']['templates'] .= '/wml';
}

/* Map the various values for $reason to more descriptive status messages. */
$reasons = array('login'   => '',
                 'session' => sprintf(_("Your %s session has expired. Please login again."), $registry->getParam('name')),
                 'logout'  => _("You have been logged out.<br />Thank you for using the system."),
                 'failed'  => _("Login failed for some reason. Most likely your username or password was entered incorrectly."));

if (Auth::getAuth()) {
    $title = _("My Summary");
    $js_onLoad = null;
    if ($prefs->getValue('summary_refresh_time')) {
        $refresh_time = $prefs->getValue('summary_refresh_time');
        $refresh_url = Horde::applicationUrl('login.php');
    }
    include_once HORDE_BASE . '/lib/Menu.php';
    include_once HORDE_BASE . '/lib/Identity.php';
    $identity = new Identity();
    $fullname = $identity->getValue('fullname');
    if (empty($fullname)) {
        $fullname = Auth::getAuth();
    }
    $template = 'user.inc';
    $columns = array();
    $pref_num_columns = $prefs->getValue('summary_columns');
    foreach ($registry->listApps() as $app) {
        if (isset($registry->services[$app]['horde']['summary'])) {
            $summary = $registry->callByPackage($app, 'horde/summary');
            if (!PEAR::isError($summary)) {
                $columns[] = $summary;
            }
        }
    }
    if (count($columns) > 0) {
        $width = round(100 / $pref_num_columns);
    }
} elseif ($registry->hasMethod('auth/login')) {
    $url = Horde::getFormData('url', Horde::selfURL());
    header('Location: ' . Horde::url($registry->link('auth/login', array('url' => Horde::url($url, true))), true));
    exit;
} else {
    $title = _("Horde Login");
    $js_onLoad = 'setFocus()';
    $template = 'login.inc';
}
require HORDE_TEMPLATES . '/common-header.inc';
require HORDE_TEMPLATES . '/login/' . $template;
require HORDE_TEMPLATES . '/common-footer.inc';
