use strict;

my @sizeArray = (8, 16, 24, 32, 40, 48, 56, 64, 72, 80, 88, 96, 104, 112, 120, 128, 136, 144, 152, 160, 168, 176, 184, 192, 200, 208, 216, 224, 232, 240, 248, 256, 264, 272, 280, 288, 296, 304, 312, 320, 328, 336, 344, 352, 360, 368, 376, 384, 392, 400, 408, 416, 424, 432, 440, 448, 456, 464, 472, 480, 488, 496, 504, 512, 576, 640, 704, 768, 832, 896, 960, 1024, 1088, 1152, 1216, 1280, 1344, 1408, 1472, 1536, 1600, 1664, 1728, 1792, 1856, 1920, 1984, 2048, 2112, 2560, 3072, 3584, 4096, 4608, 5120, 5632, 6144, 6656, 7168, 7680, 8192 - 16 );

# Not sure if 16 is correct above...

my $sizeArrayLength = scalar(@sizeArray);

my $maxSize = $sizeArray[$sizeArrayLength - 1];

sub roundUpSize ($) {
    my $s = $1;
    my $curr = 0;
    while ($curr < $sizeArrayLength) {
	if ($sizeArray[$curr] >= $s) {
	    return $sizeArray[$curr];
	}
	$curr++;
    }
    return 0;
}

my %inUse;
my %mallocs;
my %superblocks;

my $empties = 0;
my $totalSuperblocks = 0;

while (<>) {
  chop;
  my $x = $_;
  if ($x =~ /M\s(.+)\s(0x.+)/) {

      my $addr = $2;
      my $val = hex($addr);
      my $size = $1;
      my $roundedSize;

      # Round size appropriately.

      if ($size > $maxSize) {
	  $roundedSize = int(($size + 8191) / 8192) * 8192;
      } else {
  	  $roundedSize = roundUpSize ($size);
      }

      my $prevSb = $superblocks{$roundedSize};
      
      if ($size > $maxSize) {
	  $totalSuperblocks += $roundedSize / 8192;
      }

      $inUse{$roundedSize}++;

      my $totalObj = $inUse{$roundedSize} * $roundedSize;

      if (($size <= $maxSize) && (($totalObj / 8192) > $prevSb)) {
	  
	  # We need a new superblock.
	  # First, we try to get an empty one.
	  # If none is available, we 'get' a new one.
	  
	  if ($empties > 0) {
	      $empties--;
	  } else {
	      $totalSuperblocks++;
	  }
	  $superblocks{$roundedSize}++;
      }

      $mallocs{$addr} = $roundedSize;

    } elsif ($x =~ /F\s(0x.+)/) {

      my $addr = $1;
      my $size = $mallocs{$addr};
      undef $mallocs{$addr};

      if ($size <= $maxSize) {

	  my $prevSb = $superblocks{$size};
	  $inUse{$size}--;
	  my $totalObj = $inUse{$size} * $size;

	  if (($totalObj / 8192) < $prevSb) {
	      $superblocks{$size}--;
	      $empties++;
	  }
      } else {
	  $inUse{$size}--;
      }
  }
}

my $k;
foreach $k (sort (keys %inUse)) {
    print "inUse $k = ", $inUse{$k}, "\n";
}

print "total Superblocks = $totalSuperblocks\n";
print "total space = ", 8192 * $totalSuperblocks, "\n";


1;

exit;

my $allocTime = 0;

while (<>) {
  chop;
  my $x = $_;
  if ($x =~ /M\s(.+)\s(0x.+)/) {
    # malloc
      my $addr = $2;
      my $val = hex($addr);
      print $allocTime, "\t", $val, "\n";
      $allocTime += $1;
  }
}

1;

my $allocTime = 0;
my $inUse = 0;

while (<>) {
  chop;
  my $x = $_;
  if ($x =~ /M\s(.+)\s(0x.+)/) {
    # malloc
      my $size = $1;
      my $addr = $2;
      my $val = hex($addr);
      $allocTime += $size;
      $inUse += $size;
      print $allocTime, "\t", $inUse, "\n";
      $mallocs{$addr} = $size;

  } elsif ($x =~ /F\s(0x.+)/) {

      my $addr = $1;
      my $size = $mallocs{$addr};
      undef $mallocs{$addr};
      $inUse -= $size;
      
  }
}

1;
