// -*- C++ -*-

#ifndef _ZEROHEAP_H_
#define _ZEROHEAP_H_

#include <string.h>

/**
 * @class ZeroHeap
 * @brief Zero out all memory obtained by malloc.
 */

template <class SuperHeap>
class ZeroHeap : public SuperHeap {
public:

#if 1
  void free (void * ptr) {
    size_t sz = getSize (ptr);
    //
    // We use Duff's device, borrowed from Doug Lea's malloc-2.7.0.
    //
    
    do {            
      size_t * mzp = (size_t*)(ptr);
      unsigned long mctmp = (sz)/sizeof(size_t);
      long mcn;
      if (mctmp < 8) mcn = 0; else { mcn = (mctmp-1)/8; mctmp %= 8; }
      switch (mctmp) {
      case 0: for(;;) { *mzp++ = 0;
      case 7:           *mzp++ = 0;
      case 6:           *mzp++ = 0;
      case 5:           *mzp++ = 0;
      case 4:           *mzp++ = 0;
      case 3:           *mzp++ = 0;
      case 2:           *mzp++ = 0;
      case 1:           *mzp++ = 0; if(mcn <= 0) break; mcn--; }
      }
    } while(0);
    SuperHeap::free (ptr);
    // memset (ptr, '\0', sz);
  }
#endif

#if 0
  void * malloc (const size_t sz) {
    void * ptr = SuperHeap::malloc (sz);

    //
    // We use Duff's device, borrowed from Doug Lea's malloc-2.7.0.
    //

    do {            
      size_t * mzp = (size_t*)(ptr);
      unsigned long mctmp = (sz)/sizeof(size_t);
      long mcn;
      if (mctmp < 8) mcn = 0; else { mcn = (mctmp-1)/8; mctmp %= 8; }
      switch (mctmp) {
      case 0: for(;;) { *mzp++ = 0;
      case 7:           *mzp++ = 0;
      case 6:           *mzp++ = 0;
      case 5:           *mzp++ = 0;
      case 4:           *mzp++ = 0;
      case 3:           *mzp++ = 0;
      case 2:           *mzp++ = 0;
      case 1:           *mzp++ = 0; if(mcn <= 0) break; mcn--; }
      }
    } while(0);
    // memset (ptr, '\0', sz);
    return ptr;
  }
#endif

};


#endif // _ZEROHEAP_H_
