use strict;
use English;

my $numiterations = 6;

# Benchmarks and their parameters

my $larsondir = "larson";
my $larson = "larson 10 10 100 10000 1000 1";

my $shbenchdir = "shbench";
my $shbench = "shbench1 50000000";

#my @dirs = ($larsondir, $shbenchdir);
#my @benchmarks = ($larson, $shbench);

my @dirs = ($shbenchdir);
my @benchmarks = ($shbench);

my $numbenchmarks = int @dirs;

my $bench;

my %ld_command;

$ld_command{"baseline"} = "";
$ld_command{"ptmalloc"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/ptmalloc/libptmalloc.so:/usr/lib/libdl.so";
$ld_command{"ptmalloc2"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/ptmalloc2/libptmalloc.so:/usr/lib/libdl.so";
$ld_command{"mtmalloc8"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/libmtmalloc8.so:/usr/lib/libdl.so";
$ld_command{"mtmalloc9"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/libmtmalloc9.so:/usr/lib/libdl.so";

$ld_command{"hoard"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/hoard/libhoard.so:/usr/lib/libdl.so";
$ld_command{"hoard-nolockopt"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/hoard/libhoard-nolockopt.so:/usr/lib/libdl.so";
$ld_command{"hoard-noclearopt"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/hoard/libhoard-noclearopt.so:/usr/lib/libdl.so";
$ld_command{"hoard-noreaps"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/hoard/libhoard-noreaps.so:/usr/lib/libdl.so";
$ld_command{"hoard-nada"} = "setenv LD_PRELOAD /usr/fit/tmp2/emery/heaplayers/allocators/hoard/libhoard-nada.so:/usr/lib/libdl.so";

foreach $bench ("hoard","ptmalloc","ptmalloc2","mtmalloc8","mtmalloc9","hoard-noclearopt", "hoard-nolockopt", "hoard-noreaps", "hoard-nada", "baseline") {
#    open F, ">forp";
    open F, "|tcsh";

    for (my $numthreads = 1; $numthreads <= 16; $numthreads++) {

	for (my $i = 0; $i < $numbenchmarks; $i++) {
	    print $benchmarks[$i], "\n";
	    print F "cd ", $dirs[$i], "; rm -f timings-$bench-$numthreads; touch timings-$bench-$numthreads\n";
	    print F $ld_command{$bench}, "\n";
	    print "bench = $bench\n";
	    for (my $j = 0; $j < $numiterations; $j++) {
		my $cmdstring;
		if ($benchmarks[$i] eq "larson") {
		    $cmdstring = "./" . $benchmarks[$i] . " " . $numthreads . " >> timings-$bench-$numthreads";
		} else {
		    $cmdstring = "../hirestimer \"./" . $benchmarks[$i] . " >> timings-$bench-$numthreads\" >>& timings-$bench-$numthreads";
		}
		print F "$cmdstring\n";
		#print $cmdstring, "\n";
	    }
	    print F "cd ..\n";
	}
    }
    close F;
}

