%define name guarddog
%define version 2.0.0
%define release 1mdk82k3
%define _prefix /opt/kde3/
%define _docdir %{_prefix}/share/doc/
%define _menudir /usr/lib/menu/

Summary: Firewall Utility
Name: %{name}
Version: %{version}
Release: %{release}
Packager: Simon Edwards <simon@simonzone.com>
Source: %{name}-%{version}.tar.bz2
License: GPL
Group: System/Configuration/Networking
URL: http://www.simonzone.com/software/guarddog/
Requires: iptables
Buildroot: %_tmppath/%name-buildroot

%description
Guarddog is user friendly firewall generation and management utility for KDE
on Linux. It allows you to simply specify which protocols should be allowed
between which groups of computers and requires no knowledge of port numbers
or packets. Built on top of ipchains and/or iptables.

This RPM is for Mandrake 8.2 with *KDE 3* and installs into /opt/kde3/.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q

%build
export KDEDIR=/opt/kde3
./configure --prefix=%_prefix --mandir=%_mandir --libdir=%_libdir \
	--disable-rpath --enable-mt --with-qt-dir=/usr/lib/qt3/

%make

%install
make DESTDIR=$RPM_BUILD_ROOT install

%makeinstall
install -d %buildroot/%_menudir/ 
kdedesktop2mdkmenu.pl guarddog "Configuration/Networking"  %buildroot/%_datadir/applnk/System/guarddog.desktop %buildroot/%_menudir/guarddog

%clean
# rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README TODO AUTHORS COPYING ChangeLog
%_bindir/*
%_datadir/apps/guarddog/*
%_datadir/applnk/System/guarddog.desktop
%_docdir/HTML/en/guarddog
%_datadir/icons/hicolor/32x32/apps/*
%_datadir/icons/hicolor/48x48/apps/*
%_datadir/icons/locolor/16x16/apps/*
%_datadir/icons/locolor/32x32/apps/*
%_datadir/locale/da/LC_MESSAGES/guarddog.mo
%_datadir/locale/de/LC_MESSAGES/guarddog.mo
%_datadir/locale/it/LC_MESSAGES/guarddog.mo
%_menudir/guarddog

%post
if [ -x /usr/bin/update-menus ]; then
    /usr/bin/update-menus
fi
if [ ! -e /etc/rc.firewall ]; then
  echo "#!/bin/sh" > /etc/rc.firewall
  echo "# This is just a place holder rc.firewall file so that when the links" >> /etc/rc.firewall
  echo "# /sbin/ifup-local and /sbin/ifdown-local have something valid to  point to." >> /etc/rc.firewall
  echo "# It will be over written once the Guarddog configuration utility is used." >> /etc/rc.firewall
  echo "# --Guarddog, http://www.simonzone.com/software/guarddog/" >> /etc/rc.firewall
  chmod u+x /etc/rc.firewall
fi
if [ ! -x /sbin/ifup-local ]; then
  ln -s /etc/rc.firewall /sbin/ifup-local
else
  if [ ! -L /sbin/ifup-local ]; then
    echo "*** Warning: Could not make a link from /sbin/ifup-local to /etc/rc.firewall ***"
  fi
fi
if [ ! -x /sbin/ifdown-local ]; then
  ln -s /etc/rc.firewall /sbin/ifdown-local
else
  if [ ! -L /sbin/ifdown-local ]; then
    echo "*** Warning: Could not make a link from /sbin/ifdown-local to /etc/rc.firewall ***"
  fi
fi

if [ ! -e /etc/ppp/ip-up.local ]; then
  echo "#!/bin/bash" > /etc/ppp/ip-up.local
  echo "#" >> /etc/ppp/ip-up.local
  echo "# This short script just runs any firewall script located at /etc/rc.firewall ." >> /etc/ppp/ip-up.local
  echo "# It will be called whenever a ppp interface comes up. Normally we would hook" >> /etc/ppp/ip-up.local
  echo "# our firewall script in via /sbin/ifup-local, but a bug in the" >> /etc/ppp/ip-up.local
  echo "# /etc/ppp/ip-up script prevents that from working. This script provides a" >> /etc/ppp/ip-up.local
  echo "# workaround." >> /etc/ppp/ip-up.local
  echo "#" >> /etc/ppp/ip-up.local
  echo "# cheers, Guardddog http://www.simonzone.com/software/guarddog/" >> /etc/ppp/ip-up.local
  echo "#" >> /etc/ppp/ip-up.local
  echo "[ -x /etc/rc.firewall ] && /etc/rc.firewall" >> /etc/ppp/ip-up.local
  chmod u+x /etc/ppp/ip-up.local
fi
if [ ! -e /etc/ppp/ip-down.local ]; then
  echo "#!/bin/bash" > /etc/ppp/ip-down.local
  echo "#" >> /etc/ppp/ip-down.local
  echo "# This short script just runs any firewall script located at /etc/rc.firewall ." >> /etc/ppp/ip-down.local
  echo "# It will be called whenever a ppp interface goes down. Normally we would hook" >> /etc/ppp/ip-down.local
  echo "# our firewall script in via /sbin/ifdown-local, but a bug in the" >> /etc/ppp/ip-down.local
  echo "# /etc/ppp/ip-down script prevents that from working. This script provides a" >> /etc/ppp/ip-down.local
  echo "# workaround." >> /etc/ppp/ip-down.local
  echo "#" >> /etc/ppp/ip-down.local
  echo "# cheers, Guardddog http://www.simonzone.com/software/guarddog/" >> /etc/ppp/ip-down.local
  echo "#" >> /etc/ppp/ip-down.local
  echo "[ -x /etc/rc.firewall ] && /etc/rc.firewall" >> /etc/ppp/ip-down.local
  chmod u+x /etc/ppp/ip-down.local
fi

%postun
if [ "$1" = 0 ]; then
    if [ -x /usr/bin/update-menus ]; then
        /usr/bin/update-menus
    fi
fi

%changelog

* Tue Jul 9 2002 Simon Edwards <simon@simonzone.com> 2.0.0-1mdk82k3
- 2.0.0

* Thu Jun 20 2002 Simon Edwards <simon@simonzone.com> 1.9.16-1mdk82k3
- 1.9.16

* Sun Apr 28 2002 Simon Edwards <simon@simonzone.com> 1.9.15-1mdk82k3
- 1.9.15
- Compiled for Mandrake 8.2 with KDE 3.

* Wed Apr 10 2002 Simon Edwards <simon@simonzone.com> 1.9.14-1mdk82
- Upgraded to 1.9.14.
- Compiled for Mandrake 8.2
- Menu entry now appears under Configuration/Networking

* Fri Mar 28 2002 David Grant <dgrant@ieee.org> 1.9.13-1mdk
- Upgraded to 1.9.13.  Compiled for Mandrake 8.2

* Fri Mar 08 2002 Lenny Cartier <lenny@mandrakesoft.com> 1.9.12-1mdk
- 1.9.12

* Thu Feb 28 2002 Lenny Cartier <lenny@mandrakesoft.com> 1.9.11-1mdk
- 1.9.11

* Fri Jan 25 2002 Laurent Culioli <laurent@mandrakesoft.com> 1.9.10-2mdk
- Rebuild

* Mon Jan 21 2002 Laurent Culioli <laurent@mandrakesoft.com> 1.9.10-1mdk
- 1.9.10

* Thu Dec 20 2001 Lenny Cartier <lenny@mandrakesoft.com> 1.9.9-1mdk
- 1.9.9

* Fri Nov 30 2001 Lenny Cartier <lenny@mandrakesoft.com> 1.9.8-1mdk
- 1.9.8

* Thu Oct 18 2001 Lenny Cartier <lenny@mandrakesoft.com> 1.9.6-1mdk
- 1.9.6

* Tue Sep  4 2001 Laurent Culioli <laurent@mandrakesoft.com> 1.9.5-1mdk
- updated to version 1.9.5

* Sun Aug 26 2001 Laurent Culioli <laurent@mandrakesoft.com> 1.9.4-1mdk
- updated to version 1.9.4

* Tue Jul 10 2001 Laurent Culioli <laurent@mandrakesoft.com> 1.9.3-1mdk
- updated to version 1.9.3
- merged with  Simon Edward specfile

* Thu Mar 15 2001 David BAUDENS <baudens@mandrakesoft.com> 1.0.0-2mdk
- Rebuild against Qt 2.3.0

* Fri Jan 19 2001 Lenny Cartier <lenny@mandrakesoft.com> 1.0.0-1mdk
- updated to 1.0.0

* Thu Jan 11 2001 Lenny Cartier <lenny@mandrakesoft.com> 0.9.5-2mdk
- new url

* Fri Dec 22 2000 Lenny Cartier <lenny@mandrakesoft.com> 0.9.5-1mdk
- updated to 0.9.5

* Wed Nov 22 2000 Lenny Cartier <lenny@mandraksoft.com> 0.9.3-1mdk
- new in contribs
- updated to 0.9.3

* Mon Sep 2 2000 Simon Edwards <simon@simonzone.com> 0.9.2-1mdk
- RealPlayer support added.
- Small changes to the GUI to fix a few layout problems. Still
  not perfect, but much better.
- Manual is much more complete now. Now has a tutorial and FAQ section.

* Sun Jul 16 2000 Simon Edwards <simon@simonzone.com> 0.9.1-2mdk
- Fixed a small bug in the menu entry to Guarddog.

* Tue Jul 11 2000 Simon Edwards <simon@simonzone.com> 0.9.1-1mdk
- 0.9.1 release.
- Packaged with RPM for Mandrake 7.1 (should also work with Redhat).
- Some display glitch fixes, still more remain, grrr.
- Should now be able to find the protocol database file ok. Sorry to those people
  who tried to get it to run from source and failed.
- Uses sane defaults for checkboxes in new firewalls.
