%define name guarddog
%define version 2.0.0
%define release 1mdk

Summary: Firewall Utility
Name: %{name}
Version: %{version}
Release: %{release}
Source: %{name}-%{version}.tar.gz
Copyright: GPL
Group: Networking/Utilities
URL: http://www.simonzone.com/software/guarddog/
Packager: Simon Edwards
Distribution: Linux-Mandrake
BuildRoot: %{_tmppath}/%{name}-buildroot
Requires: iptables kdebase gawk textutils sed
Prefix: %{_prefix}
%description
Guarddog is user friendly firewall generation and management utility for KDE
on Linux. It allows you to simply specify which protocols should be allowed
between which groups of computers and requires no knowledge of port numbers
or packets. Built on top of ipchains and/or iptables.

This RPM is for Mandrake 8.1.

%prep
rm -rf $RPM_BUILD_ROOT

%setup

%build
CXXFLAGS="$RPM_OPT_FLAGS"
./configure
make

%install
make install prefix=$RPM_BUILD_ROOT/%{prefix}

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,0755)
%doc README TODO AUTHORS COPYING ChangeLog
%{prefix}/bin/guarddog
%{prefix}/share/apps/guarddog/networkprotocoldb.xml
%{prefix}/share/apps/guarddog/pics/advanced.png
%{prefix}/share/apps/guarddog/pics/box_clear.png
%{prefix}/share/apps/guarddog/pics/box_checked.png
%{prefix}/share/apps/guarddog/pics/box_crossed.png
%{prefix}/share/apps/guarddog/pics/chat.png
%{prefix}/share/apps/guarddog/pics/dataserve.png
%{prefix}/share/apps/guarddog/pics/filetransfer.png
%{prefix}/share/apps/guarddog/pics/game.png
%{prefix}/share/apps/guarddog/pics/logging.png
%{prefix}/share/apps/guarddog/pics/mail.png
%{prefix}/share/apps/guarddog/pics/miscellaneous.png
%{prefix}/share/apps/guarddog/pics/multimedia.png
%{prefix}/share/apps/guarddog/pics/network.png
%{prefix}/share/apps/guarddog/pics/protocols.png
%{prefix}/share/apps/guarddog/pics/rate_limit.png
%{prefix}/share/apps/guarddog/pics/terminal.png
%{prefix}/share/apps/guarddog/pics/userdefined.png
%{prefix}/share/apps/guarddog/pics/warn.png
%{prefix}/share/apps/guarddog/pics/zones.png
%{prefix}/share/apps/guarddog/pics/laserwarn.png
%{prefix}/share/doc/HTML/en/guarddog/
%{prefix}/share/icons/locolor/32x32/apps/guarddog.png
%{prefix}/share/icons/hicolor/48x48/apps/guarddog.png
%{prefix}/share/icons/hicolor/32x32/apps/guarddog.png
%{prefix}/share/icons/locolor/16x16/apps/guarddog.png
%{prefix}/share/locale/da/LC_MESSAGES/guarddog.mo
%{prefix}/share/locale/de/LC_MESSAGES/guarddog.mo
%{prefix}/share/locale/it/LC_MESSAGES/guarddog.mo
%{prefix}/lib/menu/guarddog
%post

if [ ! -e /etc/rc.firewall ]; then
  echo "#!/bin/sh" > /etc/rc.firewall
  echo "# This is just a place holder rc.firewall file so that when the links" >> /etc/rc.firewall
  echo "# /sbin/ifup-local and /sbin/ifdown-local have something valid to  point to." >> /etc/rc.firewall
  echo "# It will be over written once the Guarddog configuration utility is used." >> /etc/rc.firewall
  echo "# --Guarddog, http://www.simonzone.com/software/guarddog/" >> /etc/rc.firewall
  chmod u+x /etc/rc.firewall
fi
if [ ! -x /sbin/ifup-local ]; then
  ln -s /etc/rc.firewall /sbin/ifup-local
else
  if [ ! -L /sbin/ifup-local ]; then
    echo "*** Warning: Could not make a link from /sbin/ifup-local to /etc/rc.firewall ***"
  fi
fi
if [ ! -x /sbin/ifdown-local ]; then
  ln -s /etc/rc.firewall /sbin/ifdown-local
else
  if [ ! -L /sbin/ifdown-local ]; then
    echo "*** Warning: Could not make a link from /sbin/ifdown-local to /etc/rc.firewall ***"
  fi
fi

if [ ! -e /etc/ppp/ip-up.local ]; then
  echo "#!/bin/bash" > /etc/ppp/ip-up.local
  echo "#" >> /etc/ppp/ip-up.local
  echo "# This short script just runs any firewall script located at /etc/rc.firewall ." >> /etc/ppp/ip-up.local
  echo "# It will be called whenever a ppp interface comes up. Normally we would hook" >> /etc/ppp/ip-up.local
  echo "# our firewall script in via /sbin/ifup-local, but a bug in the" >> /etc/ppp/ip-up.local
  echo "# /etc/ppp/ip-up script prevents that from working. This script provides a" >> /etc/ppp/ip-up.local
  echo "# workaround." >> /etc/ppp/ip-up.local
  echo "#" >> /etc/ppp/ip-up.local
  echo "# cheers, Guardddog http://www.simonzone.com/software/guarddog/" >> /etc/ppp/ip-up.local
  echo "#" >> /etc/ppp/ip-up.local
  echo "[ -x /etc/rc.firewall ] && /etc/rc.firewall" >> /etc/ppp/ip-up.local
  chmod u+x /etc/ppp/ip-up.local
fi
if [ ! -e /etc/ppp/ip-down.local ]; then
  echo "#!/bin/bash" > /etc/ppp/ip-down.local
  echo "#" >> /etc/ppp/ip-down.local
  echo "# This short script just runs any firewall script located at /etc/rc.firewall ." >> /etc/ppp/ip-down.local
  echo "# It will be called whenever a ppp interface goes down. Normally we would hook" >> /etc/ppp/ip-down.local
  echo "# our firewall script in via /sbin/ifdown-local, but a bug in the" >> /etc/ppp/ip-down.local
  echo "# /etc/ppp/ip-down script prevents that from working. This script provides a" >> /etc/ppp/ip-down.local
  echo "# workaround." >> /etc/ppp/ip-down.local
  echo "#" >> /etc/ppp/ip-down.local
  echo "# cheers, Guardddog http://www.simonzone.com/software/guarddog/" >> /etc/ppp/ip-down.local
  echo "#" >> /etc/ppp/ip-down.local
  echo "[ -x /etc/rc.firewall ] && /etc/rc.firewall" >> /etc/ppp/ip-down.local
  chmod u+x /etc/ppp/ip-down.local
fi

if [ -x /usr/bin/update-menus ]; then
    /usr/bin/update-menus
fi

%postun
if [ "$1" = 0 ]; then
    if [ -x /usr/bin/update-menus ]; then
        /usr/bin/update-menus
    fi
fi
%changelog

* Tue Jul 9 2002 Simon Edwards <simon@simonzone.com> 2.0.0-1mdk

- 2.0.0 release.
- Fixed a small bug that was stopping Guarddog from compiling on Qt2.
- Fixed a small bug in the kernel detection scipt/code. (Reported and
  patched by Jess Thrysoee).
- Reviewed and edited the manual.

* Thu Jun 20 2002 Simon Edwards <simon@simonzone.com> 1.9.16-1mdk

- 1.9.16 release
- Fixed a major bug in the output script code concerning the use of &>
  redirection. This bug made most of the kernel tweaking code useless.
  (Thanks to Martin Matti Raivio for finding that one.)
- Fixed a bug in the SNMP support. (Thanks Michele Ferritto).
- Fixed a bug that was stopping ICQ direct messages.
- Fixed Yet Another SMB bug, affected network printers. (Thanks Jason
  Buberel).
- Bug fixes related to internationalisation and translation use in Guarddog.
- Additions and updates to the manual.
- Doing "Apply" and "Ok" now only tries to run the firewall script once.
- Added Italian translation of the program strings from Daniele Medri.
- Added Germany translation of the program strings and protocol text from
  Stephan Johach.
- Fixed a crash bug related to the import functionality.

* Sun Apr 28 2002 Simon Edwards <simon@simonzone.com> 1.9.15-1mdk

- 1.9.15 release
- Changed the 'Apply' button behaviour a little. 'Apply'->'Cancel'->'Keep
  settings' is now permanent, unlike before. The previous behaviour was
  a little unexpected.
- Added Danish translation file from Gunner Poulsen.
- Added CVS-server, DICT support.
- It should now compile ok on KDE 2 and 3. (With KDE 3 you may have to
  specify to configure --enable-mt and --with-qt-dir=... )

* Mon Apr 1 2002 Simon Edwards <simon@simonzone.com> 1.9.14-1mdk

- 1.9.14 release
- Now correctly detects which filter system is being using on 2.5 kernels.
- Moved NNTP to the Mail section.
- Small fix to Windows Networking (NETBIOS).
- Added Kerberos, klogin, kshell, NIS, IMAPS, POP3S, ISAKMP.

* Fri Mar 8 2002 Simon Edwards <simon@simonzone.com> 1.9.13-1mdk

- 1.9.13 release
- Something happened when I made the last tar ball which corrupted
  the networkprotocoldb.xml file by one character. (honest!) I'm
  rereleasing 1.9.12 basically with this new version name to avoid
  confusion.

* Thu Mar 7 2002 Simon Edwards <simon@simonzone.com> 1.9.12-1mdk

- 1.9.12 release.
- Should work ok with recent autoconf versions now, and will probably
  work on KDE3 too. (Thanks to Carsten Pfeiffer)
- No longer requires that packets creating a NEW tracked connection have
  thier SYN bit set. It can now pick up previously dropped (tracked)
  connections. (Blocking !SYN was causing too many log entries and a bit of
  trouble elsewhere).
- Added CDDB, MSN Messenger, VNC and PPTP support.

* Wed Feb 20 2002 Simon Edwards <simon@simonzone.com> 1.9.11-1mdk

- 1.9.11 release
- Bugfix: Now doesn't try to enforce the Strong ES model. Linux 2.2 and 2.4
  as it turns out, use the weak model.
- Fixed a nasty flaw in the way UDP reply packets were handled.
  (Thanks to Sander Plomp for noticing this).
- Added control over TCP timestamps usage (defaults to off).
- Windows Networking (NETBIOS) fixes.
- Small SSH fix.
- Added support for Telstra's BigPond Cable authentication/heartbeat.
- Changed the GUI layout on the Protocol tab. Hopefully it's clearer now.
- Additions to the manual.

* Thu Jan 17 2002 Simon Edwards <simon@simonzone.com> 1.9.10-1mdk

- 1.9.10 release.
- A "Restore to factory defaults" button.
- Small changes to some of the text strings in the GUI.
- Explicitly requests /bin/bash when running the scripts from the GUI.
- Additions and improvements to the manual.

* Thu Dec 20 2001 Simon Edwards <simon@simonzone.com> 1.9.9-1mdk

- 1.9.9 release.
- Fixed a small bug in the DHCP rules. (It was blocking lease refreshes on
  Win).
- Fixed ipchains support, looks like it's been broken for a while.
- Resetting the network subsystem now handles ipchains or iptables in
  /usr/sbin/ too.
- Added AudioGalaxy and DirectPlay (most Microsoft games), Halflife support.
- Fixed a tiny crash bug in the case where the protocol DB file can't be
  found.
- Made the source port usage info in the protocol DB tighter.
- Looks for ipchains/iptables in /usr/local/sbin too.

* Thu Nov 29 2001 Simon Edwards <simon@simonzone.com> 1.9.8-1mdk

- 1.9.8 release.
- Added proper multi-language support to the protocol DB.
- Fixed a nasty bug in the generated firewall scripts that could cause
  the machine to appear to hang at boottime.
- Fix a small design bug concerning the user defined protocols. (Accepts
  any source port now, instead of just ones in the dynamic range).
- Guarddog now looks for ipchains or iptables in /usr/sbin/.

* Mon Nov 19 2001 Simon Edwards <simon@simonzone.com> 1.9.7-1mdk

- 1.9.7 release.
- The README file has been updated. Please read it.
- Firewall script now returns a proper exit code.
- Fixed Diablo II protocol entry. (I hope)
- Added Microsoft's "SMB over TCP" protocol to the DB.
- Added XDMCP to the DB.
- The iptables part now only accepts NEW state tracking entries that are SYN
  packets.
- Fixed a buglet where clicking 'Ok' is the firewall disabled didn't exit the
  program after reseting the network subsystem.
- Added DHCP support to the "Advanced" tab. (Thanks to Ludovic Lange for the
  patch).
- Added "Log Aborted TCP connections" option. This can detect half-open
  stealth scans. (Now every nmap scan type can be logged).
- Specifies the log level to iptables as a number. (iptables>=1.2.3 wants a
  number)
- Scripts now explictly use bash instead of just plain sh. (bash is the
  official standard linux shell anyway).
- Fixed NFS support.
- Scripts now explicitly use gawk(1) instead of just plain awk(1).
- Fixed a problem that would stop the firewall script from working properly
  for people who use a language setting other than English. (thanks to
  Ludovic Lange detecting submitting a patch for this).

* Fri Sep 28 2001 Simon Edwards <simon@simonzone.com> 1.9.6-1mdk

- 1.9.6 release.
- Fixed a bug that would cause Guarddog to crash if you pressed ctrl+u while
  editing an address.
- Removed use of ++ in the firewall script.
- Added the netbios port 138 stuff to the DB and rolled all the netbios
  entries into just one entry: Windows Networking.
- Renamed "Authentication" in the DB to the more accurate "ident/auth".
- Added LDAP, LDAP-SLL, SWAT, Diablo II, IPP and Nessus to the DB.
- Should handle broadcast packets better. (Your logs should not fill up with
  netbios/smb broadcasts).
- Firewall script doesn't make as many assumptions about which directories
  the unix tools live in.

* Wed Aug 29 2001 Simon Edwards <simon@simonzone.com> 1.9.5-1mdk

- Small clean ups.
- The "Advanced Protocol Help" now works.
- Fixed a nasty bug in the definition for ICQ that leaving the firewall
  wide open.
- Fixed the annoying "[: -eq: unary operator expected" buglet that some
  people were seeing.
- Fixed to work when virtual interfaces are defined.
- Now handles NIC broadcast addresses properly.
- Added code to enforce the Strong ES model (RFC 1122 section 3.3.4.2).
- Now correctly avoids trying to use DNS when there are no decent NICs
  available. (This was causing slow reboots with iptables complaining when
  it could not resolve host names).
- Added the ability to Import/Export the firewall script to the Advanced tab.
  It also has a "Description" text box for the benefit of people who want to
  juggle firewalls for several machines.
- Since adding Import/Export of firewall scripts, it has become meaningful to
  run Guarddog as a non-root user to create scripts to be used elsewhere.
  It is now possible to run Guarddog as a mere mortal with reduced
  functionality.
- Reformatted the changelog.

* Sun Aug 12 2001 Simon Edwards <simon@simonzone.com> 1.9.4-1mdk
- No long uses the konsole to run the firewall script in. Guarddog now has
  it's own window that it can run the firewall and other scripts in. When run,
  the firewall script was says what it is doing. Much friendlier.
- Gnutella and NetMeeting support added.
- Fixed a small bug that sometimes caused the same modprobe command to output
  multiple times.
- Fixed a bug that was causing configuration to get scrambled when read in.

* Thu Jul 9 2001 Simon Edwards <simon@simonzone.com> 1.9.3-1mdk
- Fixed a crash if you click to the right of the checkboxes on
  the protocol page.
- Fixed a bug that would cause Guarddog to fail to read the
  existing firewall if it doesn't contain at least one user defined zone.
- Add 'Connections' list which allows the user to select which zones the
  current zone should be connected to.
- Rearranged the GUI somewhat. It's now much better layed out and sports
  icons and symbolic hints in places.
- Added builtin help box on the protocol panel. Shows information and help
  about a given protocol.
- Also replaced a lot of input boxes in the GUI with spinboxes.

* Sat Jun 16 2001 Simon Edwards <simon@simonzone.com> 1.9.2-2mdk
- The last rpm from me had a dependancy problem. RPM saw that my opengl
  library was using the Nvidia libGLcore.so library so it thought that
  everyone should have a libGLcore.so install reguardless of which driver
  they actually use. grrrr. Why RPM thinks it should list the dependancies
  of my particular libGL.so in with the final package is beyond me. Anyway,
  This spec file is the same as the 1.9.2-1mdk one except that on my system
  I've hacked my /usr/lib/rpm/find-requires script to *never* list
  libGLcore.so. Works, but it's not a great solution. The generated RPM file
  will no longer demand a libGLcore.so...

* Thu Jun 14 2001 Simon Edwards <simon@simonzone.com> 1.9.2-1mdk
- Netfilter/iptables is now supported. The generated firewalls use either
  ipchains or iptables automatcially at run time. It also uses
  iptables state tracking modules to handle annoying things like FTP. This
  provides a *much* tighter firewall than old ipchains.
- Advanced logging also part of the new iptables support, including rate
  limited logging and even log messages to warn when rate limiting is in
  effect. Reflected in the GUI is a whole new tab pane dedicated to logging.
- The address lists now happily accept domain names instead of just IP
  addresses.
- Also fixed a nasty bug in the ipchains firewall that was causing the wrong
  zone policies to be applied to packets. We don't call these a development
  versions for nothing folks!
- The RPM creates two small scripts in /etc/ppp to make sure that the
  firewall is run when every a PPP interface goes up or down. This is a
  workaround for a bug in the PPP scripts.

* Wed May 9 2001 Simon Edwards <simon@simonzone.com> 1.9.1-1mdk
- Protocols can now be set to either Deny/Accept and now also Reject.
- It is now possible to specify user defined protocols. i.e. open/close
  specific ports.
- 'printer', 'syslog' and 'ntp' have now been added to the network protocol
  database.

* Mon Apr 14 2001 Simon Edwards <simon@simonzone.com> 1.9.0-1mdk
- The first developer release aiming at version 2.0. The 1.9.0
  and higher code is a rewrite and redesign.  Significant changes are the use
  of XML to store a database of information about network protocols. The work
  and code is also shared with Watchdog. I intend to fully document the XML
  format I've designed in the hope that others will find it useful and support
  it. Guarddog now has the concept of 'zones' which allow you to place
  different hosts and networks into groups which can then have different
  firewall policies. Router configurations are a target for 2.0, but this
  development version still doesn't support them, yet.

* Wed Jan 17 2001 Simon Edwards <simon@simonzone.com> 1.0.0-1mdk
- No real changes except for updates and additions to the documentation.

* Fri Dec 22 2000 Simon Edwards <simon@simonzone.com> 0.9.5-1mdk
- Generated firewalls now setup the kernel networking protection.
- Generated firewalls are now tighter, only opening the Local Port range
  instead of all non-privileged ports where appropriate.
- Added option to always Reject Auth requests. (This can speed up POP connections).

* Thu Nov 30 2000 Simon Edwards <simon@simonzone.com> 0.9.4-1mdk
- Small fix for ISDN users. (Thanks to Joerg Buchland).

* Tue Nov 22 2000 Simon Edwards <simon@simonzone.com> 0.9.3-1mdk
- Now requires KDE 2.
- Most of the GUI code has been rewritten for KDE 2.
- GUI has also been cleaned up somewhat.
- It also attempts to automatically identify which interface is
  being used to access the net. (Thanks to J. F. Gratton).
- Added an option to completely disable the firewall.

* Mon Sep 2 2000 Simon Edwards <simon@simonzone.com> 0.9.2-1mdk
- RealPlayer support added.
- Small changes to the GUI to fix a few layout problems. Still
  not perfect, but much better.
- Manual is much more complete now. Now has a tutorial and FAQ section.

* Sun Jul 16 2000 Simon Edwards <simon@simonzone.com> 0.9.1-2mdk
- Fixed a small bug in the menu entry to Guarddog.

* Tue Jul 11 2000 Simon Edwards <simon@simonzone.com> 0.9.1-1mdk
- 0.9.1 release.
- Packaged with RPM for Mandrake 7.1 (should also work with Redhat).
- Some display glitch fixes, still more remain, grrr.
- Should now be able to find the protocol database file ok. Sorry to those people
  who tried to get it to run from source and failed.
- Uses sane defaults for checkboxes in new firewalls.
