/* 
 * Metronome options object functions
 *
 * This file is part of GTick
 * 
 *
 * Copyright (c) 1999, Alex Roberts
 * Copyright (c) 2003, Roland Stigge <stigge@antcom.de>
 *
 * GTick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GTick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GTick; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
#include <config.h>

/* GNU headers */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* own headers */
#include "globals.h"
#include "options.h"
#include "option.h"

/*
 * returns a new options_t object
 */
options_t* options_new(void) {
  options_t* result;
    
  if (!(result = calloc(1, sizeof(options_t)))) {
    fprintf(stderr,
	    "options_new: Error allocating memory for options_t structure.\n");
    exit(1);
  }

  result->option_list = option_list_new();

  return result;
}

/*
 * destroys an options_t object
 */
void options_delete(options_t* options) {
  option_list_delete(options->option_list);
  free(options);
}

