/*
 * Preview widget header
 * A toplevel window to show groach preview.
 * This provides only a drawable window for groach controller.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __PREVIEW_H__
#define __PREVIEW_H__

#include <libgnomeui/gnome-dialog.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_PREVIEW				(preview_get_type())
#define PREVIEW(obj)				GTK_CHECK_CAST(obj, preview_get_type(), Preview)
#define PREVIEW_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, preview_get_type(), PreviewClass)
#define IS_PREVIEW(obj)				GTK_CHECK_TYPE(obj, preview_get_type())
#define IS_PREVIEW_CLASS(klass)		(GTK_CHECK_CLASS_TYPE((klass), TYPE_PREVIEW))
	
	
typedef struct _Preview       Preview;
typedef struct _PreviewClass  PreviewClass;

struct _Preview {
	GnomeDialog dialog;

	GtkDrawingArea *darea;
};

struct _PreviewClass {
	GnomeDialogClass parent_class;
};


GtkType preview_get_type(void);
GtkWidget* preview_new(void);

/* Macros */
#define preview_get_gdkwin(preview)	\
	(GTK_WIDGET(PREVIEW(preview)->darea)->window)
#define preview_get_widget(preview)	\
	(GTK_WIDGET(PREVIEW(preview)->darea))


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __PREVIEW_H__ */
