/*
 * Invisible window module
 * Refer to inviswin.h about details.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include "inviswin.h"

/**
 * invis_win_new:
 **/
InvisWin*
invis_win_new(const GroWindow *gro_win)
{
	InvisWin *invis;
	GtkWidget *invis_w;

	g_return_val_if_fail(gro_win != NULL, NULL);
	
	invis = g_new(InvisWin, 1);

	invis_w  = gtk_invisible_new();
	invis->invis_w = GTK_INVISIBLE(invis_w);
	gtk_widget_set_events(invis_w, GDK_BUTTON_PRESS_MASK);
		
	invis_win_show(invis);

	gdk_window_move_resize(invis_w->window, 0, 0,
						   gro_window_width(gro_win), gro_window_height(gro_win));

	return invis;
}

void
invis_win_delete(InvisWin *invis)
{
	g_return_if_fail(invis != NULL);
	
	gtk_object_unref(GTK_OBJECT(invis->invis_w));
	g_free(invis);
}

/**
 * invis_win_show:
 * Invisible widget is still invisible after gtk_window_show.
 * Lower the window here.
 **/
void
invis_win_show(InvisWin *invis)
{
	GtkInvisible *invis_w;

	g_return_if_fail(invis != NULL);

	invis_w = invis->invis_w;
#ifdef DEBUG	
	g_print("invisible show\n");
#endif
	gtk_widget_show(GTK_WIDGET(invis_w));
	gdk_window_lower(GTK_WIDGET(invis_w)->window);
}

/**
 * invis_win_hide:
 * Call gtk_widget_hide for invisible widget.
 **/
void
invis_win_hide(InvisWin *invis)
{
	GtkInvisible *invis_w;

	g_return_if_fail(invis != NULL);

	invis_w = invis->invis_w;
#ifdef DEBUG	
	g_print("invisible hide\n");
#endif
	gtk_widget_hide(GTK_WIDGET(invis_w));
}
