/*
 * GUI misc functions header
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GRO_GUIMISC_H__
#define __GRO_GUIMISC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* define pi */
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif  /*  M_PI  */

/* Return a random number between 0 and (n-1)	*/
#define RAND_INT(n)  ((gint)((gdouble)(n) * rand()/(RAND_MAX+1.0)))


/* Global function declarations */
extern gboolean is_rect_in_rect(const GdkRectangle *obj, const GdkRectangle *area);
extern gboolean is_rect_intersect(const GdkRectangle *obj1, const GdkRectangle *obj2);
extern gboolean is_rect_point_in(const GdkRectangle *rect, gint x, gint y);

/* Inline functions to reduce declarations of temporary variables */
static inline gint
_gdk_window_get_width(GdkWindow *window)
{
	gint width;
	gdk_window_get_size(window, &width, NULL);
	return width;
}

static inline gint
_gdk_window_get_height(GdkWindow *window)
{
	gint height;
	gdk_window_get_size(window, NULL, &height);
	return height;
}

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GRO_GUIMISC_H__ */
