/***************************************************************************
                          muscle.pl  -  description
                             -------------------
    begin                : Thu Apr 11 2002
    copyright            : (C) 2002 by Renaud Mariana
    email                : rmariana@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


:-foreign(scard_establish_context_C(+string, -positive)).
:-foreign(scard_list_readers_C(+positive, term)).
:-foreign(scard_get_status_change( +positive, +string, +positive, -positive),[fct_name('scard_get_status_change_C')]).
:-foreign(scard_connect_C(+positive, +string, -positive, term)).
:-foreign(scard_disconnect( +positive),[fct_name('scard_disconnect_C')]).
:-foreign(scard_release_context_C(+positive)).
:-foreign(scard_transmit_C( +positive, +string, +term, +term, -positive)).
:-foreign(scard_status_C( +positive, -positive, term)).

:- dynamic(scard_current/4).		
:- dynamic(scard_verbose/0).		




scard_establish_context :-
	scard_establish_context(localhost, _).

scard_establish_context(Host) :-
	scard_establish_context(Host, _).


scard_establish_context(_, HContext) :-
	nonvar(HContext),
	'$pl_err_type'(variable, HContext).
	
scard_establish_context(Host, HContext) :-
	set_bip_name(scard_establish_context, 2),
	scard_establish_context_C(Host, HContext),
	retractall(scard_current(_, _, _, _)),
	assertz(scard_current(HContext, _, _, _)),
	scard_print_trace('scard_establish_context succeeds').



scard_release_context :-
	scard_current(HContext, _, _, _), !,
	scard_release_context(HContext).

% HContext not initialized
scard_release_context :-
	'$pl_err_instantiation'.

scard_release_context(HContext) :-
  scard_release_context_C(HContext),
	retractall(scard_current(_, _, _, _)),
	scard_print_trace('scard_release_context succeeds').



scard_state('SCARD_STATE_UNAWARE'    , 0x0000).	% App wants status     
scard_state('SCARD_STATE_IGNORE'     , 0x0001). % Ignore this reader   
scard_state('SCARD_STATE_CHANGED'    , 0x0002).	% State has changed    
scard_state('SCARD_STATE_UNKNOWN'    , 0x0004).	% Reader unknown       
scard_state('SCARD_STATE_UNAVAILABLE', 0x0008).	% Status unavailable   
scard_state('SCARD_STATE_EMPTY'      , 0x0010).	% Card removed         
scard_state('SCARD_STATE_PRESENT'    , 0x0020). % Card inserted        
scard_state('SCARD_STATE_ATRMATCH'   , 0x0040). % ATR matches card 	
scard_state('SCARD_STATE_EXCLUSIVE'  , 0x0080). % Exclusive Mode       
scard_state('SCARD_STATE_INUSE'      , 0x0100). % Shared Mode          
scard_state('SCARD_STATE_MUTE'       , 0x0200). % Unresponsive card    

%	xor_state(L, 0, Xor) Xor is the result of xoring every value of L
% use: private
'$xor_state'([],Xor, Xor):- ! .
'$xor_state'([S|L],Xor1, Xor):-
	scard_state(S, Val),
	( var(Xor) ->
			nonvar(S),
			Xor2 is Val \/ Xor1
	;
			Xor2 is Val ^ Xor1,
			Xor2 < Xor1
	),
	!, '$xor_state'(L, Xor2, Xor).



scard_get_status_change(CurrState, EvtState) :-
	scard_list_readers([Reader|_]),
	scard_get_status_change(Reader, CurrState, EvtState),
	scard_print_trace('scard_get_status_change succeeds').

scard_get_status_change(ReaderName, CurrState, EvtStateL) :-
	scard_current(HContext, _, _, _), !,
	'$xor_state'(CurrState, 0, Xor),
	scard_get_status_change(HContext, ReaderName, Xor, EvtState),
	'$xor_state'(EvtStateL, EvtState, 0).

% HContext not initialized
scard_get_status_change(_, _, _) :-
	'$pl_err_instantiation'.



scard_list_readers(Readers) :-
	scard_current(HContext, _, _, _), !,
	scard_list_readers(HContext, Readers).

% HContext not initialized
scard_list_readers(_) :-
	'$pl_err_instantiation'.
	
scard_list_readers(HContext,Readers) :-
	set_bip_name(scard_list_readers,2),
	( partial_list(Readers) ->
			true
	;   '$pl_err_type'(list, Readers)
	),
	
	scard_list_readers_C(HContext, Readers).



scard_connect :-
	scard_list_readers([Reader|_]),
	scard_connect(Reader).
	
scard_connect(Reader) :-
	scard_connect(Reader, _, _).

scard_connect(Reader, HCard, Proto) :-
	scard_current(HContext, _, _, _), !,
	scard_connect(HContext, Reader, HCard, Proto).

% HContext not initialized
scard_connect(_, _, _) :-
	'$pl_err_instantiation'.

scard_connect(_, _, HCard, _) :-
	nonvar(HCard),
	'$pl_err_type'(variable, HCard).

scard_connect(HContext, ReaderName, HCard, Proto) :-
	set_bip_name(scard_connect,4),
	( scard_connect_C(HContext, ReaderName, HCard, Proto) ->
			% update current context
			retractall(scard_current(_, _, _, _)),
			assertz(scard_current(HContext, HCard, Proto, _)),
			scard_print_trace('scard_connect succeeds')
	;
			scard_print_trace('scard_connect failed'),
			fail
	).



scard_disconnect :-
	scard_current(HContext, HCard, _, _),	!,
	set_bip_name(scard_disconnect,1),

	(   scard_disconnect(HCard) ->
			retractall(scard_current(HContext, HCard, _, _)),
			assertz(scard_current(HContext, _, _, _)),
			scard_print_trace('scard_disconnect succeeds')
	;
			scard_print_trace('scard_disconnect failed'),
			fail
	).

% HContext, HCard  not initialized
scard_disconnect :-
	'$pl_err_instantiation'.
	


scard_status(Status, Atr) :-
	scard_current(_, HCard, _, _), !,
	scard_status(HCard, Status, Atr).

% HCard not initialized
scard_status(_, _) :-
	'$pl_err_instantiation'.

scard_status(HCard, Status, Atr) :-
	scard_current(HContext, HCard, Proto, _), !,

  scard_status_C(HCard, Status, Atr),
	retractall(scard_current(_, _, _, _)),
	assertz(scard_current(HContext, HCard, Proto, Atr)).

% HContext  not initialized
scard_status(_, _, _) :-
	'$pl_err_instantiation'.



scard_transmit(ApduIn, ApduOut, Sw, Time) :-
	scard_current(_, HCard, Protocol, _), !,
	scard_transmit(HCard, Protocol, ApduIn, ApduOut, Sw, Time).

% HCard, Protocol not initialized
scard_transmit(_, _, _, _) :-
	'$pl_err_instantiation'.
	
scard_transmit(HCard, Protocol, IN, ApduOut, Sw, Time) :-
	set_bip_name(scard_transmit,6),
	( list(IN) -> true
	;   print(IN), nl, '$pl_err_instantiation'	),
	
	(   atom(Protocol) ->	true
	;
%			print('Protocol not specified, see scard_connect/4.'),
			'$pl_err_instantiation'
		),

	scard_transmit_C(HCard, Protocol, IN, OUT, Time),
	
	( scard_verbose ->
			hexatom_list(In, IN), hexatom_list(Out, OUT),
			format('tr: ~a - ~a, t= ~dms.~n', [In, Out, Time])
	;
			true
	),
	
	length(OUT, Le),
	
	(  Le <2 ->
			hexatom_list(Out, OUT),
			format('error: card response is ~a~n', [Out]), fail
	;
			length(Sw, 2), append(ApduOut, Sw, OUT),!
	).



scard_enable_verbose(true):-
	retractall(scard_verbose),
	assertz(scard_verbose).

scard_enable_verbose(false):-
	retractall(scard_verbose).	


scard_print_trace(Msg):-
	( scard_verbose ->
			print(Msg), !
	; true
	).



pcsc_error((system_error(Error), Y)) :-
	print('***'), print(Error),print(' '), print(Y).

pcsc_error(error(system_error(Err), _) ) :-
	print('***'), print(Err), print(' ').
