/*
 *  gpppon, a gnome applet for controlling ppp.  
 *  Copyright (C) 1999 John G. Hasler
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *  or contact the author.
 *
 *  This program was written by John Hasler (john@dhh.gt.org).  It is based on
 *  gpppwrap by Guido Socher (guido.s@writeme.com).
 */


/* Note: update the date/rev. in the abouttxt */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/wait.h>
#include <gtk/gtk.h>
#ifndef GPPPOFF
#define GPPPOFF "/usr/bin/poff"
#endif
#ifndef GPPPON
#define GPPPON "/usr/sbin/pppd"
#endif

static gchar abouttxt[] = "gpppon version 0.2 Dec 30 1999\n\
Written by John Hasler <john@dhh.gt.org> based on\n\
gpppwrap version 0.4, 01 Nov. 1999 by Guido Socher\n\
(guido.s@writeme.com)\n\
This program is distributed under the terms of the GNU\n\
public license. gpppon provides a simple GUI wrapper\n\
around the powerful and flexible pon/poff commands.\n\
gpppon reads the names of providers from\n\
/etc/ppp/peers. gpppon calls the pon\n\
script with the selected provider name as argument.";


static gchar helptxt[] = "Select a provider from the combo-box\n\ 
Press ppp-on to start the ppp connection. To terminate\n\
the connection just press ppp-off. This program does\n\
not check whether or not the ppp connection is actually\n\
up. As it may take some time to dial in or terminate\n\
the connection you should not switch too fast between\n\
ppp-on and ppp-off.";
/* " This is here because emacs has buggy syntax coloring */

static int gppp_state = 0;	/* 0 unknown, 1 ppp on, 2 ppp off */

/* this is because I am lazy */
static GtkWidget *mw_txt_label;


static GList *
get_provider_names ()
{
  static GList *list;
  char *string;
  int i = 0;
  int error;
  DIR *peers;
  struct dirent *entry;
  list = NULL;

  peers = opendir ("/etc/ppp/peers");
  if (!peers) {
    perror ("Gpppon: /etc/ppp/peers");
    gtk_exit (1);
  }
    
  while ((entry = readdir (peers)))
    {
      if (isgraph (entry->d_name[0]) && entry->d_name[0] != '.')
	{
	  string = malloc (sizeof (entry->d_name));
	  strcpy (string, entry->d_name);
	  list = g_list_append (list, string);
	}
      i++;
    }

  error = closedir (peers);
  if (error) {
    perror ("Gpppon:");
    gtk_exit (1);
  }

  if (i == 0)
    {
      list = g_list_append (list, string);
      list = g_list_append (list, "");
    }
  return (list);
}

/*
 * destroy the popup window
 */
static gint
ppp_popup_destroy (GtkWidget * widget, GtkWidget * data)
{
  if (data == NULL)
    return (TRUE);		/*already dead */
  gtk_widget_destroy (GTK_WIDGET (data));
  data = NULL;
  return (TRUE);
}

/*
 * show a dialog window a text label and an ok button to click 
 * the window away.
 * The text must contain already the necessary newline characters. 
 */
static void
ppp_popup (GtkMenuItem * menuitem, gchar * text)
{
  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *label;

  window = gtk_dialog_new ();
  /* the minimum size: Width, Hight */
  gtk_widget_set_usize (GTK_WIDGET (window), 320, 220);
	/*- button -*/
  button = gtk_button_new_with_label ("Ok");
  /* expand, fill and padd by 10 off the border */
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area),
		      button, TRUE, TRUE, 10);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (ppp_popup_destroy), (gpointer) window);
  gtk_widget_show (button);
	/*- label -*/
  label = gtk_label_new (text);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), label, TRUE,
		      TRUE, 0);
  gtk_widget_show (label);
	/*- dialog is ready -*/
  gtk_widget_show (window);
}

/*
 * run command
 * Command must hold the absolute path to the executable.
 */
static int
run_cmd (const char *command, const char *arg1, const char *arg2, const char *arg3)
{
  int pid, status;
  char *arglist[5];
  char cmdstr[100];
  char *env[] = { "PATH=/sbin:/bin:/usr/sbin:/usr/bin", NULL };

  if (command == 0)
    return (1);
  if (strlen (command) + strlen (arg1) + strlen(arg2)  + strlen(arg3)> 90)
    return (1);
  if (access (command, F_OK))
    {
      g_warning ("gpppon: file %s does not exist\n", command);
      return (1);
    }
  strncpy (cmdstr, command, 99);
  pid = (int) fork ();
  if (pid < 0)
    return (-1);
  if (pid == 0)
    {
      /*child */
      arglist[0] = cmdstr;	/*just sets the name for ps */
      arglist[1] = arg1;
      arglist[2] = arg2;
      arglist[3] = arg3;
      arglist[4] = 0;
      execve (cmdstr, arglist, env);
      /*we get here only in case of error */
      perror ("gpppon");
    }
  /*parent */
  /*wait for child to avoid zombie, should be fast as
   *we tell the shell to fork in background*/
  if (waitpid (pid, &status, 0) != pid)
    {
      g_warning ("gpppon: waitpid failed\n");
      return (1);
    }
  status >>= 8;
  return (status);
}

/*
 *Squirrel away the name of the active provider and return it on demand 
*/
gchar *
provider (int task, gchar * name)
{
  static gchar provider[256];
  if (task == TRUE)
    {
      strncpy (provider, name, 255);
    }
  return (provider);
}

/*
 * the action associated with the ppp-off button
 */
static gint
ppp_off_action (GtkWidget * widget, GtkWidget * entry)
{
  /*check if we are already off */
  gchar *txt, *name;
  if (gppp_state == 2)
    {
      gtk_label_set (GTK_LABEL (mw_txt_label), "Forced ppp-off");
    }
  else
    {
      gtk_label_set (GTK_LABEL (mw_txt_label), "State is: off ");
    }
  gppp_state = 2;		/*set state to off */
  txt = gtk_entry_get_text (GTK_ENTRY (entry));

  name = provider (FALSE, "");
  run_cmd (GPPPOFF, name, "", "");
  return (TRUE);
}

/*
 * the action associated with the ppp-on button
 */
static gint
ppp_on_action (GtkWidget * widget, GtkWidget * entry)
{
  /* there is no phone number longer than DATABUFLEN-1 digits */
  gchar *txt;
  gchar message[256];
  int status;

  /* check if we are already on */
  if (gppp_state == 1)
    {
      gtk_label_set (GTK_LABEL (mw_txt_label), "Already on    ");
      return (TRUE);
    }
  gppp_state = 1;		/* set state to on */
  txt = gtk_entry_get_text (GTK_ENTRY (entry));

  provider (TRUE, txt);

  gtk_label_set (GTK_LABEL (mw_txt_label), "Dialing  ");
  status = run_cmd (GPPPON, "call", txt, "updetach");
  sprintf(message, "status = %d", status);
gtk_label_set (GTK_LABEL (mw_txt_label), message);
  return (TRUE);
}

/*
 * quit the whole application
 */
static void
byebye (GtkWidget * widget, gpointer data)
{
  gtk_exit (0);
}

int
main (int argc, char *argv[])
{

  GtkWidget *mainwindow;
  GtkWidget *the_file_menu, *file_menu;
  GtkWidget *the_help_menu, *help_menu;
  GtkWidget *menu_items, *menu_bar;
  GtkWidget *combobox;
  GtkEntry *combobox_entry;
  GList *combobox_items;
  GtkWidget *button_on, *button_off;
  GtkWidget *vbox, *box1, *box2, *box3, *labelbox;


  /* parse GTK command line and take out gtk args. The rest is
   * still in argv[] */
  gtk_init (&argc, &argv);


  mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  /* for some reason this does not work with my fvwm WM: */
  /*gtk_widget_set_uposition(GTK_WIDGET(mainwindow),10,110); */
  /* minimum size */
  gtk_widget_set_usize (GTK_WIDGET (mainwindow), 290, 78);
  gtk_window_set_title (GTK_WINDOW (mainwindow), "gpppwrap");
  /* handle delete_event, usually by the 'close' option */
  gtk_signal_connect (GTK_OBJECT (mainwindow), "delete_event",
		      GTK_SIGNAL_FUNC (byebye), NULL);
  gtk_signal_connect (GTK_OBJECT (mainwindow), "destroy",
		      GTK_SIGNAL_FUNC (byebye), NULL);


  /* set up the boxes to do the packing: */
  vbox = gtk_vbox_new (FALSE, 0);	/* 0=no border */
  box1 = gtk_hbox_new (FALSE, 1);
  box2 = gtk_hbox_new (FALSE, 1);
  box3 = gtk_hbox_new (FALSE, 1);
  gtk_box_pack_start (GTK_BOX (vbox), box1, TRUE, TRUE, 0);
  /* put a little space between the 3 boxes: */
  gtk_box_pack_start (GTK_BOX (vbox), box2, TRUE, TRUE, 4);
  gtk_box_pack_start (GTK_BOX (vbox), box3, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (mainwindow), vbox);


  /* This is the file menu on the left. First we construct
   * the_file_menu which is the actual popup window part */
  the_file_menu = gtk_menu_new ();
  menu_items = gtk_menu_item_new_with_label ("Quit");
  gtk_menu_append (GTK_MENU (the_file_menu), menu_items);
  gtk_signal_connect_object (GTK_OBJECT (menu_items), "activate",
			     GTK_SIGNAL_FUNC (byebye), NULL);
  /* Show the menu entry */
  gtk_widget_show (menu_items);

  /* lable of the menu */
  file_menu = gtk_menu_item_new_with_label ("File");
  /* attach the_file_menu to the label */
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (file_menu), the_file_menu);
  gtk_widget_show (file_menu);

  /* This is the help menu on the left. First we construct
   * the_help_menu which is the actual popup window part */
  the_help_menu = gtk_menu_new ();
  menu_items = gtk_menu_item_new_with_label ("About");
  gtk_menu_append (GTK_MENU (the_help_menu), menu_items);
  gtk_signal_connect (GTK_OBJECT (menu_items), "activate",
		      GTK_SIGNAL_FUNC (ppp_popup), (gpointer) abouttxt);
  /* Show the menu entry */
  gtk_widget_show (menu_items);
  menu_items = gtk_menu_item_new_with_label ("Help");
  gtk_menu_append (GTK_MENU (the_help_menu), menu_items);
  gtk_signal_connect (GTK_OBJECT (menu_items), "activate",
		      GTK_SIGNAL_FUNC (ppp_popup), (gpointer) helptxt);
  /* Show the menu entry */
  gtk_widget_show (menu_items);

  /* lable of the menu */
  help_menu = gtk_menu_item_new_with_label ("Help");
  /* attach the_help_menu to the label */
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (help_menu), the_help_menu);
  gtk_widget_show (help_menu);

  /* now come the actual menu bar. we must connect the menu label to it */
  menu_bar = gtk_menu_bar_new ();
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), file_menu);
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), help_menu);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (help_menu));

  /* pack: expand and fill no padd */
  gtk_box_pack_start (GTK_BOX (box1), menu_bar, TRUE, TRUE, 0);
  /* menu ready */
  gtk_widget_show (menu_bar);


  /* the text in the main window */
  mw_txt_label = gtk_label_new ("ppp-on/off");
  labelbox = gtk_hbox_new (FALSE, 0);
  /* make the label big enough be putting a box arround it
   * the hight does not matter as it is minimum size values: */
  gtk_widget_set_usize (GTK_WIDGET (labelbox), 88, 10);
  /* pack: expand, fill, padd 4 */
  gtk_box_pack_start (GTK_BOX (box2), labelbox, FALSE, FALSE, 4);
  /* put the label into the box: */
  gtk_container_add (GTK_CONTAINER (labelbox), mw_txt_label);
  gtk_widget_show (mw_txt_label);
  gtk_widget_show (labelbox);


  /* a combo box to enter and select providers */
  /* first add all providers to the list */
  combobox_items = get_provider_names ();
  combobox = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO (combobox), combobox_items);
  /* pack: expand, no fill, padd 5 */
  gtk_box_pack_start (GTK_BOX (box2), combobox, TRUE, TRUE, 4);
  combobox_entry = GTK_ENTRY (GTK_COMBO (combobox)->entry);
  gtk_widget_show (combobox);



  /* now comes the next row with the ppp-on/off buttons */
  button_on = gtk_button_new_with_label ("ppp-on");
  gtk_signal_connect (GTK_OBJECT (button_on), "clicked",
		      GTK_SIGNAL_FUNC (ppp_on_action),
		      (gpointer) combobox_entry);
  /* pack: expand, fill, padd 1 */
  gtk_box_pack_start (GTK_BOX (box3), button_on, TRUE, TRUE, 0);
  gtk_widget_show (button_on);

  button_off = gtk_button_new_with_label ("ppp-off");
  gtk_signal_connect (GTK_OBJECT (button_off), "clicked",
		      GTK_SIGNAL_FUNC (ppp_off_action),
		      (gpointer) combobox_entry);
  /* pack: expand, fill, padd 1 */
  gtk_box_pack_start (GTK_BOX (box3), button_off, TRUE, TRUE, 0);
  gtk_widget_show (button_off);


  /* yeaaaaa GUI is ready */
  gtk_widget_show (box1);
  gtk_widget_show (box2);
  gtk_widget_show (box3);
  gtk_widget_show (vbox);
  gtk_widget_show (mainwindow);

  /* go to main loop */
  gtk_main ();
  return 0;
}
