/*
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#ifndef TRACK_H
#define TRACK_H

#include <glib.h>
#include <config.h>
#include "snd.h"
#include "cache.h"
#include "block.h"
#include "rwlock.h"
#include "blocklist.h"

typedef enum {

    /* DUMMY is filler to equalize values with snd_clone_method */

    CLONE_DUMMY1,
    CLONE_DUMMY2,
    CLONE_DATA
} track_clone_method;

typedef struct _track {

    /* Read/write lock. The track_* functions acquire this lock when
       necessary, but if you require atomicity across multiple
       operations, you can acquire this lock for reading/writing
       yourself. */

    rwlock rwl;
    int frame_width;
    float graph_hres;
    struct blocklist *bl;
} track;

track *
track_new(int frame_width,
          AFframecount frame_count);

track *
track_clone(track *tr,
            track_clone_method method);

void
track_destroy(track *tr);

AFframecount
track_int32_frames_get(track *tr,
                       int32_t *int32_frame_bits,
                       AFframecount frame_offset,
                       AFframecount frame_count);

int
track_int32_frames_insert(track *tr,
                          int32_t *int32_frame_bits,
                          AFframecount frame_offset,
                          AFframecount frame_count);

int
track_int32_frames_replace(track *tr,
                           int32_t *int32_frame_bits,
                           AFframecount frame_offset,
                           AFframecount frame_count);


AFframecount
track_float_frames_get(track *tr,
                       float *float_frame_bits,
                       AFframecount frame_offset,
                       AFframecount frame_count);

int
track_float_frames_insert(track *tr,
                          float *float_frame_bits,
                          AFframecount frame_offset,
                          AFframecount frame_count);

int
track_float_frames_replace(track *tr,
                           float *float_frame_bits,
                           AFframecount frame_offset,
                           AFframecount frame_count);

AFframecount
track_graph_get(track *tr, 
                graph_bits_unit_t *lows,
                graph_bits_unit_t *highs,
                AFframecount frame_offset,
                AFframecount frame_count,
                float hres);

AFframecount
track_frames_get(track *tr,
                 frame_bits_t frame_bits,
                 AFframecount frame_offset,
                 AFframecount frame_count);

int
track_frames_insert(track *tr,
                    frame_bits_t frame_bits,
                    AFframecount frame_offset,
                    AFframecount frame_count);

GList *
track_delete(track *tr,
             AFframecount frame_offset,
             AFframecount frame_count);

int
track_insert(track *tr,
             GList *l,
             AFframecount frame_offset);

int
track_null_insert(track *tr,
                  AFframecount frame_offset,
                  AFframecount frame_count);

AFframecount
track_frame_count(track *tr);

#endif /* ! TRACK_H */
