#ifndef MODULE_H
#define MODULE_H

#include <glib.h>
#include <audiofile.h>
#include <config.h>
#include "undo.h"
#include "shell.h"
#include "action.h"
#include "iterator.h"

typedef int module_id;

#define MODULE_API_VERSION 0x0200
#define MODULE_MAGIC       0x4242

/* Macro to fill in module struct. */

#define MODULE_INIT(module, n, a, c) \
do { (module)->magic = MODULE_MAGIC; \
 (module)->version = MODULE_API_VERSION; \
 (module)->error = NULL; \
 (module)->name = (n); \
 (module)->author = (a); \
 (module)->copyright = (c); } while(0)

/* 
 * Module info. The module should return a pointer to this structure
 * (initialized using the MODULE_INIT macro) from its module_new()
 * function.
 */

typedef struct {
    int magic;
    int version;
    char *name;
    char *author;
    char *copyright;
    
    /* The module can use this field to store private data. */

    void *privdata;

    /* The module can use this field to signal initalization
       errors. */

    char *error;

    /* These are filled in by GNUsound. */
    
    char *fname;
    void *handle;
} module;

extern module modules[];

/*
 * Private functions.
 */

void
module_exit();

void
module_load(const char *path);

int
module_init();

/*
 * Module API.
 */

/*
 * Required. Called once to during module lifetime to initialize the
 * module. Module should return a structure initialized using the
 * MODULE_INIT() macro. If initalization fails, the module should
 * specify the error in the module->error parameter or return NULL.
 */

module *
module_new();

/*
 * Optional. Called once during module lifetime to destroy the module.
 * It should free all the resources allocated during module_new().
 */

void
module_destroy(module *mod);

/*
 * Optional. This function is called when the user performs the "open"
 * action on the module. It should set up the structure in
 * shl->module_state[id]. When this function is not defined, then
 * the module's module_execute() function will be called instead. It
 * is the responsibility of this function to display an interface
 * and dispatch the MODULE_EXECUTE action when necessary.
 */

void
module_open(module_id id,
            shell *shl, 
            int undo);

/*
 * Required if module_open() exists. Should tear down the structure in
 * shl->module_state[id].
 */

void
module_close(struct _module_state *module_state);

/*
 * Required. Invoked when the module should do its job. If the module
 * does not have a module_open() function, then this function is
 * invoked automatically. If the module does have a module_open()
 * function, then the module itself it responsible for invoking this
 * function. The id of the module can be retrieved by using
 * shl->active_module_id. This function should return an action_group
 * that can be applied to reverse the effects of the action, or NULL
 * if that is not possible.
 */

action_group *
module_execute(shell *shl, 
               int undo);

#endif /* ! MODULE_H */
