/*
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#ifndef MIXER_H
#define MIXER_H

#include <audiofile.h>
#include <config.h>

typedef struct {
    int target_channels;
    int source_channels;
    int is_unity;

    /* The number of channels that have "solo" activated. */

    int num_solos; 

    /* Array specifying for each source channel whether it is 
       in the "solo" set or not. */

    int32_t *source_is_solo;

    /* Array of source channels with either 0xFFFFFFFF or 0 for
       non-mute or mute respectively. */
    
    int32_t *source_is_mute;
    float **mixtable;
} mixer;

mixer *
mixer_new(int target_channels,
          int source_channels);

void 
mixer_destroy(mixer *m);

int
mixer_is_source_solo(mixer *m,
                     unsigned int source_channel);

int
mixer_is_source_mute(mixer *m,
                     unsigned int source_channel);

void
mixer_toggle_source_solo(mixer *m,
                         unsigned int source_channel);

void
mixer_toggle_source_mute(mixer *m,
                         unsigned int source_channel);

void
mixer_configure(mixer *m,
                int target_channels,
                int source_channels);

int
mixer_load(mixer *m,
           const char *path);

int
mixer_save(mixer *m,
           const char *path);

int
mixer_load_compat(mixer *m,
                  const char *path);

int
mixer_save_compat(mixer *m,
                  const char *path);

void
mixer_mux(mixer *m,
          frame_bits_t fb_target,
          frame_bits_t *fb_sources,
          int frame_width,
          AFframecount frame_count);

void
mixer_demux(frame_bits_t fb_target,
            frame_bits_t fb_source,
            int channel,
            int channel_count,
            int frame_width,
            AFframecount frame_count);

void 
mixer_buffers_free(int tracks,
                   frame_bits_t fb_downmix,
                   frame_bits_t *fb_sources);

frame_bits_t
mixer_buffers_alloc(int frame_width,
                    int tracks,
                    frame_bits_t *fb_downmix,
                    frame_bits_t *fb_sources,
                    AFframecount frame_count);

void 
mixer_dump(mixer *m);

#endif /* ! MIXER_H */
