/* 
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#ifndef CONFIG_H
#define CONFIG_H

#define _ISOC9X_SOURCE 1
#define _ISOC99_SOURCE 1

#include <inttypes.h>
#include <sys/types.h>
#include "defines.h"

#ifdef HAVE_GNOME2
#define GTK_DISABLE_DEPRECATED 1
#define GNOME_DISABLE_DEPRECATED 1
#define GLADE_FILE             "gnusound-2.glade"
#else
/* GNOME1 compatibility layer :) */
#define glade_xml_new(file, root, dummy) glade_xml_new(file, root)
#define g_signal_connect        gtk_signal_connect
#define g_signal_connect_object(obj, sig, callback, ptr, flags) gtk_signal_connect_object(obj, sig, callback, ptr)
#define gtk_spin_button_get_value gtk_spin_button_get_value_as_float
#define g_object_unref          gtk_object_unref
#define G_OBJECT                GTK_OBJECT
#define G_CALLBACK              GTK_SIGNAL_FUNC
#define g_object_set_data       gtk_object_set_data
#define g_object_get_data       gtk_object_get_data
#define gtk_progress_bar_set_fraction gtk_progress_set_percentage
#define GLADE_FILE              "gnusound.glade"
#endif

#ifndef LIBDIR
#define LIBDIR                  "/usr/lib"
#endif

#ifndef PIXMAPDIR
#define PIXMAPDIR               "/usr/share/pixmaps"
#endif

#define PRIMARY_GLADE_FILE      (GLADE_FILE)
#define SECONDARY_GLADE_FILE    (LIBDIR "/" GLADE_FILE)
#define MIXER_LEVEL_FILE        (PIXMAPDIR "/" PACKAGE "/lvl.xpm")
#define MIXER_MUTE_ON_FILE      (PIXMAPDIR "/" PACKAGE "/mute_on.xpm")
#define MIXER_MUTE_OFF_FILE     (PIXMAPDIR "/" PACKAGE "/mute_off.xpm")
#define MIXER_SOLO_ON_FILE      (PIXMAPDIR "/" PACKAGE "/solo_on.xpm")
#define MIXER_SOLO_OFF_FILE     (PIXMAPDIR "/" PACKAGE "/solo_off.xpm")

#define ICON_FILE               (PIXMAPDIR "/" PACKAGE "/gnusound-icon.png")
#define MODULE_PATH             ("modules:~/." PACKAGE "/modules:" LIBDIR "/modules")
#define MAX_MODULES                       50

/* Minimum scaling factor. */

#define HRES_MIN                      0.0625 /* inverse power of 2 */
#define HRES_MIN_SHIFT_BITS                4 /* bits to shift x to obtain ((1/x) * HRES_MIN)! */

/* Maximum scaling factor. Large scaling factors cause very slow
   redraw times. You can increase GRAPH_BITS_HRES to allow larger
   values here, but then you get worse performance at smaller scaling
   factors. */

#define HRES_MAX                       65536 /* power of 2 */
#define HRES_CUTOFF                    16384 /* what to consider a high scaling factor */

#define GRAPH_BITS_VRES                  256 /* pixels, has to fit in a graph_bits_unit_t */
#define GRAPH_BITS_HRES                  128 /* frames, power of 2 */

/* How many frames to move the player position to the right or to the
   left when scrubbing. */

#define SCRUB_AMOUNT                   32768 /* frames */

/* Number of frames to feed to processors. Too large = UI
   unresponsiveness, too small = block fragmentation = slower
   everything. */

#define EFFECT_BUF_SIZE                32768 /* frames */

/* The default number of frames per block. */

#define DEF_BLOCK_SIZE  (GRAPH_BITS_HRES * 4096) /* frames */
#define LOAD_BUF_SIZE       (DEF_BLOCK_SIZE / 4)
#define SAVE_BUF_SIZE      (DEF_BLOCK_SIZE / 16)
#define MAX_BCACHE_ENTRIES                25

#define MIXER_TOGGLES_MUTE_HEIGHT         15
#define MIXER_TOGGLES_MUTE_WIDTH          15
#define MIXER_TOGGLES_SOLO_HEIGHT         15
#define MIXER_TOGGLES_SOLO_WIDTH          15
#define MIXER_LEVEL_OFFSET_X              20 /* pixels */
#define MIXER_LEVEL_WIDTH                 40 /* pixels */
#define MIXER_LEVEL_HEIGHT                 9 /* pixels */
#define MARKER_HANDLE_SIZE                 8 /* pixels */
#define MARKER_CUEPOINT_HANDLE_SIZE       12 /* pixels */

/* This affects the number and size of the output buffers (fragments)
   in the soundcard driver. Larger/more fragments can mean fewer audio
   dropouts but longer delays. From the OSS handbook:
   
   "The argument to this call is an integer encoded as 0xMMMMSSSS (in
   hex). The 16 least significant bits determine the fragment
   size. [...] For example SSSS=0008 gives fragment size of 256 bytes
   (2^8). The minimum is 16 bytes (SSSS=4) and the maximum is
   total_buffer_size/2. Some devices or processor architectures may
   require larger fragments - in this case the requested fragment size
   is automatically increased. Large number of audio devices (the
   professional ones in particular) use fixed fragment size and it's
   possible that this ioctl call has no effect. The 16 most
   significant bits (MMMM) determine the maximum number of fragments."
   (oss.pdf, p. 98) */

#define DSP_FRAGS                 0x001a000a
#define DEBUG_FLAG                         1

#if SIZEOF_INT > 4
#define CONVSPEC_INT "ld"
#else
#define CONVSPEC_INT "d"
#endif

#if SIZEOF_SIZE_T > 4
#define CONVSPEC_SIZE_T "ld"
#else
#define CONVSPEC_SIZE_T "d"
#endif

#include <stdlib.h>
#define MAX_TRACKS             32 /* same as number of bits in track_map_t */
typedef u_int32_t track_map_t;
typedef void *frame_bits_t;
typedef int8_t graph_bits_unit_t;

#ifdef HAVE_ARCH_X86 
#define USE_MMX_MINMAX          1 /* 0 = never, 1 = auto-detect, 2 = always MMX, 3 = always MMX2. 4 = always 3DNow! */
#define USE_FLOAT_TO_INT_METHOD 2 /* 0 = lrintf, 1 = x86 ASM, 2 = ISO C */
#else  /* HAVE_ARCH_X86 */
#define USE_MMX_MINMAX          0 /* 0 = never, 1 = auto-detect, 2 = always MMX, 3 = always MMX2. 4 = always 3DNow! */
#define USE_FLOAT_TO_INT_METHOD 0 /* 0 = lrintf, 1 = x86 ASM, 2 = ISO C */
#endif /* HAVE_ARCH_X86 */

#ifdef DISABLE_FASTMINMAX
#define USE_MMX_MINMAX 0
#endif

#if USE_MMX_MINMAX == 2
#define PEAK_MIN_FUNC min_int8_mmx
#define PEAK_MAX_FUNC max_int8_mmx
#define MIN8_FUNC min_int8_mmx
#define MAX8_FUNC max_int8_mmx
#define MIN16_FUNC min_int16_mmx
#define MAX16_FUNC max_int16_mmx
#elif USE_MMX_MINMAX == 3
#define PEAK_MIN_FUNC min_int8_mmx2
#define PEAK_MAX_FUNC max_int8_mmx2
#define MIN8_FUNC min_int8_mmx2
#define MAX8_FUNC max_int8_mmx2
#define MIN16_FUNC min_int16_mmx2
#define MAX16_FUNC max_int16_mmx2
#elif USE_MMX_MINMAX == 4
#define PEAK_MIN_FUNC min_int8_3dnow
#define PEAK_MAX_FUNC max_int8_3dnow
#define MIN8_FUNC min_int8_3dnow
#define MAX8_FUNC max_int8_3dnow
#define MIN16_FUNC min_int16_3dnow
#define MAX16_FUNC max_int16_3dnow
#else
#define PEAK_MIN_FUNC funcs.peak_min_func
#define PEAK_MAX_FUNC funcs.peak_max_func
#define MIN8_FUNC funcs.min8_func
#define MAX8_FUNC funcs.max8_func
#define MIN16_FUNC funcs.min16_func
#define MAX16_FUNC funcs.max16_func
#endif

/* 
 * Various methods for floating point conversion, generally much
 * faster than the code generated by GCC from C casts. Inspired by
 * work by Erik de Castro Lopo.
 */

#if USE_FLOAT_TO_INT_METHOD == 0
#include <math.h>
#define FLOAT_TO_INT(in)  \
  ({ int __out = lrintf((in)); __out; })
#elif USE_FLOAT_TO_INT_METHOD == 1
#define FLOAT_TO_INT(in)  \
  ({ int __out; __asm__ __volatile__ ("fistpl %0" : "=m" (__out) : "t" (in) : "st"); __out; })
#else
#define FLOAT_TO_INT(in)  \
  (in)
#endif

/* Many systems come with an old sys/soundcard.h which is missing a
   number of defines so they are defined here. */

#include <sys/soundcard.h>
#ifndef AFMT_S32_LE
#define AFMT_S32_LE              0x00001000
#endif
#ifndef AFMT_S32_BE
#define AFMT_S32_BE              0x00002000
#endif
#ifndef AFMT_S32_NE
#define AFMT_S32_NE              (AFMT_S16_NE == AFMT_S16_BE ? AFMT_S32_BE : AFMT_S32_LE)
#endif

#include <stdio.h>  /* for debug output */
extern FILE *stderr, *stdout;
#if DEBUG_FLAG == 1
# if __GNUC__ > 2 
#  define WHATEVER_GCC_USES_FOR_FUNCTION_NAME __func__
# else
#  define WHATEVER_GCC_USES_FOR_FUNCTION_NAME __FUNCTION__
# endif
# define DEBUG(fmt, args...) \
  fprintf(stdout, "%s:%d: " fmt , WHATEVER_GCC_USES_FOR_FUNCTION_NAME, __LINE__ , ## args)
  /*fprintf(stdout, "debug: "__FILE__ ":%s:%d: " fmt , \
    WHATEVER_GCC_USES_FOR_FUNCTION_NAME, __LINE__ , ## args)*/
#else
# define DEBUG(fmt, args...)
#endif

#define FAIL(fmt, args...) \
fprintf(stderr, "FAIL : "__FILE__ ":%s:%d: " fmt , \
  WHATEVER_GCC_USES_FOR_FUNCTION_NAME, __LINE__ , ## args)

#define INFO(fmt, args...) \
fprintf(stdout, fmt, ## args)

/*
 * Configure fast_memcpy code from MPlayer. Disable if you get
 * mysterious crashes or other problems, tested only on Athlon and
 * PIII.
 * 
 * Benchmarks for PIII/600MHz:
 *
 *                  iter.  bytes/iter.         time    speed
 *                 ------+------------+-------------+--------------
 * Standard C:      1000 |    1048576 |  6.736989s. |  148.434 MB/s
 * MMX:             1000 |    1048576 |  6.256012s. |  159.846 MB/s
 * MMX2:            1000 |    1048576 |  3.573701s. |  279.822 MB/s
 * Runtime detect:  1000 |    1048576 |  3.642306s. |  274.551 MB/s 
 *
 */

#define USE_FASTMEMCPY
#ifdef DISABLE_FASTMEMCPY
#undef USE_FASTMEMCPY
#endif

#define RUNTIME_CPUDETECT
#ifdef DISABLE_CPUDETECT
#undef RUNTIME_CPUDETECT
#endif

#define HAVE_MALLOC_H
#define HAVE_MMX
#define HAVE_MMX2
#define HAVE_3DNOW
#define HAVE_3DNOWEX
/* These two don't seem to do much: */
#define HAVE_SSE 
#define HAVE_SSE2
/* MPlayer code needs <string.h>. */
#include <string.h>
#undef ARCH_X86
#ifdef HAVE_ARCH_X86
#define ARCH_X86
#endif
#include "lib/fastmemcpy.h"

#endif /* ! CONFIG_H */

