#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# wx/ToolBar.py
#
# DESCRIPTION:
# A generic UIdriver base for common message-based GUI toolkits.
#
# NOTES:
#

import string, sys
from wxPython.wx import *
from gnue.forms.uidrivers._commonGuiToolkit.ToolBar import ToolBar as _BaseToolBar
from common import wxEncode

class ToolBar(_BaseToolBar):

  # Create the menu
  def init(self):
    if sys.platform == 'win32':
      toolbar = wxToolBar(self.container, -1)
      toolbar.SetToolBitmapSize(wxSize(24,24))
    else:
      toolbar = wxToolBar(self.container,-1, style=wxTB_HORIZONTAL|wxTB_DOCKABLE)
    self.toolbar = toolbar
    self.container.SetToolBar(toolbar)
    return toolbar

  # Add a menu item (action)
  def addAction(self, name, userAction):
    label = name
    iconloc = userAction.getIconLocation(size="24x24")

    id = wxNewId()

    event = 'request%s' % userAction.event
    if userAction.canToggle:
      EVT_MENU(self.driver._wxapp, id,
        lambda event, l=self.driver,
              e=event, i=id,
              te='request%s' % userAction.canToggle,
              s=self.toolbar.GetToolState,
              f=self.form: l.dispatchEvent((s(i) and e or te),_form=f))
    else:
      EVT_MENU(self.driver._wxapp, id,
        lambda event, l=self.driver, e=event, f=self.form: l.dispatchEvent(e,_form=f))

    # Set the action icon if available
    if iconloc:
      try:
        # Some caching logic for faster second/third forms
        icon = _cachedIcons[iconloc]
      except KeyError:
        icon = wxImage(iconloc, wxBITMAP_TYPE_PNG).ConvertToBitmap()
        _cachedIcons[iconloc] = icon
    else:
      print "** WARNING: Cannot add '%s' to toolbar; no icon" % userAction.event
      return


    self.toolbar.AddSimpleTool(id, icon, wxEncode(userAction.description) or '',
                               isToggle=(userAction.canToggle and 1 or 0))

    self.toolbar.Realize()
    return id


  # Add a separator
  def addSeparator(self):
    self.toolbar.AddSeparator()

  # Enable a menu item
  def enableItem(self, item):
    if item != None:
      self.toolbar.EnableTool(item, 1)

  # Disable a menu item
  def disableItem(self, item):
    if item != None:
      self.toolbar.EnableTool(item, 0)

  def startingItem(self, item):
    if item!=None:
      self.toolbar.ToggleTool(item,1)

  def endingItem(self, item):
    if item!=None:
      self.toolbar.ToggleTool(item,0)


_cachedIcons = {}
