/******************************************************************************\
 gnofin/ui-menubar.h   $Revision: 1.10 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef UI_MENUBAR_H
#define UI_MENUBAR_H

#include "ui-types.h"

GNOFIN_API_BEGIN

UI_Menubar *ui_menubar_create (UI *);

void ui_menubar_enable_save        (UI_Menubar *, gboolean);
void ui_menubar_enable_undo        (UI_Menubar *, gboolean);
void ui_menubar_enable_redo        (UI_Menubar *, gboolean);

void ui_menubar_enable_account_ops (UI_Menubar *, gboolean);
void ui_menubar_enable_record_ops  (UI_Menubar *, gboolean);

void ui_menubar_set_behavior (gboolean  spawn_new_ui,
			      gboolean  new_acc_on_open,
			      gboolean  load_lastfile);
void ui_menubar_get_behavior (gboolean *spawn_new_ui,
			      gboolean *new_acc_on_open,
			      gboolean *load_lastfile);

/* Ask the menubar for its edit menu in popup form */
GtkWidget *ui_menubar_get_popup_edit_menu (UI_Menubar *menubar);

GNOFIN_API_END

#endif
