/* gnobog_open_file_dialog.c
 *
 * Copyright (C) 2000 Frdric LESPEZ & Renaud CHAILLAT
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <gnome.h>
#include <glade/glade.h>

#include "gnobog_app.h"
#include "gnobog_bookmarks.h"
#include "gnobog_open_file_dialog.h"

#define NETSCAPE_CHOICE 1
#define MOZILLA_CHOICE  2
#define OTHER_CHOICE    3

GladeXML                *xml;
static gint gnobog_open_file_dialog_radio_button_state;

/* Callbacks for "Open File" dialog box*/
void gnobog_open_file_dialog_radio_button_cb (GtkWidget* widget, gpointer data);
void gnobog_open_file_dialog_ok_cb (GtkWidget* widget, gpointer user_data);
void gnobog_open_file_dialog_cancel_cb (GtkWidget* widget, gpointer user_data);
void gnobog_open_file_dialog_browse_cb (GtkWidget* widget);

/* This callback is called when one of the radio button is pressed.
   This callback just store the user choice */
void
gnobog_open_file_dialog_radio_button_cb (GtkWidget* widget, gpointer data)
{
  /* Store user choice */
  gnobog_open_file_dialog_radio_button_state = GPOINTER_TO_INT(data);   
        
  return;
}

/* This callback is called when "Ok" button is pressed.
   This callback build the filename in function  */
void
gnobog_open_file_dialog_ok_cb (GtkWidget* widget, gpointer data)
{
  GtkWidget*    glade_widget;
  GnomeDialog*  dialog;
  gchar*        filename;

  /* Initialize filename*/
  filename = NULL;

  /* Build the filename according to user's choice*/
  switch (gnobog_open_file_dialog_radio_button_state) {
  case NETSCAPE_CHOICE:
    filename = g_strconcat(home_dir, "/.netscape/bookmarks.html", NULL);
    break;
  case MOZILLA_CHOICE:
    filename = g_strconcat(home_dir, "/.mozilla/default/bookmarks.html", NULL);
    break;
  case OTHER_CHOICE:
    /* Ask the filename to the file selector */
    glade_widget = glade_xml_get_widget (xml, "fileentry");
    filename = gnome_file_entry_get_full_path (GNOME_FILE_ENTRY (glade_widget), TRUE);
    break;
  default:
    g_assert("We cannot be here");
  }

  /* If no filename, then popup a dialog and let the user in front of the dialog box */
  if (filename == NULL || *filename == '\0') {
    dialog = GNOME_DIALOG (gnome_error_dialog (_("If you want to load a file, give me its name !")));
    gnome_dialog_run_and_close (dialog);
    return;
  }

  /* Blah blah..*/
  g_message ("Selected filename to load : %s", filename);

  /* Destroy "Open File" dialog Box */
  gtk_widget_destroy (GTK_WIDGET (widget));

  /* Load the file */
  gnobog_app_document_load (filename);

  /* Free strings no more used */
  g_free (filename);
        
  return;
}

/* This callback is called when "Cancel" Button is pressed.
   This one just destroy the "Open File" dialog box. */
void
gnobog_open_file_dialog_cancel_cb (GtkWidget* widget, gpointer data)
{
  /* Destroy "Open File" dialog Box */
  gtk_widget_destroy (GTK_WIDGET (widget));

  return;
}

/* This callback is called when "Browse" Button is pressed.
   It activates radiobutton_other and sets OTHER_CHOICE */
void
gnobog_open_file_dialog_browse_cb (GtkWidget* widget)
{
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(widget), TRUE);
  gnobog_open_file_dialog_radio_button_state = OTHER_CHOICE; 
}
  
  
/* This function initializes values in "Open File" dialog box.
   Then it displays and run the dialog box. */
void
gnobog_ui_open_file (GtkWidget* widget, GtkWidget* app)
{
  GtkWidget*    glade_widget;
  GtkWidget*    other_choice_widget;    
  GnomeDialog*  dialog;
        
  /* Load "Bookmark Properties" dialog box from Glade file and process it */
  xml = glade_xml_new (GNOBOG_GLADEDIR "/gnobog.glade", "gnobog_open_file_dialog");
  /* Used for tests */
  //    xml = glade_xml_new ("glade/gnobog.glade", "gnobog_open_file_dialog");
  if (!xml) {
    g_warning ("Cannot load interface from Glade file");
    dialog = GNOME_DIALOG (gnome_error_dialog (_("Cannot load interface from Glade file")));
    gnome_dialog_run_and_close (dialog);
    /* Return */
    return;
  }

  /* Initialize global variables of dialog */
  gnobog_open_file_dialog_radio_button_state = NETSCAPE_CHOICE;

  /* Initialize dialog box content and signals */
  glade_widget = glade_xml_get_widget (xml, "radiobutton_netscape");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(glade_widget), TRUE);
  gtk_signal_connect(GTK_OBJECT(glade_widget),
                     "clicked",
                     GTK_SIGNAL_FUNC(gnobog_open_file_dialog_radio_button_cb),
                     GINT_TO_POINTER(NETSCAPE_CHOICE));

  glade_widget = glade_xml_get_widget (xml, "radiobutton_mozilla");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(glade_widget), FALSE);
  gtk_signal_connect(GTK_OBJECT(glade_widget),
                     "clicked",
                     GTK_SIGNAL_FUNC(gnobog_open_file_dialog_radio_button_cb),
                     GINT_TO_POINTER(MOZILLA_CHOICE));

  glade_widget = glade_xml_get_widget (xml, "radiobutton_other");
  other_choice_widget = glade_widget;
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(glade_widget), FALSE);
  gtk_signal_connect(GTK_OBJECT(glade_widget),
                     "clicked",
                     GTK_SIGNAL_FUNC(gnobog_open_file_dialog_radio_button_cb),
                     GINT_TO_POINTER(OTHER_CHOICE));

  glade_widget = glade_xml_get_widget(xml,"fileentry");
  gtk_signal_connect_object(GTK_OBJECT(glade_widget),
                        "browse_clicked",
                        GTK_SIGNAL_FUNC(gnobog_open_file_dialog_browse_cb),
                        GTK_OBJECT (other_choice_widget));
  
  /* Connect all signal with functions name given in glade file */
  glade_xml_signal_autoconnect (xml);

  return;
}
