/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>

typedef enum {
    GTK_GMO_MATCH_START,
    GTK_GMO_MATCH_END,
    GTK_GMO_MATCH_CONTAINS,
    GTK_GMO_MATCH_REGEX
} GtkGmoMatchType;

typedef struct _GtkGmoTrigger GtkGmoTrigger;
typedef struct _GtkGmoTriggerHoover GtkGmoTriggerHoover;
/* The data should unref the from, and ref the to if he really changes it. */
typedef void (*GtkGmoTriggerChanged) (GtkGmoTrigger *from,
				      GtkGmoTrigger *to,
				      void *data);
/* The data should unref the trigger. */
typedef void (*GtkGmoTriggerDeleted) (GtkGmoTrigger *trigger,
				      void *data);

struct _GtkGmoTrigger {
    /* General */
    char  *name;			/* description */
    guint  disabled : 1;		/* disable triggers easely */

    /* Matching */
    GtkGmoMatchType type;		/* how we match */
    char  *pattern;
    guint  case_sensitive : 1;		/* do we care about case ? */
    guint  chance : 7;			/* [0..100] chance of match */
    guint  more_matches : 1;		/* if we stop matchin with this one */
    
    /* Normal color */
    guint   n_color_fg : 1;
    guint   n_fgcolor : 4;		/* foreground */
    gushort n_fgcolors[3];

    guint   n_color_bg : 1;
    guint   n_bgcolor : 4;		/* Background */
    gushort n_bgcolors[3];
    
    guint   n_color_bar : 1;
    guint   n_barcolor : 4;		/* Sidebar */
    gushort n_barcolors[3];
    
    guint   n_bold : 1;
    guint   n_underline : 1;

    /* Hoover color */
    guint   h_color_fg : 1;
    guint   h_fgcolor : 4;		/* foreground */
    gushort h_fgcolors[3];

    guint   h_color_bg : 1;
    guint   h_bgcolor : 4;		/* Background */
    gushort h_bgcolors[3];
    
    guint   h_bold : 1;
    guint   h_underline : 1;
    
    /* Hoover action */
    GList *hoover_actions;		/* List of GtkGmoTriggerHoover */

    /* Trigger actions */
    guint  send_text : 1;
    char  *send_text_text;
    guint  run_script : 1;
    char  *run_script_function;

    /* Sound */
    guint  beep : 1;
    guint  play_file : 1;
    char  *play_file_name;

    /* Event handling */
    GList *changed_functions;		/* Functions that wil be called on */
    GList *changed_data;		/* changes, with this data */
    GList *deleted_functions;		/* same for delete */
    GList *deleted_data;

    /* Misc */
    int refcount;
};

struct _GtkGmoTriggerHoover {
    guint button;
    guint type;
    guint action;
    char *action_data;
};

/* Create a default trigger */
GtkGmoTrigger *gtk_gmo_trigger_new();
/* copies an existing one */
GtkGmoTrigger *gtk_gmo_trigger_copy(const GtkGmoTrigger *trigger);
GtkGmoTrigger *gtk_gmo_trigger_load(FILE *f);
void           gtk_gmo_trigger_save(const GtkGmoTrigger *t, FILE *f);

/* claim a refcount */
void           gtk_gmo_trigger_ref(GtkGmoTrigger *trigger);
/* unclaim, free if needed */
void           gtk_gmo_trigger_unref(GtkGmoTrigger *trigger);
/* tell the other they should changed their reference */
void           gtk_gmo_trigger_emit_change(GtkGmoTrigger *from,
					   GtkGmoTrigger *to);
/* inform the others to unref */
void           gtk_gmo_trigger_emit_delete(GtkGmoTrigger *trigger);

/* (un)registrate change/delete events. */
void gtk_gmo_trigger_reg_change  (GtkGmoTrigger *trigger,
				  GtkGmoTriggerChanged *function,
				  void *data);
void gtk_gmo_trigger_unreg_change(GtkGmoTrigger *trigger,
				  GtkGmoTriggerChanged *function,
				  void *data);
void gtk_gmo_trigger_reg_delete  (GtkGmoTrigger *trigger,
				  GtkGmoTriggerDeleted *function,
				  void *data);
void gtk_gmo_trigger_unreg_delete(GtkGmoTrigger *trigger,
				  GtkGmoTriggerDeleted *function,
				  void *data);
GtkGmoTriggerHoover *gtk_gmo_trigger_hoover_new();
GtkGmoTriggerHoover *gtk_gmo_trigger_hoover_copy(GtkGmoTriggerHoover *hoover);
GtkGmoTriggerHoover *gtk_gmo_trigger_hoover_load(FILE *f);
void gtk_gmo_trigger_hoover_save(GtkGmoTriggerHoover *h, FILE *f);
void gtk_gmo_trigger_hoover_free(GtkGmoTriggerHoover *h);

