/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_ABOUT_H__
#define __UI_ABOUT_H__

#include <gtk/gtk.h>

#include "ui_child.h"

/*
  GiftuiChild
      +----GiftuiAbout
*/

#define GIFTUI_TYPE_ABOUT (giftui_about_get_type ())
#define GIFTUI_ABOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIFTUI_TYPE_ABOUT, GiftuiAbout))
#define GIFTUI_ABOUT_CLASS(class) (G_TYPE_CHECK_CLASS_CAST ((class), GIFTUI_TYPE_ABOUT, GiftuiAboutClass))
#define GIFTUI_IS_ABOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIFTUI_TYPE_ABOUT))
#define GIFTUI_IS_ABOUT_CLASS(class) (G_TYPE_CHECK_CLASS_TYPE ((class), GIFTUI_TYPE_ABOUT))
#define GIFTUI_ABOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GIFTUI_TYPE_ABOUT, GiftuiAboutClass))

typedef struct _GiftuiAbout GiftuiAbout;
typedef struct _GiftuiAboutClass GiftuiAboutClass;

struct _GiftuiAbout
{
	GiftuiChild parent_instance;
	
	/* < private_data > */
	GtkWidget *list;
	GtkTreeIter iter;
	
	GtkWidget *messages;
	
	guint timeout;
};

struct _GiftuiAboutClass
{
	GiftuiChildClass parent_class;
};

GType giftui_about_get_type (void);
GtkWidget *giftui_about_new (void);

#endif
