// COLOR.H : some common (inline-)functions for colors...

// Copyright (C) 1999 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef COLOR_H
#define COLOR_H

/*################################################################################################*/

#include "typedef.h"

/*################################################################################################*/

// these should be done generic, to give any desired color range...
// these should be done generic, to give any desired color range...
// these should be done generic, to give any desired color range...

void GetRBRange1(fGL, fGL, fGL *);
void GetRBRange2(fGL, fGL, fGL *);

void GetRedColor(fGL, fGL, fGL *);
void GetGreenColor(fGL, fGL, fGL *);
void GetBlueColor(fGL, fGL, fGL *);

fGL GetDistance(fGL *, void *, fGL *);
fGL GetUnity(fGL *, void *, fGL *);

/*################################################################################################*/

/**	A color function: white -> red -> green -> blue -> white, constant alpha. 
	This is best suited for opaque/transparent planes...
*/

inline void GetRBRange1(fGL value1, fGL alpha1, fGL * rgb)
{
	fGL value2 = fabs(value1);
	
	if (value2 < 1.0)
	{
		if (value1 < 0.0)
		{
			rgb[0] = 0.0;
			rgb[2] = value2;
		}
		else
		{
			rgb[0] = value2;
			rgb[2] = 0.0;
		}
		
		rgb[1] = 1.0 - value2;
		rgb[3] = alpha1;
	}
	else
	{
		value2 = 1.0 - 1.0 / value2;
		
		if (value1 < 0.0)
		{
			rgb[0] = value2;
			rgb[2] = 1.0;
		}
		else
		{
			rgb[0] = 1.0;
			rgb[2] = value2;
		}
		
		rgb[1] = value2;
		rgb[3] = alpha1;
	}
}

/**	A color function: white -> red -> [SHARP CHANGE] -> blue -> white, variable alpha. 
	This is best suited for transparent objects (volume rendering)...
*/

inline void GetRBRange2(fGL value1, fGL alpha1, fGL * rgb)
{
	fGL value2 = fabs(value1);
	
	fGL alpha2 = alpha1 * value2;
	if (alpha2 > 1.0) alpha2 = 1.0;
	
	if (value2 < 1.0)
	{
		if (value1 < 0.0)
		{
			rgb[0] = 0.0;
			rgb[2] = 1.0;
		}
		else
		{
			rgb[0] = 1.0;
			rgb[2] = 0.0;
		}
		
		rgb[1] = 0.0;
		rgb[3] = alpha2;
	}
	else
	{
		value2 = 1.0 - 1.0 / value2;
		
		if (value1 < 0.0)
		{
			rgb[0] = value2;
			rgb[2] = 1.0;
		}
		else
		{
			rgb[0] = 1.0;
			rgb[2] = value2;
		}
		
		rgb[1] = value2;
		rgb[3] = alpha2;
	}
}

inline void GetRedColor(fGL value, fGL alpha, fGL * rgb)
{
	rgb[0] = value;
	rgb[1] = rgb[2] = 0.0;
	
	rgb[3] = alpha;
}

inline void GetGreenColor(fGL value, fGL alpha, fGL * rgb)
{
	rgb[1] = value;
	rgb[0] = rgb[2] = 0.0;
	
	rgb[3] = alpha;
}

inline void GetBlueColor(fGL value, fGL alpha, fGL * rgb)
{
	rgb[2] = value;
	rgb[0] = rgb[1] = 0.0;
	
	rgb[3] = alpha;
}

inline fGL GetDistance(fGL * p1, void * p2, fGL *)
{
	fGL sum = 0.0;
	fGL * crd = (fGL *) p2;
	for (i32s n1 = 0;n1 < 3;n1++)
	{
		fGL tmp = p1[n1] - crd[n1];
		sum += tmp * tmp;
	}
	
	return sqrt(sum);
}

inline fGL GetUnity(fGL *, void *, fGL *)
{
	return 1.0;
}

/*################################################################################################*/

#endif	// COLOR_H

// eof
