// MODEL.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "model.h"

#include <iomanip>
#include <strstream>
using namespace std;

/*################################################################################################*/

char model_simple::local_fn_buffer[256];

model_simple::model_simple(ostream * p1, class_factory & p2)
{
	// if we use ostr for logfiles, we should create and destroy the ostr here.
	// however, at the moment it is still needed for console output...
	
	ostr = p1;
	
	factory = & p2;
	err = factory->ProduceErrUtil();
	model_prefs = factory->ProducePrefs();
}

model_simple::~model_simple(void)
{
	delete err;
}

const char * model_simple::GetFullPrimaryFN(const char * fn)
{
	ostrstream str(local_fn_buffer, sizeof(local_fn_buffer));
	str << PRIMARY_PATH << VERSION << DIR_SEPARATOR << fn << ends;
	return local_fn_buffer;
}

const char * model_simple::GetFullSecondaryFN(const char * srcdir, const char * fn)
{
	ostrstream str(local_fn_buffer, sizeof(local_fn_buffer));
	str << SECONDARY_PATH << srcdir << fn << ends;
	return local_fn_buffer;
}

void model_simple::OpenParameterFile(ifstream & file, bool is_binary_file, const char * fn)
{
	if (!is_binary_file) file.open(model_simple::GetFullPrimaryFN(fn), ios::in);
	else file.open(model_simple::GetFullPrimaryFN(fn), ios::in | ios::binary);
	if (file.good()) return;
	
	file.close();
	cout << "warning: primary path failed for " << model_simple::GetFullPrimaryFN(fn) << endl;
	
	if (!is_binary_file) file.open(model_simple::GetFullSecondaryFN("", fn), ios::in);
	else file.open(model_simple::GetFullSecondaryFN("", fn), ios::in | ios::binary);
	if (file.good()) return;
	
	file.close();
	cout << "error: secondary path failed for " << fn << endl;

	exit(EXIT_FAILURE);
}

/*################################################################################################*/

model_extended::model_extended(ostream * p1, class_factory & p2) : model_simple(p1, p2)
{
	cs_vector.push_back(new crd_set());
	SetCRDSetVisible(0, true);
}

model_extended::~model_extended(void)
{
	for (i32u n1 = 0;n1 < cs_vector.size();n1++)
	{
		delete cs_vector[n1];
	}
}

void model_extended::UpdateAccumValues(void)		// or NormalizeAccumValues???
{
	fGL sum = 0.0;
	for (i32u n1 = 0;n1 < cs_vector.size();n1++)
	{
		if (GetCRDSetVisible(n1))
		{
			sum += cs_vector[n1]->accum_weight;
		}
	}
	
	for (i32u n1 = 0;n1 < cs_vector.size();n1++)
	{
		if (GetCRDSetVisible(n1))
		{
			fGL tmp1 = cs_vector[n1]->accum_weight / sum;
			cs_vector[n1]->accum_value = tmp1;
		}
	}
}

i32u model_extended::GetCRDSetCount(void)
{
	return cs_vector.size();
}

bool model_extended::GetCRDSetVisible(i32u index)
{
	if (index < cs_vector.size())
	{
		return cs_vector[index]->visible;
	}
	else
	{
		cout << "invalid call to model_extended::GetCRDSetVisible()" << endl;
		exit(EXIT_FAILURE);
	}
}

void model_extended::SetCRDSetVisible(i32u index, bool visible)
{
	if (index < cs_vector.size())
	{
		cs_vector[index]->visible = visible;
	}
	else
	{
		cout << "invalid call to model_extended::SetCRDSetVisible()" << endl;
		exit(EXIT_FAILURE);
	}
}

/*################################################################################################*/

crd_set::crd_set(void)
{
	description = NULL;
	
	accum_weight = 1.0;		// accum_value is not updated here?!?!?!?!?!
	visible = false;
}

crd_set::crd_set(const crd_set & p1)
{
	description = NULL;
	SetDescription(p1.description);
	
	accum_weight = p1.accum_weight;
	accum_value = p1.accum_value;
	visible = p1.visible;
}

crd_set::~crd_set(void)
{
	if (description != NULL) delete[] description;
}

void crd_set::SetDescription(const char * p1)
{
	if (description != NULL) delete[] description;
	
	if (p1 != NULL)
	{
		description = new char[strlen(p1) + 1];
		strcpy(description, p1);
	}
	else description = NULL;
}

/*################################################################################################*/

superimpose::superimpose(i32s p1, i32s p2) : conjugate_gradient(10, 0.00001)	// 2000-12-30 ok!!!
{
	index[0] = p1;
	index[1] = p2;
	
	for (i32s n1 = 0;n1 < 3;n1++)
	{
		rot[n1] = drot[n1] = 0.0;
		AddVar(& rot[n1], & drot[n1]);
		
		loc[n1] = dloc[n1] = 0.0;
		AddVar(& loc[n1], & dloc[n1]);
	}
}

superimpose::~superimpose(void)
{
}

void superimpose::Compare(const f64 * d1, const f64 * d2, bool gradient, f64 * result)
{
	const f64 balance = 0.25;
	
	// translate...
	// translate...
	// translate...
	
	f64 d2a[3];
	d2a[0] = d2[0] + loc[0] * balance;
	d2a[1] = d2[1] + loc[1] * balance;
	d2a[2] = d2[2] + loc[2] * balance;
	
	// rotate x (y,z)...
	// rotate x (y,z)...
	// rotate x (y,z)...
	
	f64 d2b[3];
	d2b[0] = d2a[0];
	d2b[1] = d2a[1] * cos(rot[0]) - d2a[2] * sin(rot[0]);
	d2b[2] = d2a[1] * sin(rot[0]) + d2a[2] * cos(rot[0]);

	// rotate y (z,x)...
	// rotate y (z,x)...
	// rotate y (z,x)...
	
	f64 d2c[3];
	d2c[0] = d2b[2] * sin(rot[1]) + d2b[0] * cos(rot[1]);
	d2c[1] = d2b[1];
	d2c[2] = d2b[2] * cos(rot[1]) - d2b[0] * sin(rot[1]);
	
	// rotate z (x,y)...
	// rotate z (x,y)...
	// rotate z (x,y)...
	
	f64 d2d[3];
	d2d[0] = d2c[0] * cos(rot[2]) - d2c[1] * sin(rot[2]);
	d2d[1] = d2c[0] * sin(rot[2]) + d2c[1] * cos(rot[2]);
	d2d[2] = d2c[2];
	
	// rot-gradients...
	// rot-gradients...
	// rot-gradients...
	
	f64 drz[3];
	drz[0] = -(d2c[0] * sin(rot[2]) + d2c[1] * cos(rot[2]));
	drz[1] = d2c[0] * cos(rot[2]) - d2c[1] * sin(rot[2]);
	drz[2] = 0.0;
	
	f64 dry[3];
	dry[0] = (d2b[2] * cos(rot[1]) - d2b[0] * sin(rot[1])) * cos(rot[2]);
	dry[1] = (d2b[2] * cos(rot[1]) - d2b[0] * sin(rot[1])) * sin(rot[2]);
	dry[2] = -(d2b[2] * sin(rot[1]) + d2b[0] * cos(rot[1]));
	
	f64 drx[3];
	drx[0] = ((d2a[1] * cos(rot[0]) - d2a[2] * sin(rot[0])) * sin(rot[1])) * cos(rot[2]) +
		(d2a[1] * sin(rot[0]) + d2a[2] * cos(rot[0])) * sin(rot[2]);
	drx[1] = ((d2a[1] * cos(rot[0]) - d2a[2] * sin(rot[0])) * sin(rot[1])) * sin(rot[2]) -
		(d2a[1] * sin(rot[0]) + d2a[2] * cos(rot[0])) * cos(rot[2]);
	drx[2] = (d2a[1] * cos(rot[0]) - d2a[2] * sin(rot[0])) * cos(rot[1]);
	
	// loc-gradients...
	// loc-gradients...
	// loc-gradients...
	
	f64 dlx[3];
	dlx[0] = balance * cos(rot[1]) * cos(rot[2]);
	dlx[1] = balance * cos(rot[1]) * sin(rot[2]);
	dlx[2] = -balance * sin(rot[1]);
	
	f64 dly[3];
	dly[0] = balance * sin(rot[0]) * sin(rot[1]) * cos(rot[2]) - balance * cos(rot[0]) * sin(rot[2]);
	dly[1] = balance * sin(rot[0]) * sin(rot[1]) * sin(rot[2]) + balance * cos(rot[0]) * cos(rot[2]);
	dly[2] = balance * sin(rot[0]) * cos(rot[1]);
	
	f64 dlz[3];
	dlz[0] = balance * cos(rot[0]) * sin(rot[1]) * cos(rot[2]) + balance * sin(rot[0]) * sin(rot[2]);
	dlz[1] = balance * cos(rot[0]) * sin(rot[1]) * sin(rot[2]) - balance * sin(rot[0]) * cos(rot[2]);
	dlz[2] = balance * cos(rot[0]) * cos(rot[1]);
	
	// f = (a-b)^2
	// df/db = -2(a-b)*Db
	
	f64 diff[3];
	diff[0] = d1[0] - d2d[0];
	diff[1] = d1[1] - d2d[1];
	diff[2] = d1[2] - d2d[2];
	
	f64 tmp1 = diff[0] * diff[0] + diff[1] * diff[1] + diff[2] * diff[2];
	
	value += tmp1;
	
	if (gradient)
	{
		dloc[0] -= 2.0 * diff[0] * dlx[0];
		dloc[0] -= 2.0 * diff[1] * dlx[1];
		dloc[0] -= 2.0 * diff[2] * dlx[2];
		
		dloc[1] -= 2.0 * diff[0] * dly[0];
		dloc[1] -= 2.0 * diff[1] * dly[1];
		dloc[1] -= 2.0 * diff[2] * dly[2];
		
		dloc[2] -= 2.0 * diff[0] * dlz[0];
		dloc[2] -= 2.0 * diff[1] * dlz[1];
		dloc[2] -= 2.0 * diff[2] * dlz[2];
		
		drot[0] -= 2.0 * diff[0] * drx[0];
		drot[0] -= 2.0 * diff[1] * drx[1];
		drot[0] -= 2.0 * diff[2] * drx[2];
		
		drot[1] -= 2.0 * diff[0] * dry[0];
		drot[1] -= 2.0 * diff[1] * dry[1];
		drot[1] -= 2.0 * diff[2] * dry[2];
		
		drot[2] -= 2.0 * diff[0] * drz[0];
		drot[2] -= 2.0 * diff[1] * drz[1];
		drot[2] -= 2.0 * diff[2] * drz[2];
	}
	
	if (result != NULL)
	{
		result[0] = d2d[0];
		result[1] = d2d[1];
		result[2] = d2d[2];
	}
	
	counter++;
}

/*################################################################################################*/

// eof
