// MM3MDL.H : a model that makes very coarse (helix/sheet) level presentations of proteins.

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM3MDL_H
#define MM3MDL_H

class mm3_mdl;

/*################################################################################################*/

class mm2_mdl;		// mm2mdl.h

#include "model.h"

#include <vector>

/*################################################################################################*/

struct mm3_sse
{
	fGL center[3];
	fGL direction[3];
	
	enum { helix = 0, strand = 1 } type;
	
	i32s residues;
};

struct mm3_chn
{
	vector<mm3_sse> sse_vector;
	
	// spline !??!?!
	
};

class mm3_mdl : virtual public model_simple
{
        protected:
        
        vector<mm3_chn> chn_vector;
        
        public:
	
	mm3_mdl(ostream *, class_factory &);
	~mm3_mdl(void);
	
	const char * GetProjectFileNameExtension(void);		// virtual
	
	void Reduce(mm2_mdl *, i32s);

	bool ReadStream(istream &, bool, bool = false) { return false; }	// virtual
	void WriteStream(ostream &) { }						// virtual
	
/// someday we might move ImportFile() to all_atoms_interface, but at the moment we just have a dummy function here...
	bool ImportFile(const char*, int) { return false; }	// virtual
	
	private:
	
	mm3_sse * CreateHelix(mm2_mdl *, i32s, i32s, i32s);
	mm3_sse * CreateStrand(mm2_mdl *, i32s, i32s, i32s);
};

/*################################################################################################*/

#endif	// MM3MDL_H

// eof
