// MM1ENG.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm1eng.h"

#include <algorithm>
using namespace std;

/*################################################################################################*/

void CopyCRD(mm1_mdl * p1, mm1_eng * p2, i32u p3)
{
	if (p3 >= p1->cs_vector.size())
	{
		cout << "cs overflow at mm1 CopyCRD()." << endl;
		exit(EXIT_FAILURE);
	}
	
	i32u n1 = 0; iter_mm1al it1;
	for (it1 = p1->atom_list.begin();it1 != p1->atom_list.end();it1++)
	{
		p2->crd[n1][0] = (* it1).crd_vector[p3][0];
		p2->crd[n1][1] = (* it1).crd_vector[p3][1];
		p2->crd[n1][2] = (* it1).crd_vector[p3][2];
		
		n1++;
	}
}

void CopyCRD(mm1_eng * p1, mm1_mdl * p2, i32u p3)
{
	if (p3 >= p2->cs_vector.size())
	{
		cout << "cs overflow at mm1 CopyCRD()." << endl;
		exit(EXIT_FAILURE);
	}
	
	i32u n1 = 0; iter_mm1al it1;
	for (it1 = p2->atom_list.begin();it1 != p2->atom_list.end();it1++)
	{
		(* it1).crd_vector[p3][0] = p1->crd[n1][0];
		(* it1).crd_vector[p3][1] = p1->crd[n1][1];
		(* it1).crd_vector[p3][2] = p1->crd[n1][2];
		
		n1++;
	}
}

/*################################################################################################*/

mm1_eng::mm1_eng(mm1_mdl & p1) : engine(), mdl(p1)
{
	natm = GetModel()->atom_list.size();
	crd = new f64_a3[natm]; d1 = new f64_a3[natm];
	
	// create the atom index records...
	
	GetModel()->UpdateIndex();
	index = new mm1_atom *[natm];
	iter_mm1al it1 = GetModel()->atom_list.begin();
	while (it1 != GetModel()->atom_list.end())
	{
		index[(* it1).index] = & (* it1); it1++;
	}
	
	// create the connectivity records...
	
	range_cr1 = new i32s[natm + 1];		// this is for 1-2 and 1-3 interactions...
	range_cr2 = new i32s[natm + 1];		// this is only for 1-4 interactions...
	
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "creating connectivity records..." << endl;
	for (iter_mm1al it1 = GetModel()->atom_list.begin();it1 != GetModel()->atom_list.end();it1++)
	{
		if (GetModel()->ostr != NULL && !((* it1).index % 10)) (* GetModel()->ostr) << "*" << flush;
		
		range_cr1[(* it1).index] = cr1.size();
		range_cr2[(* it1).index] = cr2.size();
		
		SearchCR1a(& (* it1));
	}
	
	range_cr1[GetModel()->atom_list.size()] = cr1.size();		// this is just the end mark...
	range_cr2[GetModel()->atom_list.size()] = cr2.size();		// this is just the end mark...
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << endl;
}

mm1_eng::~mm1_eng(void)
{
	delete[] crd;
	delete[] d1;
	
	delete[] range_cr1;
	delete[] range_cr2;
	
	delete[] index;
}

void mm1_eng::Compute(i32s p1)
{
	if (p1)
	{
		for (i32s n1 = 0;n1 < natm;n1++)
		{
			d1[n1][0] = 0.0;
			d1[n1][1] = 0.0;
			d1[n1][2] = 0.0;
		}
	}
	
	ComputeBT1(p1);
	
	// communicate via MPI if parallel?!?!?!
	// contents of bt1_data tables should be syncronized...
	
	ComputeBT2(p1);
	
	// communicate via MPI if parallel?!?!?!
	// contents of bt2_data tables should be syncronized...
	
	ComputeBT3(p1);
	ComputeBT4(p1);
	
	ComputeNBT1(p1);
	
	energy = energy_bt1 + energy_bt2 + energy_bt3 + energy_bt4 + energy_nbt1;
//cout << "energy = " << energy_bt1 << " " << energy_bt2 << " " << energy_bt3 << " " << energy_bt4 << " " << energy_nbt1 << endl;
}

void mm1_eng::Check(i32s)
{
	const f64 delta = 0.000001;	// the finite difference step...
	
	Compute(1);
	f64 tmp1 = energy;
	
	f64 tmp2; f64 old;
	for (i32s n1 = 0;n1 < natm;n1++)
	{
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			old = crd[n1][n2];
			crd[n1][n2] = old + delta;
			Compute(0); tmp2 = (energy - tmp1) / delta;
			crd[n1][n2] = old;
			
			cout << n1 << ((char) ('x' + n2)) << " ";
			cout << "a = " << d1[n1][n2] << " ";
			cout << "n = " << tmp2 << endl;
			
			if ((n1 % 5) == 4) cin >> old;		// uses console I/O, but this function is not relevant to users...
		}
	}
}

f64 mm1_eng::GetGradientVectorLength(void)
{
	f64 sum = 0.0;
	
	for (i32s n1 = 0;n1 < natm;n1++)
	{
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 tmp1 = d1[n1][n2];
			sum += tmp1 * tmp1;
		}
	}
	
	return sqrt(sum);
}

void mm1_eng::SearchCR1a(mm1_atom * atm1)
{
	for (iter_mm1cl itc = atm1->cr_list.begin();itc != atm1->cr_list.end();itc++)
	{
		mm1_atom * atm2 = (* itc).atmr;
		cr1.push_back(atm2->index);
		
		SearchCR1b(atm2, (* itc).bndr);
	}
}

void mm1_eng::SearchCR1b(mm1_atom * atm2, mm1_bond * reserved1)
{
	for (iter_mm1cl itc = atm2->cr_list.begin();itc != atm2->cr_list.end();itc++)
	{
		if ((* itc).bndr == reserved1) continue;
		
		mm1_atom * atm3 = (* itc).atmr;
		cr1.push_back(atm3->index);
		
		SearchCR2(atm3, reserved1, (* itc).bndr);
	}
}

void mm1_eng::SearchCR2(mm1_atom * atm3, mm1_bond * reserved1, mm1_bond * reserved2)
{
	for (iter_mm1cl itc = atm3->cr_list.begin();itc != atm3->cr_list.end();itc++)
	{
		if ((* itc).bndr == reserved1) continue;
		if ((* itc).bndr == reserved2) continue;
		
		mm1_atom * atm4 = (* itc).atmr;
		cr2.push_back(atm4->index);
	}
}

/*################################################################################################*/

mm1_eng_pbc::mm1_eng_pbc(mm1_mdl & p1) : mm1_eng(p1)
{
	nmol = GetModel()->nmol;	// we assume that GetModel()->GatherGroups() is done...
	mrange = new i32s[nmol + 1];
	
	mrange[0] = 0; i32s atmi = 1;
	for (i32s n1 = 0;n1 < nmol;n1++)
	{
		while (atmi < natm && index[atmi]->id[0] == n1) atmi++;
		mrange[n1 + 1] = atmi;
	}
}

mm1_eng_pbc::~mm1_eng_pbc(void)
{
	delete[] mrange;
}

void mm1_eng_pbc::CheckLocations(void)
{
	for (i32s n1 = 0;n1 < nmol;n1++)
	{
		f64 sum[3] = { 0.0, 0.0, 0.0 };
		f64 ac = (f64) (mrange[n1 + 1] - mrange[n1]);
		for (i32s n2 = mrange[n1];n2 < mrange[n1 + 1];n2++)
		{
			for (i32s n3 = 0;n3 < 3;n3++)
			{
				sum[n3] += crd[n2][n3];
			}
		}
		
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 test = sum[n2] / ac;
			if (test < -GetModel()->box_hdim[n2])
			{
				for (i32s n3 = mrange[n1];n3 < mrange[n1 + 1];n3++)
				{
					crd[n3][n2] += GetModel()->box_fdim[n2];
				}
			}
			else if (test > +GetModel()->box_hdim[n2])
			{
				for (i32s n3 = mrange[n1];n3 < mrange[n1 + 1];n3++)
				{
					crd[n3][n2] -= GetModel()->box_fdim[n2];
				}
			}
		}
	}
}

/*################################################################################################*/

// eof
