// ENGINE.H : the "engine" base class for computation engine classes.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef ENGINE_H
#define ENGINE_H

class engine;

/*################################################################################################*/

#include "typedef.h"

/*################################################################################################*/

/**	A base class for computations; "##engine" classes are used to implement the 
	computational details of various models (like different quantum-mechanical models 
	and molecular mechanics models).
	
	When we want to compute something, we create an instance of some suitable
	"##engine"-class using our "##model"-class. The "##engine"-class will copy that 
	information it needs, and calculates those results it is supposed to calculate. 
	If we calculate some useful results that change our original system, we can copy 
	those results back to our "##model"-class.
	
	For qm1- and mm1-models, it would be possible to make well-defined functions to 
	pass coordinate data in and out; for example GetCRD() and PutCRD(). but it's not 
	a good idea to make this too specific, since there may be simplified protein models 
	etc which might not have clearly defined "atoms" at all. we just let the models 
	handle their own problems (like memory management etc) independently!!!
*/

class engine
{
	private:
	
// this is just an interface definition -> there is no relevant common data?!?!?
// this is just an interface definition -> there is no relevant common data?!?!?
// this is just an interface definition -> there is no relevant common data?!?!?

	public:
	
	engine(void);
	virtual ~engine(void);
	
	/// Will compute the energy, and the gradient if needed.
	virtual void Compute(i32s) = 0;
	
	/// This is for debugging; will compare the computed gradient to a numerical one.
	virtual void Check(i32s) = 0;
	
	/// This calculates the gradient vector length; it assumes that derivatives already exist (Compute(1) was called).
	virtual f64 GetGradientVectorLength(void) = 0;
	
/// This is some old "load-balancing" thing... Not used anywhere???
void Balance(i32s, i32s *, i32s *, i32s &, i32s);
};

/*################################################################################################*/

#endif	// ENGINE_H

// eof
