/* 
 * (c) The University of Glasgow 2002
 *
 * Win32 Console API support
 */
#include "config.h"
#if defined(mingw32_TARGET_OS) || defined(cygwin32_TARGET_OS)
/* to the end */

#include "consUtils.h"
#include <windows.h>
#include <io.h>

#if defined(cygwin32_TARGET_OS)
#define _get_osfhandle get_osfhandle
#endif

int
set_console_buffering__(int fd, int cooked)
{
    HANDLE h;
    DWORD  st;
    /* According to GetConsoleMode() docs, it is not possible to
       leave ECHO_INPUT enabled without also having LINE_INPUT,
       so we have to turn both off here. */
    DWORD flgs = ENABLE_LINE_INPUT | ENABLE_ECHO_INPUT;
    
    if ( (h = (HANDLE)_get_osfhandle(fd)) != INVALID_HANDLE_VALUE ) {
	if ( GetConsoleMode(h,&st) &&
	     SetConsoleMode(h, cooked ? (st | ENABLE_LINE_INPUT) : st & ~flgs)  ) {
	    return 0;
	}
    }
    return -1;
}

int
set_console_echo__(int fd, int on)
{
    HANDLE h;
    DWORD  st;
    DWORD flgs = ENABLE_LINE_INPUT | ENABLE_ECHO_INPUT;
    
    if ( (h = (HANDLE)_get_osfhandle(fd)) != INVALID_HANDLE_VALUE ) {
	if ( GetConsoleMode(h,&st) && 
	     SetConsoleMode(h,( on ? (st | flgs) : (st & ~ENABLE_ECHO_INPUT))) ) {
	    return 0;
	}
    }
    return -1;
}

int
get_console_echo__(int fd)
{
    HANDLE h;
    DWORD  st;
    
    if ( (h = (HANDLE)_get_osfhandle(fd)) != INVALID_HANDLE_VALUE ) {
	if ( GetConsoleMode(h,&st) ) {
	    return (st & ENABLE_ECHO_INPUT ? 1 : 0);
	}
    }
    return -1;
}

#endif /* defined(mingw32_TARGET_OS) || defined(cygwin32_TARGET_OS) */
