/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  buttonsignals.cc - Gtk::Button virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "button.hh"
#include "buttonsignals.hh"
#include "private/buttonclass.hh"

using namespace GFC;

Gtk::ButtonSignals::ButtonSignals(Button *button) 
: ContainerSignals(button)
{
	Gtk::ButtonClass::init(GTK_BUTTON_GET_CLASS(button->gtk_button()));
}

Gtk::ButtonSignals::~ButtonSignals()
{
}

void
Gtk::ButtonSignals::on_pressed()
{
	GtkButtonClass *g_class = ButtonClass::get_parent_class(instance_);
	if (g_class->pressed)
		g_class->pressed((GtkButton*)instance_);
}

void
Gtk::ButtonSignals::on_released()
{
	GtkButtonClass *g_class = ButtonClass::get_parent_class(instance_);
	if (g_class->released)
		g_class->released((GtkButton*)instance_);
}

void
Gtk::ButtonSignals::on_clicked()
{
	GtkButtonClass *g_class = ButtonClass::get_parent_class(instance_);
	if (g_class->clicked)
		g_class->clicked((GtkButton*)instance_);
}

void
Gtk::ButtonSignals::on_enter()
{
	GtkButtonClass *g_class = ButtonClass::get_parent_class(instance_);
	if (g_class->enter)
		g_class->enter((GtkButton*)instance_);
}

void
Gtk::ButtonSignals::on_leave()
{
	GtkButtonClass *g_class = ButtonClass::get_parent_class(instance_);
	if (g_class->leave)
		g_class->leave((GtkButton*)instance_);
}

void
Gtk::ButtonSignals::on_activate()
{
	GtkButtonClass *g_class = ButtonClass::get_parent_class(instance_);
	if (g_class->activate)
		g_class->activate((GtkButton*)instance_);
}

/*  Gtk::ButtonClass
 */

void
Gtk::ButtonClass::init(GtkButtonClass *g_class)
{
	g_class->pressed = &pressed_proxy;
	g_class->released = &released_proxy;
	g_class->clicked = &clicked_proxy;
	g_class->enter = &enter_proxy;
	g_class->leave = &leave_proxy;
	g_class->activate = &activate_proxy;
}

GtkButtonClass*
Gtk::ButtonClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_BUTTON_GET_CLASS(instance));
	return static_cast<GtkButtonClass*>(ptr);
}

GType
Gtk::ButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_BUTTON);
	}
	return type;
}

void*
Gtk::ButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ButtonClass::pressed_proxy(GtkButton *button)
{
	void *ptr = g_object_get_qdata((GObject*)button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ButtonSignals*>(ptr)->on_pressed();
	else
	{
		GtkButtonClass *g_class = ButtonClass::get_parent_class(button);
		if (g_class->pressed)
			g_class->pressed(button);
	}
}

void
Gtk::ButtonClass::released_proxy(GtkButton *button)
{
	void *ptr = g_object_get_qdata((GObject*)button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ButtonSignals*>(ptr)->on_released();
	else
	{
		GtkButtonClass *g_class = ButtonClass::get_parent_class(button);
		if (g_class->released)
			g_class->released(button);
	}
}

void
Gtk::ButtonClass::clicked_proxy(GtkButton *button)
{
	void *ptr = g_object_get_qdata((GObject*)button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ButtonSignals*>(ptr)->on_clicked();
	else
	{
		GtkButtonClass *g_class = ButtonClass::get_parent_class(button);
		if (g_class->clicked)
			g_class->clicked(button);
	}
}

void
Gtk::ButtonClass::enter_proxy(GtkButton *button)
{
	void *ptr = g_object_get_qdata((GObject*)button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ButtonSignals*>(ptr)->on_enter();
	else
	{
		GtkButtonClass *g_class = ButtonClass::get_parent_class(button);
		if (g_class->enter)
			g_class->enter(button);
	}
}

void
Gtk::ButtonClass::leave_proxy(GtkButton *button)
{
	void *ptr = g_object_get_qdata((GObject*)button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ButtonSignals*>(ptr)->on_leave();
	else
	{
		GtkButtonClass *g_class = ButtonClass::get_parent_class(button);
		if (g_class->leave)
			g_class->leave(button);
	}
}

void
Gtk::ButtonClass::activate_proxy(GtkButton *button)
{
	void *ptr = g_object_get_qdata((GObject*)button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ButtonSignals*>(ptr)->on_activate();
	else
	{
		GtkButtonClass *g_class = ButtonClass::get_parent_class(button);
		if (g_class->activate)
			g_class->activate(button);
	}
}

