/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>

#include "fileops.h"
#include "fileops-helper.h"

extern GladeXML *xml;
extern GString *GLADE_FILE;
extern GList *ComicList;

extern gchar *current_filename;
extern gboolean file_changed;

extern gchar *MainWindowKey;
extern gchar *ComicListKey;
extern gchar *ComicToAddKey;
extern gchar *ComicToAddToKey;
extern gchar *ComicToEditKey;
extern gchar *IssueToEditKey;

char *SELECTION;

/* function prototypes - START */
gboolean on_export_selection_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_export_selection_cancel_button_clicked (GtkButton *button, gpointer user_data);
void on_export_selection_ok_button_clicked (GtkButton *button, gpointer user_data);
void connect_export_selection_signals (GladeXML *temp_xml);
void real_export_file(GtkWidget *main_window, GString *fname);
void create_export_selection (GtkWidget *generic, char *selection);
/* function prototypes - END */

/* callback functions - START */
gboolean on_export_selection_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  GtkWidget *export_selection;
  GladeXML *temp_xml = user_data;

  export_selection = glade_xml_get_widget (temp_xml, SELECTION);
  gtk_widget_destroy (export_selection);

  return FALSE;
}

void on_export_selection_cancel_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *export_selection;
  GladeXML *temp_xml = user_data;

  export_selection = glade_xml_get_widget (temp_xml, SELECTION);
  gtk_widget_destroy(export_selection);
}

void on_export_selection_ok_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *main_window, *export_selection;
  GString *fname;
  GladeXML *temp_xml = user_data;

  export_selection = glade_xml_get_widget (temp_xml, SELECTION);
  main_window = gtk_object_get_data (GTK_OBJECT (export_selection), MainWindowKey);

  /* FIXME - very ugly hack to make sure sufficient space is allocated for current_filename */
  fname = g_string_new(NULL);
  g_string_sprintf(fname, "%s", gtk_file_selection_get_filename (GTK_FILE_SELECTION (export_selection)));

  if (file_exists (fname->str))
    {
      // show Yes/No dialog
      GtkWidget* mbox;
      GString *question;
      int reply;

      question = g_string_new (fname->str);
      question = g_string_append (question, " already exists\n");
      question = g_string_append (question, "Overwrite it?");
      
      mbox = gnome_message_box_new (question->str,
				    GNOME_MESSAGE_BOX_QUESTION,
				    GNOME_STOCK_BUTTON_YES,
				    GNOME_STOCK_BUTTON_NO,
				    NULL);

      gtk_window_set_modal (GTK_WINDOW (mbox), TRUE);
      reply = gnome_dialog_run (GNOME_DIALOG(mbox));

      if (reply == GNOME_OK)
	{
	  real_export_file (main_window, fname);
	  gtk_widget_destroy(export_selection);
	}
    }
  else
    {
      real_export_file(main_window, fname);
      gtk_widget_destroy(export_selection);
    }
}
/* callback functions - END */


void real_export_file(GtkWidget *main_window, GString *fname)
{
  if (strcmp(SELECTION, "export_ascii_selection") == 0)
    {
      /* We are exporting to ASCII */
      if (ExportToASCIIFile(ComicList, fname) != 0)
	{
	  gnome_app_flash(GNOME_APP(main_window), "Unable to export to ASCII file.");
	  return;
	}
      gnome_app_flash(GNOME_APP(main_window), "File exported (ASCII).");
    }

  if (strcmp(SELECTION, "export_html_selection") == 0)
    {
      /* We are exporting to ASCII */
      if (ExportToHTMLFile(ComicList, fname) != 0)
	{
	  gnome_app_flash(GNOME_APP(main_window), "Unable to export to HTML file.");
	  return;
	}
      gnome_app_flash(GNOME_APP(main_window), "File exported (HTML).");
    }
}

void connect_export_selection_signals (GladeXML *temp_xml)
{
  GtkFileSelection *filew = GTK_FILE_SELECTION (glade_xml_get_widget (temp_xml, SELECTION));

  gtk_signal_connect_full (GTK_OBJECT(filew->ok_button), "clicked",
			   GTK_SIGNAL_FUNC(on_export_selection_ok_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(filew->cancel_button), "clicked",
			   GTK_SIGNAL_FUNC(on_export_selection_cancel_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(filew), "delete_event",
			   GTK_SIGNAL_FUNC(on_export_selection_delete_event), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
}

/* exported functions - START */
void create_export_selection (GtkWidget *generic, char *selection)
{
  GtkWidget *main_window = NULL;
  GtkFileSelection *export_selection = NULL;
  GladeXML *temp_xml;
 
  SELECTION = selection;

  main_window = glade_xml_get_widget (xml, "main_window");

  temp_xml = glade_xml_new (GLADE_FILE->str, SELECTION);
  export_selection = GTK_FILE_SELECTION (glade_xml_get_widget (temp_xml, SELECTION));

  connect_export_selection_signals (temp_xml);

  if (strcmp(SELECTION, "export_html_selection") == 0)
    {
      /* When exporting to HTML we only need the dirlist */
      gtk_widget_set_sensitive(GTK_WIDGET (export_selection->file_list), FALSE);
    }

  gtk_object_set_data (GTK_OBJECT (export_selection), MainWindowKey, main_window);
  gtk_widget_show (GTK_WIDGET (export_selection));
}
/* exported functions - END */
