/*
  GNOME Comics Organizer
  Copyright (C) 1999-2000 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "comiclist.h"

guint32 GUID = 1;

TIssue *Init_Issue()
{
  TIssue *TempIssue;

  TempIssue = g_malloc(sizeof(TIssue));

  TempIssue->IssueNo = g_string_new(NULL);
  TempIssue->Location = g_string_new(NULL);
  TempIssue->Price = g_string_new(NULL);
  TempIssue->CurrentPrice = g_string_new(NULL);
  TempIssue->PurchasePrice = g_string_new(NULL);
  TempIssue->Comment = g_string_new(NULL);
  TempIssue->Image = g_string_new(NULL);
  TempIssue->Writer = NULL;
  TempIssue->Penciller = NULL;
  TempIssue->Inker = NULL;
  TempIssue->Title = NULL;
  TempIssue->Condition = NearMint;
  TempIssue->Date = 0;
  TempIssue->ShowMe = TRUE;
  TempIssue->UID = AssignUID();

  TempIssue->ILinks = NULL;
  TempIssue->CLinks = NULL;

  return TempIssue;
}

TComic *Init_Comic()
{
  TComic *TempComic;

  TempComic = g_malloc(sizeof(TComic));

  TempComic->CTitle = g_string_new(NULL);
  TempComic->CPublisher = g_string_new(NULL);
  TempComic->CType = g_string_new(NULL);
  TempComic->CVolume = g_string_new(NULL);
  TempComic->CGroup = g_string_new(NULL);
  TempComic->LinkFile = g_string_new(NULL);
  TempComic->Comment = g_string_new(NULL);
  TempComic->ShowMe = TRUE;
  TempComic->IsLink = FALSE;
  TempComic->UID = AssignUID();

  TempComic->IssueNumbers = NULL;

  TempComic->ILinks = NULL;
  TempComic->CLinks = NULL;

  return TempComic;
}

guint32 AssignUID()
{
  return GUID++;
}

guint32 GetUID()
{
  return GUID;
}

void SetUID(guint32 setme)
{
  GUID = setme;
}

GString *Condition2GString(TCondition con)
{
  GString *TempGString;
  gchar *ConditionStrings[9];

  ConditionStrings[Poor] = "Poor";
  ConditionStrings[Fair] = "Fair";
  ConditionStrings[Good] = "Good";
  ConditionStrings[VeryGood] = "Very Good";
  ConditionStrings[Fine] = "Fine";
  ConditionStrings[FineVeryFine] = "Fine-Very Fine";
  ConditionStrings[VeryFine] = "Very Fine";
  ConditionStrings[NearMint] = "Near Mint";
  ConditionStrings[Mint] = "Mint";

  return (TempGString = g_string_new(ConditionStrings[con]));
}

/* compare functions - START */

/* helper functions - START */
gint get_int(GString *s)
{
  GString *ReturnGString;
  gchar c;
  gint i;
  gint return_gint;

  return_gint = 0;
  ReturnGString = g_string_new(NULL);
  if (s->len>0)
    {
      i=0;
      c=s->str[i];
      while ((i<s->len) && c!='-' && !isdigit(c)) /* still some string left, not a minus or a digit */
	{
	  i++;
	  c=s->str[i];
	}
      while ((i<s->len) && (c=='-' || isdigit(c))) /* still some string left, a minus or a digit */
	{
	  ReturnGString = g_string_append_c(ReturnGString, c);
	  i++;
	  c=s->str[i];
	}
      return_gint = atoi(ReturnGString->str);
    }

  return return_gint;
}

GString *get_head(GString *s)
{
  GString *ReturnGString;
  gchar c;
  gint i;

  ReturnGString = g_string_new(NULL);
  if (s->len>0)
    {
      i=0;
      c=s->str[i];
      while ((i<s->len) && c!='-' && !isdigit(c)) /* still some string left, not a minus or a digit */
	{
	  ReturnGString = g_string_append_c(ReturnGString, c);
	  i++;
	  c=s->str[i];
	}
    }
  return ReturnGString;
}
GString *get_tail(GString *s)
{
  GString *ReturnGString;
  gchar c;
  gint i;

  ReturnGString = g_string_new(NULL);
  if (s->len>0)
    {
      i=s->len;
      c=s->str[i];
      while ((i>0) && !isdigit(c)) /* still some string left, not a digit */
	{
	  ReturnGString = g_string_prepend_c(ReturnGString, c);
	  i--;
	  c=s->str[i];
	}
    }
  return ReturnGString;
}
/* helper functions - END  */

gint
CompareTComic_Title(gconstpointer a, gconstpointer b)
{
  const TComic *TCa, *TCb;
  gint return_value;
  gint int_a, int_b;
  
  TCa = a;
  TCb = b;

  return_value = strcmp(TCa->CGroup->str, TCb->CGroup->str);
  if (return_value==0) /* same group */
    {
      return_value = strcmp(TCa->CTitle->str, TCb->CTitle->str);

      if (return_value ==0) /* same title */
	{
	  int_a = get_int(TCa->CVolume);
	  int_b = get_int(TCb->CVolume);

	  return_value = (int_a - int_b);
	}
    }
  else /* different groups -- make sure that the empty get placed _after_ all others */
    {
      if (strcmp(TCa->CGroup->str, "")==0) return_value = 1;
      if (strcmp(TCb->CGroup->str, "")==0) return_value = -1;
    }

  return return_value;
}

gint
CompareTComic_Publisher(gconstpointer a, gconstpointer b)
{
  const TComic *TCa, *TCb;
  gint return_value;
  gint int_a, int_b;
  
  TCa = a;
  TCb = b;

  return_value = strcmp(TCa->CGroup->str, TCb->CGroup->str);
  if (return_value==0) /* same group */
    {
      return_value = strcmp(TCa->CPublisher->str, TCb->CPublisher->str);
      if (return_value ==0) /* same publisher */
	{
	  return_value = strcmp(TCa->CTitle->str, TCb->CTitle->str);

	  if (return_value ==0) /* same title */
	    {
	      int_a = get_int(TCa->CVolume);
	      int_b = get_int(TCb->CVolume);
	      
	      return_value = (int_a - int_b);
	    }
	}
    }
  else /* different groups -- make sure that the empty get placed _after_ all others */
    {
      if (strcmp(TCa->CGroup->str, "")==0) return_value = 1;
      if (strcmp(TCb->CGroup->str, "")==0) return_value = -1;
    }

  return return_value;
}

gint
CompareTComic_Type(gconstpointer a, gconstpointer b)
{
  const TComic *TCa, *TCb;
  gint return_value;
  gint int_a, int_b;
  
  TCa = a;
  TCb = b;

  return_value = strcmp(TCa->CGroup->str, TCb->CGroup->str);
  if (return_value==0) /* same group */
    {
      return_value = strcmp(TCa->CType->str, TCb->CType->str);
      if (return_value ==0) /* same type */
	{
	  return_value = strcmp(TCa->CTitle->str, TCb->CTitle->str);

	  if (return_value ==0) /* same title */
	    {
	      int_a = get_int(TCa->CVolume);
	      int_b = get_int(TCb->CVolume);
	      
	      return_value = (int_a - int_b);
	    }
	}
    }
  else /* different groups -- make sure that the empty get placed _after_ all others */
    {
      if (strcmp(TCa->CGroup->str, "")==0) return_value = 1;
      if (strcmp(TCb->CGroup->str, "")==0) return_value = -1;
    }

  return return_value;
}

gint
CompareTIssue_IssueNo(gconstpointer a, gconstpointer b)
{
  GString *head_a, *head_b, *tail_a, *tail_b;
  gint int_a, int_b;

  const TIssue *TIa, *TIb;
  gint return_value;
  
  TIa = a;
  TIb = b;

  head_a = get_head(TIa->IssueNo);
  head_b = get_head(TIb->IssueNo);
  tail_a = get_head(TIa->IssueNo);
  tail_b = get_head(TIb->IssueNo);
  int_a  = get_int(TIa->IssueNo);
  int_b  = get_int(TIb->IssueNo);

  return_value = strcmp(head_a->str, head_b->str);
  if (return_value == 0) /* head parts are the same */
    {
      return_value = (int_a - int_b);
      if (return_value == 0) /* integer parts are the same */
	{
	  return_value = strcmp(tail_a->str, tail_b->str);
	  if (return_value!=0) /* different tails -- make sure that the empty get placed _after_ all others */
	    {
	      if (strcmp(tail_a->str, "")==0) return_value = 1;
	      if (strcmp(tail_b->str, "")==0) return_value = -1;
	    }
	}
    }
  else /* different heads -- make sure that the empty get placed _after_ all others */
    {
      if (strcmp(head_a->str, "")==0) return_value = 1;
      if (strcmp(head_b->str, "")==0) return_value = -1;
    }

  return return_value;
}
/* compare functions - END */



/* this should only be used for debugging  */
void ASCIIDumpComicList(GList *clist)
{
  TComic *TempComic;
  TIssue *TempIssue;
  guint32 i,j,k,l,m,n;
  GString *String;

  g_print("%i comic title(s)\n\n\n\n", j=g_list_length(clist));
  for(i=0;i<j;i++)
    {
      TempComic = (g_list_nth(clist,i))->data;
      g_print("%s", TempComic->CTitle->str);
      if(TempComic->IsLink)
	g_print(" (is a link to %s)\n", TempComic->LinkFile->str);
      else
	g_print(" (Vol. %s, %s, %s)\n", TempComic->CVolume->str,
		TempComic->CType->str, TempComic->CPublisher->str);
      g_print("Comment: %s\n", TempComic->Comment->str);
      g_print("Comic UID: %i\n", TempComic->UID);

      if(TempComic->IssueNumbers!=NULL)
	{
	  g_print("%i issue(s)\n", l=g_list_length(TempComic->IssueNumbers));

	  for(k=0;k<l;k++)
	    {
	      TempIssue = (g_list_nth(TempComic->IssueNumbers,k))->data;

	      g_print("  Issue #%s:\n",TempIssue->IssueNo->str);

	      g_print("    Writer(s)\n");
	      n=g_list_length(TempIssue->Writer);
	      for(m=0;m<n;m++)
		{ 
		  String = g_list_nth(TempIssue->Writer, m)->data;
		  g_print("      %s\n", String->str);
		}

	      g_print("    Penciller(s)\n");
	      n=g_list_length(TempIssue->Penciller);
	      for(m=0;m<n;m++)
		{ 
		  String = g_list_nth(TempIssue->Penciller, m)->data;
		  g_print("      %s\n", String->str);
		}

	      g_print("    Inker(s)\n");
	      n=g_list_length(TempIssue->Inker);
	      for(m=0;m<n;m++)
		{ 
		  String = g_list_nth(TempIssue->Inker, m)->data;
		  g_print("      %s\n", String->str);
		}

	      g_print("    StoryTitle(s)\n");
	      n=g_list_length(TempIssue->Title);
	      for(m=0;m<n;m++)
		{ 
		  String = g_list_nth(TempIssue->Title, m)->data;
		  g_print("      %s\n", String->str);
		}

	      g_print("    Location: %s\n", TempIssue->Location->str);
	      g_print("    CoverPrice: %s\n", TempIssue->Price->str);
	      g_print("    Current Price: %s\n", TempIssue->CurrentPrice->str);
	      g_print("    Purchase Price: %s\n", TempIssue->PurchasePrice->str);
	      g_print("    Image: %s\n", TempIssue->Image->str);
	      g_print("    Condition: %i\n", TempIssue->Condition);
	      g_print("    Comment: %s\n", TempIssue->Comment->str);
	      g_print("    Issue UID: %i\n", TempIssue->UID);
	    }
	}
      else
	{
	  g_print("no issues\n");
	}
      g_print("\n\n");
    }
}
