/* ANSI-C code produced by gperf version 2.7 */
/* Command-line: gperf -k 1-3,$ -L ANSI-C -l -C -c -N types_lookup types.gperf  */
/*
 * Gnome Basic type names.
 *
 * Author:
 *     Jody Goldberg (jgoldberg@home.com)
 */
#include <glib.h>
#include <string.h>

#define TOTAL_KEYWORDS 13
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 8
#define MIN_HASH_VALUE 2
#define MAX_HASH_VALUE 22
/* maximum key range = 21, duplicates = 0 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static const unsigned char asso_values[] =
    {
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23,  0, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 15,  0,  0, 23,
      23, 23, 23,  5, 23, 23,  5, 23, 23, 15,
      23, 23, 23,  5, 23, 23,  0, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23,  0,  0, 10,
      23,  0, 23,  0, 23,  5,  0, 23,  0, 23,
       0,  0, 23, 23,  0, 23,  0,  0, 23, 23,
      23,  0, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
      23, 23, 23, 23, 23, 23
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 3:
        hval += asso_values[(unsigned char)str[2]];
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval + asso_values[(unsigned char)str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
const char *
types_lookup (register const char *str, register unsigned int len)
{
  static const unsigned char lengthtable[] =
    {
       0,  0,  2,  0,  4,  0,  6,  7,  8,  4,  0,  6,  7,  0,
       0,  0,  6,  7,  0,  4,  0,  6,  7
    };
  static const char * const wordlist[] =
    {
      "", "",
      "%%",
      "",
      "Date",
      "",
      "Double",
      "Variant",
      "Currency",
      "Long",
      "",
      "String",
      "Integer",
      "", "", "",
      "Single",
      "Decimal",
      "",
      "Byte",
      "",
      "Object",
      "Boolean"
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        if (len == lengthtable[key])
          {
            register const char *s = wordlist[key];

            if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
              return s;
          }
    }
  return 0;
}
char const *
gb_is_type (char const * str, unsigned const len)
{
    char const * const type = types_lookup (str, len);
    if (!type)
	return NULL;
#if 0
    printf ("Type : %s\n", type);
#endif
    return type;
}
