#!/bin/sh

echo $1 | grep -i -q help  
if [ "$?" = 0 ]
then
   echo 'usage: install.sh path'
   echo 'If path parameter is not supplied, /usr/bin will be used'
   exit 1
fi

if [ "$1" = "" ]
then
   INSTALL_PATH=/usr/bin
else
   INSTALL_PATH=$1
fi

if [ ! -d $INSTALL_PATH ]
then
  echo Destination path does not exist or it is not a directory
  echo "*** INSTALL UNSUCCESSFUL ***"
  exit 1
fi

# First of all, test if ImageMagick suite is available
my_error='0'
echo Checking ImageMagick suite
echo -n "  Is 'convert' present ? " 
convert 1> /dev/null 2>/dev/null
if [ $? = '0' ]
then
    my_test=`convert | grep '@(#)ImageMagick' | awk '{ print $2 }'`
    if [ "$my_test" = "@(#)ImageMagick" ]
    then
        echo ' Yes'
    else
        echo ' No'
        my_error='1'
    fi
else
  echo ' No'
  my_error='1'
fi

echo -n "  Is 'identify' present ?"
identify 1> /dev/null 2>/dev/null
if [ $? = '0' ]
then
    my_test=`identify | grep '@(#)ImageMagick' | awk '{ print $2 }'`
    if [ "$my_test" = "@(#)ImageMagick" ]
    then
        echo ' Yes'
    else
        echo ' No' 
        my_error='1'
    fi
else
  echo ' No'
  my_error='1'
fi
echo
echo Checking Perl
echo -n "  Is Perl present ? "
perl -v 1> /dev/null 2>/dev/null

if [ $? = '0' ]
then
  echo ' Yes'
else
  echo ' No'
  my_error='2'
fi

if [ "$my_error" = "1" ]
then
   echo 'Ooops sorry but ImageMagick was not found in this system. Check http://www.imagemagick.org'
   echo You can\'t run Galrey.
   echo "*** INSTALL UNSUCCESSFUL ***"
   exit 1
fi

if [ "$my_error" = "2" ]
then
   echo 'Ooops sorry but Perl was not found in this system. Check http://www.perl.org'
   echo You can\'t run Galrey.
   echo "*** INSTALL UNSUCCESSFUL ***"
   exit 1
fi

# ImageMagick is present

echo
echo Copying galrey.pl in $INSTALL_PATH
install galrey.pl $INSTALL_PATH 2>/dev/null

if [ "$?" != "0" ]
then
  echo Ooops... you can\'t write in $INSTALL_PATH. Perhaps you need to be root ?
  echo
  echo "*** INSTALL UNSUCCESSFUL ***"
  echo
  exit 1
fi

echo Copying galrey.rc in /etc
install galrey.rc /etc 2>/dev/null

if [ "$?" = "0" ]
then
  echo
  echo "Done. Have fun with Galrey !"
  echo "(but first read README !)"
else
  echo Ooops... you can\'t write in /etc. Perhaps you need to be root ?
  echo
  echo "*** INSTALL UNSUCCESSFUL ***"
  echo
fi











