/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: RCSFilePreview.h,v 1.6 2004/06/13 21:20:37 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __RCSFILEPREVIEW_H_
#define __RCSFILEPREVIEW_H_

#include <rcsfilepreview_q.h>
#include "RCS.h"

#include <qfiledialog.h>
#include <qlistview.h>

#include <map>

class RCSFileDialog;

class RCSViewItem : public QListViewItem {

 public:

    RCSViewItem(QListView *parent)     : QListViewItem(parent) {}
    RCSViewItem(QListViewItem *parent) : QListViewItem(parent) {}
    virtual int compare(QListViewItem *i, int col, bool ascending) const;

};

class RCSFilePreview : public RCSFilePreview_q,
                       public QFilePreview
{
    Q_OBJECT

    RCS                      *rcs;
    QString                   current_file;
    std::map<QString,QString> rcsComments;
    RCSFileDialog            *dialog;
    
    void showFileRLog( const QString &filename );
    
 public:
    RCSFilePreview( RCSFileDialog *parent );
    ~RCSFilePreview();
    void     previewUrl( const QUrl &u );
    RCS*     getSelectedRev();
    
public slots:

 virtual void openReadOnly();
 virtual void selectedRevision(QListViewItem *itm);

};

#endif
