#define SET_MAX_IMAGES	(4)
#define SET_MAX_HAPPY	(6)
#define SET_MAX_PER_ROW	(5)


int FUNCTION_NAME(FILE *outFile, t_stats *pStats, t_config *pCfg)
{
 char *hBarImages[SET_MAX_IMAGES] = { "blue-h.png", "green-h.png", "yellow-h.png", "red-h.png" };
 char *vBarImages[SET_MAX_IMAGES] = { "blue-v.png", "green-v.png", "yellow-v.png", "red-v.png" };
 long int iRank, tmpShowMax, tmpShowAlmostMax;
 int i, j, iHour;
 t_float graphScale, happyScale, sadScale;
 t_user_entry *pUser;
 char *tmpDataPath, *tmpCSSPath, *tmpChanName,
      *tmpIrcNet, *tmpMessage, *tmpDateFormat;
 BOOL tmpShowHappy, tmpShowComment, tmpShowPicture;
 time_t tmpTime;
 struct tm *tmpLocalTime;
 char tmpTimeStr[SET_MAX_BUF + 1];

 /* Get settings from configuration */
 tmpDataPath = th_config_get_str(pCfg, CFG_XHTML_IMAGE_PATH, ".");
 tmpCSSPath = th_config_get_str(pCfg, CFG_XHTML_CSS_PATH, "style.css");

 tmpChanName = th_config_get_str(pCfg, CFG_GEN_CHANNEL, NULL);
 tmpIrcNet = th_config_get_str(pCfg, CFG_GEN_IRCNET, NULL);
 tmpMessage = th_config_get_str(pCfg, CFG_GEN_MESSAGE, NULL);
 tmpDateFormat = th_config_get_str(pCfg, CFG_GEN_DATEFORMAT, DEF_GEN_DATEFORMAT);
 tmpShowMax = th_config_get_int(pCfg, CFG_GEN_SHOWMAX, CFG_GEN_SHOWMAX_DEF);
 tmpShowAlmostMax = th_config_get_int(pCfg, CFG_GEN_SHOWREST, CFG_GEN_SHOWREST_DEF);

 tmpShowHappy = th_config_get_bool(pCfg, CFG_GEN_STAT_TOP_HAPPY, TRUE);
 tmpShowComment = th_config_get_bool(pCfg, CFG_GEN_STAT_TOP_COMMENT, TRUE);
 tmpShowPicture = th_config_get_bool(pCfg, CFG_GEN_STAT_TOP_PICTURE, FALSE);

 /* Get time/date string */
 time(&tmpTime);
 tmpLocalTime = localtime(&tmpTime); 
 if (strftime(tmpTimeStr, sizeof(tmpTimeStr), tmpDateFormat, tmpLocalTime) == 0)
 	{
 	tmpTimeStr[0] = 0;
 	}
    
 /* Output stats as XHTML */
 fprintf(outFile,
	"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n"
	"<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
	"<head>\n"
	" <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\" />\n"
	);

 fprintf(outFile,
	" <link rel=\"stylesheet\" title=\"Default\" href=\"%s\" type=\"text/css\" />\n"
	" <meta name=\"Author\" content=\"" RA_NAME " v" RA_VERSION " (Fast IRC Stats Generator)\" />\n"
	" <title>" RA_NAME " Statistics for %s%s%s</title>\n"
	"</head>\n"
	"<body>\n",
	tmpCSSPath,
	(tmpChanName != NULL) ? tmpChanName : "#?????",
	(tmpIrcNet != NULL) ? " @ " : "",
	(tmpIrcNet != NULL) ? tmpIrcNet : ""
	);

 fprintf(outFile,
 	"<div align=\"center\">\n"
	"<div class=\"icontents\">\n"
	" <div class=\"iinfo\">\n"
	"  <h1>%s%s%s</h1>\n"
	"  <p class=\"idate\">Statistics generated on <b>%s</b></p>\n"
/*
	"  <p class=\"ivisitors\">During this <b>%ld</b>-day reporting period, a total of <b>%ld</b> different nicks/users were represented on <b>%s</b>.</p>\n"
*/
	"  <p class=\"ivisitors\">A total of <b>%ld</b> different nicks/users were represented on <b>%s</b>.</p>\n"
	"  <p class=\"imessage\">%s</p>\n"
	" </div>\n",

	(tmpChanName != NULL) ? tmpChanName : "#?????",
	(tmpIrcNet != NULL) ? " @ " : "",
	(tmpIrcNet != NULL) ? tmpIrcNet : "",

	tmpTimeStr,
/*	pStats->nDays, */
	pStats->nUsers,
	(tmpChanName != NULL) ? tmpChanName : "#?????",
	(tmpMessage != NULL) ? tmpMessage : ""
	);

 /*
  * DAILY ACTIVITY
  */
 if (th_config_get_bool(pCfg, CFG_GEN_STAT_ACTIVE, TRUE))
 {
 if (pStats->activityPeak >= 0)
 if (pStats->activityPercentPerHour[pStats->activityPeak] > 0)
 {
 fprintf(outFile,
	"<!-- ============================================= -->\n"
	" <div class=\"ihourly\">\n"
	"  <h2>Most active times</h2>\n"
	"  <table" TABLE_PARAMS " class=\"ihourly\" align=\"center\">\n"
	"   <tr>\n"
	);
 
 graphScale = (100 / pStats->activityPercentPerHour[pStats->activityPeak]);
 for (iHour = 0; iHour < SET_HOURS_DAY; iHour++)
	{
	fprintf(outFile,
	"    <th valign=\"bottom\">%1.1f%%<br />"
	"<img src=\"%s/%s\" width=\"15\" height=\"%d\" alt=\"%1.1f%%\" /></th>\n",

	pStats->activityPercentPerHour[iHour],
	tmpDataPath, vBarImages[iHour / SET_DAY_DIVISOR],
	(int) (pStats->activityPercentPerHour[iHour] * graphScale),
	pStats->activityPercentPerHour[iHour]);
	}

 fprintf(outFile,
 	"   </tr>\n"
 	"   <tr>\n"
 	);

 for (iHour = 0; iHour < SET_HOURS_DAY; iHour++)
	{
	fprintf(outFile,
	"    <td class=\"%s\">%i</td>\n",
	(iHour == pStats->activityPeak) ? "hirank" : "rank", iHour);
	}

 fprintf(outFile,
 	"   </tr>\n"
 	"  </table>\n"
 	"\n"
 	"  <table" TABLE_PARAMS " class=\"ihourbars\" align=\"center\">\n"
 	"   <tr>\n"
 	);
 	
 for (iHour = 0; iHour < SET_HOURS_DAY; iHour += SET_DAY_DIVISOR)
 	{
 	fprintf(outFile,
	"    <td class=\"asmall\"><img src=\"%s/%s\" width=\"40\" height=\"15\" alt=\"%i-%i\" /> = %i-%i</td>\n",
	tmpDataPath, hBarImages[iHour / SET_DAY_DIVISOR],
	iHour, (iHour+SET_DAY_DIVISOR-1),
	iHour, (iHour+SET_DAY_DIVISOR-1));
	}

 fprintf(outFile,
 	"   </tr>\n"
 	"  </table>\n"
 	" </div>\n"
	);
 }
 
 } /* if (CFG_GEN_STAT_ACTIVE) */

 /*
  * TOP TALKERS
  */
 if (th_config_get_bool(pCfg, CFG_GEN_STAT_TOP, TRUE))
 {
 fprintf(outFile,
	"<!-- ============================================= -->\n"
	" <div class=\"itoptalkers\">\n"
	"  <h2>Most active users</h2>\n"
 	"  <table" TABLE_PARAMS " class=\"itoptalkers\" align=\"center\">\n"
 	"   <tr>\n"
 	"    <th width=\"2%%\" class=\"nrank\">#</th>\n"
	);

 fprintf(outFile,
	"%s"
 	"    <th width=\"10%%\" class=\"nhandle\">Nickname</th>\n"
 	"    <th width=\"6%%\" class=\"npublics\">Lines</th>\n"
 	"    <th width=\"15%%\" class=\"nactivity\">Activity</th>\n"
 	"    <th width=\"5%%\" class=\"nwords\">Words</th>\n"
 	"    <th width=\"2%%\" class=\"nwpp\">W/P</th>\n"
 	"    <th width=\"2%%\" class=\"ncpw\">C/W</th>\n"
	"%s"
	"%s"
	"   </tr>\n",
	(tmpShowHappy) ? "    <th width=\"2%%\" class=\"nhappiness\">?</th>\n" : "",
 	(tmpShowComment) ? "    <th width=\"50%%\" class=\"ncomment\">Comment</th>\n" : "",
 	(tmpShowPicture) ? "    <th width=\"5%%\" class=\"npicture\">Picture</th>\n" : ""
	);
 
 if (fabs(pStats->mostHappy->nHappiness) > 0)
 	happyScale = fabs(pStats->mostHappy->nHappiness);
 	else
 	happyScale = 1.0f;

 if (fabs(pStats->mostSad->nHappiness) > 0)
	sadScale = fabs(pStats->mostSad->nHappiness);
	else
	sadScale = 1.0f;

 for (iRank = 0; iRank < ((pStats->nUsers >= tmpShowMax) ? tmpShowMax : pStats->nUsers); iRank++)
 	{
	/* Get user */
	pUser = pStats->userIndex[iRank];

	/* Print one line */ 	
 	fprintf(outFile,
 	"   <tr>\n"
 	"    <td class=\"nrank\">%ld</td>\n",
 	(iRank + 1)
	);

	if (tmpShowHappy)
	{
	if (pUser->nHappiness > 0)
		j = 3 + (int) ((pUser->nHappiness * 3.0f) / happyScale);
		else
		j = 3 + (int) ((pUser->nHappiness * 2.0f) / sadScale);

 	fprintf(outFile,
	"    <td class=\"nhappiness\"><img src=\"%s/happy%i.gif\" alt=\"%i\" /></td>\n",
	tmpDataPath, j, j);
	}

 	fprintf(outFile,
 	"    <td class=\"nhandle\">%s</td>\n"
 	"    <td class=\"npublics\">%ld</td>\n"
 	"    <td class=\"nactivity\">",
 	pUser->userHandle,
 	pUser->nPublics
 	);

	for (iHour = 0; iHour < SET_HOURS_DAY; iHour += SET_DAY_DIVISOR)
	 	{
	 	graphScale = 0;
	 	for (j = 0; j < SET_DAY_DIVISOR; j++)
	 		graphScale += (pUser->activityPercentPerHour[iHour + j] / 1.5f);

		if (graphScale >= 1.0f)
			{
		 	fprintf(outFile,
		 	"<img src=\"%s/%s\" width=\"%i\" height=\"15\" alt=\"\" />",
		 	tmpDataPath, hBarImages[iHour / SET_DAY_DIVISOR],
		 	(int) (graphScale));
		 	}
		}	

 	fprintf(outFile,
 	"</td>\n"
 	"    <td class=\"nwords\">%ld</td>\n"
 	"    <td class=\"nwpp\">%1.2f</td>\n"
 	"    <td class=\"ncpw\">%1.2f</td>\n",
 	pUser->nWords,
 	pUser->nWordsPerPublic,
 	pUser->nCharsPerWord
 	);

	if (tmpShowComment)
	{
 	fprintf(outFile,
 	"    <td class=\"ncomment\">");

	if (pUser->sComment)
		{
/*		if (strstr(pUser->sComment, "http://")) 
		fprintf(stderr, "[%s] comm: %p\n", pUser->userHandle, pUser->sComment);	
*/
		fputs(pUser->sComment, outFile);
		}

	fprintf(outFile, "</td>\n");
	}

	if (tmpShowPicture)
	{
 	fprintf(outFile,
 	"    <td class=\"npicture\">");

	if (pUser->picPath)
		fprintf(outFile, "<img src=\"%s/%s\">",
		tmpDataPath, pUser->picPath);

	fprintf(outFile, "</td>\n");
	}

 	fprintf(outFile,
 	"   </tr>\n");
 	}

 fprintf(outFile,
 	"  </table>\n"
	"<!-- ============================================= -->\n"
	);

 /*
  * ALMOST MADE IT...
  */
 if (th_config_get_bool(pCfg, CFG_GEN_STAT_ALMOST, TRUE))
 {
 if (iRank < pStats->nUsers)
 {
 fprintf(outFile,
 	" <h3>These didn't make it to the top:</h3>\n"
 	" <table" TABLE_PARAMS " class=\"ialmosttop\">\n"
 	);

 j = (pStats->nUsers >= (iRank + tmpShowAlmostMax)) ? (iRank + tmpShowAlmostMax) : pStats->nUsers;
 i = -1;	
 for (; iRank < j; iRank++)
 	{
	/* Get user */
	pUser = pStats->userIndex[iRank];
 	if (i < 1)
 		{
 		if (i >= 0)
 		fprintf(outFile, "  </tr>\n");

 		if ((j - iRank) >= SET_MAX_PER_ROW)
 		fprintf(outFile, "  <tr>\n");

 		i = SET_MAX_PER_ROW;
 		}

	fprintf(outFile,
		"   <td>%s (%ld)</td>\n",
		pUser->userHandle,
		pUser->nPublics
		);
	i--; 		
	}

 if (i >= 0)
 	fprintf(outFile, "  </tr>\n");

 fprintf(outFile,
 	" </table>\n"
	);
	
 /* Rest of nicks */
 if (iRank < pStats->nUsers)
 	{
 	fprintf(outFile,
 		" <h3>There were also <b>%ld</b> other nicks</h3>\n",
 		(pStats->nUsers - iRank)
 		);
 	}
 }
 
 } /* if (CFG_GEN_STAT_ALMOST)  */

 fprintf(outFile,
 	" </div>\n"
	"<!-- ============================================= -->\n"
	);

 } /* if (CFG_GEN_STAT_TOP) */

 /*
  * BIG NUMBERS
  */
 if (th_config_get_bool(pCfg, CFG_GEN_STAT_BIGNUM, TRUE))
 {
 fprintf(outFile,
 	"<div class=\"ibignumbers\">\n"
 	" <h2>Big Numbers</h2>\n");

 if (pStats->mostStupid)
	{
	fprintf(outFile,
 	" <p class=\"isection\">\n"
 	"  Is <b>%s</b> stupid or just asking too many questions? <b>%1.1f%%</b> of his lines contained a question!\n"
 	" </p>\n",
	pStats->mostStupid->userHandle,
	((t_float) pStats->mostStupid->nQuestions / (t_float) pStats->mostStupid->nPublics) * 100.0f);
	}

 if (pStats->mostLoud)
	{
	fprintf(outFile,
 	" <p class=\"isection\">\n"
 	"  The loudest one was <b>%s</b>, who yelled <b>%1.1f%%</b> of the time."
 	" </p>\n",
	pStats->mostLoud->userHandle,
	((t_float) pStats->mostLoud->nYelling / (t_float) pStats->mostLoud->nPublics) * 100.0f);
	}

 if (pStats->mostURLs)
	{
	fprintf(outFile,
 	" <p class=\"isection\">\n"
 	"  Total of <b>%ld</b> URLs were pasted by <b>%s</b>!!\n"
 	" </p>\n",
 	pStats->mostURLs->nURLs, pStats->mostURLs->userHandle);
	}
 
 if (pStats->mostJoins)
	{
	fprintf(outFile,
 	" <p class=\"isection\">\n"
 	"  <b>%s</b> didn't know whether to stay. He/she joined the channel <b>%ld</b> times!\n"
 	" </p>\n",
 	pStats->mostJoins->userHandle, pStats->mostJoins->nJoins);
	}
 
 if (pStats->mostKicks)
	{
	fprintf(outFile,
 	" <p class=\"isection\">\n"
 	"  <b>%s</b> kicked the ass most, <b>%ld</b> times to be exact!\n"
 	" </p>\n",
 	pStats->mostKicks->userHandle, pStats->mostKicks->nKicks);
	}

 if (pStats->mostKicked)
	{
	fprintf(outFile,
 	" <p class=\"isection\">\n"
 	"  Obviously someone does not like <b>%s</b>, he/she was kicked <b>%ld</b> times!\n"
 	" </p>\n",
 	pStats->mostKicked->userHandle, pStats->mostKicked->nGotKicked);
	}
 
 
 if (pStats->mostCaps && (pStats->mostCaps->nCapsPercent > 0.1f))
	{
	fprintf(outFile,
 	" <p class=\"isection\">\n"
 	"  <b>%s</b> is a clear caps-abuser, <b>%1.1f%%</b> of time he/she wrote in CAPS."
 	" </p>\n",
	pStats->mostCaps->userHandle, pStats->mostCaps->nCapsPercent);
	}

 if (pStats->mostHappy)
	{
	fprintf(outFile,
 	" <p class=\"isection\">\n"
 	"  <b>%s</b> is either using drugs or is otherwise very <b>happy</b> person <b>;D</b>"
 	" </p>\n",
	pStats->mostHappy->userHandle);
	}

 if (pStats->mostSad)
	{
	fprintf(outFile,
 	" <p class=\"isection\">\n"
 	"  On the other hand <b>%s</b> seems to be quite <b>sad</b> <b>:(</b>"
 	" </p>\n",
	pStats->mostSad->userHandle);
	}

 fprintf(outFile,
 	"</div>\n"
	"<!-- ============================================= -->\n"
	);
 }

 /*
  * INFO footer
  */
 fprintf(outFile,
	" <div class=\"irestinfo\">\n"
	"  <p class=\"ilines\">Totals analyzed: <b>%ld</b> lines in <b>%ld</b> logfiles"
	"  summing to appr. <b>%1.2f</b> MB.</p>\n"
	"  <p class=\"iauthor\">Statistics generated by "
	"<a href=\"http://www.tnsp.org/fisg.php\">" RA_NAME
	" (" RA_FULLNAME ") v" RA_VERSION "</a> " RA_COPYRIGHT "</p>\n"
	"  <p class=\"itime\">Stats generated in <b>%ld hours, %ld minutes and %ld seconds</b>.</p>\n"
	" </div>\n",
	pStats->nLines, pStats->nLogFiles, ((t_float) pStats->nChars) / (1024.0f*1024.0f),
	(pStats->nTimeElapsed / (60*60)),
	(pStats->nTimeElapsed % (60*60)) / 60, 
	(pStats->nTimeElapsed % (60*60)) % 60
	);

 /* Output HTML footer */
 fprintf(outFile,
	"<!-- ============================================= -->\n"
	"</div>\n"
	"</div>\n"
	"</body>\n"
	"</html>\n");

 return 0;
}


