<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).
*/

include_once 'backend/base.inc';
include_once 'backend/invalbal.inc';
include get_lang_inc( '-booking' );

########################################
# validate and copy generic arguments
########################################
$id = get_http_int( 'id', 1 );
$repid = get_http_int( 'repid', 1 );
$repDays = get_http_int( 'repDays', 1 );
$repMonths = get_http_int( 'repMonths', 1 );
$repeat = $HTTP_GET_VARS['repeat'];

########################################
# action 'delete from journal'
########################################
if( $HTTP_GET_VARS['delete'] && !is_null( $id ) ) {
    # invalidate debit and credit acc 
    $accs = $db->getRow( 'select debit_acc, credit_acc from journal where id='.$id );
    if( !check_res_delay( $accs, $LANG_ERR_readj ) ) {
	invalidate_balance( $accs[0] );
	invalidate_balance( $accs[1] );

	# forward to journal
	if( !check_res_delay( $db->query( 'delete from journal where id=' . $id), 
			      $LANG_err_delj ) ) {
	    header( 'Location: journal.php' );
	    exit;
	}
    }
}

########################################
# action 'delete from repeated'
########################################
if( $HTTP_GET_VARS['delete'] && !is_null( $repid ) ) {
    # forward to repeated
    if( !check_res_delay( $db->query( 'delete from repeated where id=' . $repid), 
			      $LANG_err_delrep ) ) {
	header( 'Location: repeated.php' );
	exit;
    }
}

########################################
# if actions are given, extract variables and check them for validity
########################################
if( $HTTP_GET_VARS['add'] || $HTTP_GET_VARS['change'] ) {
    $debit_acc = get_http_int( 'debit_acc', 1, $LANG_err_debacc );
    $credit_acc = get_http_int( 'credit_acc', 1, $LANG_err_credacc );
    $value = get_http_formatfloat( 'value', 1, $LANG_err_value );

    if( !$HTTP_GET_VARS['receipt'] )
	$receipt = null;
    else 
	$receipt = get_http_int( 'receipt', 1, $LANG_err_receipt );

    if( $HTTP_GET_VARS['description'] )
	# unslash and escape quotes
	$description = str_replace( "'", "''", stripslashes( $HTTP_GET_VARS['description'] ) );	
    else
	$fail = $LANG_err_emptydesc;

    $time = $HTTP_GET_VARS['time' ];
    if( !preg_match( '/^\s*\d\d\d\d-\d\d-\d\d\s*$/', $time ) &&
	!preg_match( '/^\s*\d\d\d\d-\d\d-\d\d\s+\d\d?:\d\d\s*$/', $time ) )
	$fail = $LANG_err_date;
}

########################################
# action 'insert new entry into journal'
########################################
if( $HTTP_GET_VARS['add'] && !$fail && is_null( $id ) && is_null( $repid ) ) {
    if( $HTTP_GET_VARS['repeat'] == 'once' ) {
	$newid = $db->getOne( 'select max(id) from journal' ) + 1;
	if( !check_res_delay( $newid, $LANG_err_maxidj ) ) 
	    $res = $db->query( "insert into journal values( $newid, " .
			       $debit_acc . ", " . $credit_acc . ", " . $value . ", "
			       . ( $receipt ? $receipt : 'null' ). ", '" . $description
			       . "', '" . $time . "')" );
    }
    else if( $HTTP_GET_VARS['repeat'] == 'daily' ) {
	if( is_numeric( $HTTP_GET_VARS['repDays'] ) && $HTTP_GET_VARS['repDays'] > 0 ) {
	    $repDays = intval( $HTTP_GET_VARS['repDays'] );
	    $newid = $db->getOne( 'select max(id) from repeated' ) + 1;
	    if( !check_res_delay( $newid, $LANG_err_maxidr ) ) 
		$res = $db->query( "insert into repeated values( $newid, " .
				     $debit_acc . ", " . $credit_acc . ", " .
				     $value . ", " . ( $receipt ? $receipt : 'null' ) . ", '" .
				     $description . "', '" . $time . "', " . 
				     $repDays . ", null)" );
	} else
	    $fail = $LANG_err_dayrep;
    }
    else if( $HTTP_GET_VARS['repeat'] == 'monthly' ) {
	if( is_numeric( $HTTP_GET_VARS['repMonths'] ) && $HTTP_GET_VARS['repMonths'] > 0 ) {
	    $repMonths = intval( $HTTP_GET_VARS['repMonths'] );
	    $newid = $db->getOne( 'select max(id) from repeated' ) + 1;
	    if( !check_res_delay( $newid, $LANG_err_maxidr ) ) 
		$res = $db->query( "insert into repeated values( $newid, " .
				     $debit_acc . ', ' . $credit_acc . ', ' .
				     $value . ', ' . ( $receipt ? $receipt : 'null' ) . ", '" .
				     $description . "', '" . $time . 
				     "', null, " . $repMonths . ")" );
	} else
	    $fail = $LANG_err_monthrep;
    }
    else
	$fail = $LANG_err_repmode;
    
    if( !$fail && !check_res_delay( $res, $LANG_err_insertj ) ) {
	invalidate_balance( $debit_acc );
	invalidate_balance( $credit_acc );
	header( 'Location: journal.php' );
	exit;
    }
}

########################################
# action 'change journal entry'
########################################
if( $HTTP_GET_VARS['change'] && !$fail && !is_null( $id ) && is_null( $repid ) ) {
    # invalidate debit and credit acc
    $accs = $db->getRow( 'select debit_acc, credit_acc from journal where id='.$id );
    if( !check_res_delay( $accs, $LANG_ERR_readj ) ) {
	invalidate_balance( $accs[0] );
	invalidate_balance( $accs[1] );
	invalidate_balance( $debit_acc );
	invalidate_balance( $credit_acc );

	$q = 'update journal set debit_acc=' . $debit_acc . ', credit_acc='
	    . $credit_acc . ', value=' . $value . ', receipt=' . ( $receipt ? $receipt : 'null' )
	    . ", description='" . $description . "', time='" . $time
	    . "'" . ' where id=' . $id;

	if( !check_res_delay( $db->query( $q ), $LANG_err_updatej ) ) {
	    header( 'Location: journal.php' );
	    exit;
	}
    }
}

########################################
# action 'change repeated entry'
########################################
if( $HTTP_GET_VARS['change'] && !$fail && is_null( $id ) && !is_null( $repid ) ) {
    if( $repeat == 'daily' ) {
	$repMonths = null;
	if( $repDays <= 0 ) {
	    $fail = $LANG_err_dayrep;
	    $repDays = null;
	}
    } else if( $repeat == 'monthly' ) {
	$repDays = null;
	if( $repMonths <= 0 ) {
	    $fail = $LANG_err_monthrep;
	    $repMonths = null;
	}
    } else
	$fail = $LANG_err_repmode;

    if( !$fail ) {
	$q = 'update repeated set debit_acc=' . $debit_acc . ', credit_acc='
	    . $credit_acc . ', value=' . $value . ', receipt=' . ( $receipt ? $receipt : 'null' )
	    . ", description='" . $description . "', nextdue='" .  $time . "', repdays="
	    . ( $repDays ? $repDays : 'null' ) . ', repmonths=' . ( $repMonths ? $repMonths : 'null' )
	    . ' where id=' . $repid;

	if( !check_res_delay( $db->query( $q ), $LANG_err_updaterep ) ) {
	    header( 'Location: repeated.php' );
	    exit;
	}
    }
}

########################################
# page header and $fail display
########################################
include 'pagehead-html.inc';

if( $fail )
    echo "<p class=\"error\">$LANG_error: $fail</p>\n";

########################################
# set field default contents (from GET vars or current db values)
########################################
if( $id ) { # came from journal 
    $r = $db->getRow( 'select debit_acc, credit_acc, value, receipt, description, '
		    . 'extract(YEAR from time), extract(MONTH from time), extract(DAY from time),'
		    . 'extract(HOUR from time), extract(MINUTE from time) from journal where id='.$id );
    check_res( $r, $LANG_err_readj );
    if( !$debit_acc ) $debit_acc = $r[0];
    if( !$credit_acc ) $credit_acc = $r[1];
    if( !$value ) $value = $r[2];
    if( !$receipt ) $receipt = $r[3];
    if( !$description ) $description = $r[4];
    if( !$time ) $time = sprintf( '%d-%02d-%02d %02d:%02d', $r[5], $r[6], $r[7], $r[8], $r[9] );
} 
else if( $repid ) { # came from repeated
    $r = $db->getRow( 'select debit_acc, credit_acc, value, receipt, description, '
		    . 'extract(YEAR from nextDue), extract(MONTH from nextDue), extract(DAY from nextDue),'
		    . 'extract(HOUR from nextDue), extract(MINUTE from nextDue),'
		    . 'repdays, repmonths from repeated where id='.$repid );
    check_res( $r, $LANG_err_readrep );

    if( !$debit_acc ) $debit_acc = $r[0];
    if( !$credit_acc ) $credit_acc = $r[1];
    if( !$value ) $value = $r[2];
    if( !$receipt ) $receipt = $r[3];
    if( !$description ) $description = $r[4];
    if( !$time ) $time = sprintf( '%d-%02d-%02d %02d:%02d', $r[5], $r[6], $r[7], $r[8], $r[9] );
    if( !$repDays ) $repDays = $r[10];
    if( !$repMonths ) $repMonths = $r[11];
    if( !$repeat ) $repeat = $repDays ? 'daily' : 'monthly';
}
else if( !$time ) { # new entry, set current time
    $d = $db->getRow( 'select extract(YEAR from CURRENT_TIMESTAMP), extract(MONTH from CURRENT_TIMESTAMP),'
	. 'extract(DAY from CURRENT_TIMESTAMP), extract(HOUR from CURRENT_TIMESTAMP), '
	. 'extract(MINUTE from CURRENT_TIMESTAMP)' );
    check_res( $d, $LANG_err_extracttime );
    $time = sprintf( '%d-%02d-%02d %02d:%02d', $d[0], $d[1], $d[2], $d[3], $d[4] );
}

########################################
# build form
########################################
$accounts = $db->getAll( 'select account, name from accounts where account <> 0 order by account' );
check_res( $accounts, $LANG_err_readacc );
?>

  <h2><?php echo $id ? $LANG_changebooking : ( $repid ? $LANG_changerep : $LANG_menu_new ); ?></h2>

  <form method="get" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF'] ?>">

     <table>
        <tr><td><?php echo $LANG_debitacc ?>:</td>
          <td>
            <select name="debit_acc">
<?php
for( $i = 0; $i < count( $accounts ); ++$i ) {
    echo '<option value="' . $accounts[$i][0] . '"';
    if( $debit_acc == $accounts[$i][0] )
        echo ' selected="selected"';
    echo '>' . $accounts[$i][0] . " - " . htmlq( $accounts[$i][1] ) . "</option>\n";
}
?>
            </select>
          </td>
        </tr>
        <tr><td><?php echo $LANG_creditacc ?>:</td>
          <td>
            <select name="credit_acc">
<?php
for( $i = 0; $i < count( $accounts ); ++$i ) {
    echo '<option value="' . $accounts[$i][0] . '"';
    if( $credit_acc == $accounts[$i][0] )
        echo ' selected="selected"';
    echo '>' . $accounts[$i][0] . " - " . htmlq( $accounts[$i][1] ) . "</option>\n";
}
?>
            </select>
          </td>
        </tr>
        <tr><td><?php echo $LANG_value ?>:</td>
          <td><input type="text" size="15" maxlength="15" name="value"
		value="<?php echo $value ? formatval( $value ) : '0'; ?>" /></td>
        </tr>
        <tr><td colspan="2">&nbsp;</td></tr>
        <tr>
          <td><?php echo $repid ? $LANG_nextdue : $LANG_time ?>:</td>
          <td><input type="text" size="23" maxlength="23" name="time"
		value="<?php echo $time; ?>" /></td>
        </tr>
        <tr>
          <td><?php echo $LANG_receipt ?>:</td>
          <td><input type="text" size="7" maxlength="7" name="receipt"
		value="<?php if( $receipt ) echo $receipt; ?>" /></td>
        </tr>
        <tr>
          <td><?php echo $LANG_desc ?>:</td>
          <td><input type="text" size="50" maxlength="255" name="description"
		value="<?php if( $description ) echo $description; ?>" /></td>
        </tr>
       
        <tr><td colspan="2">&nbsp;</td></tr>

	<?php if( is_null( $id ) ) { ?>
        <tr>
	  <td valign="top"><?php echo $LANG_repetition ?>:</td>
          <td>
            <input type="radio" name="repeat" value="once" 
	      <?php if( !$repeat || $repeat == 'once' )
	        echo 'checked="checked"'; ?> /><?php echo $LANG_unique ?><br />

            <input type="radio" name="repeat" value="daily" 
	      <?php if( $repeat == 'daily' ) echo 'checked="checked"' ?> />
	      <?php echo $LANG_every ?>
	    <input type="text" name="repDays" value="<?php 
	      if( $repDays ) echo $repDays; else echo '1' ?>" size="3"
	      maxlength="2" /> <?php echo $LANG_days ?><br />

            <input type="radio" name="repeat" value="monthly" 
	       <?php if( $repeat == 'monthly' ) echo 'checked="checked"' ?>/>
	       <?php echo $LANG_every ?>
	    <input type="text" name="repMonths" value="<?php
	      if( $repMonths ) echo $repMonths; else echo '1' ?>"
	       size="3" maxlength="2" /> <?php echo $LANG_months ?>
          </td>
        </tr>
	<?php } ?>
     </table>

     <p><?php 
     if( $id ) echo "<input type=\"hidden\" name=\"id\" value=\"$id\" />\n";
     if( $repid ) echo "<input type=\"hidden\" name=\"repid\" value=\"$repid\" />\n"; 
     ?> </p>

     <p>
     <?php if( is_null( $id ) && is_null( $repid ) ) { ?>
     <input type="submit" name="add" value="<?php echo $LANG_book ?>" />
     <?php } else { ?>
     <input type="submit" name="change" value="<?php echo $LANG_change ?>" />
     <input type="submit" name="delete" value="<?php echo $LANG_delete ?>" />
     <?php } ?>
     <input type="reset" value="<?php echo $LANG_reset ?>" />
     </p>
  </form>
</body>
</html>
