<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).
*/

include_once 'backend/base.inc';
include 'backend/dbadmin.inc';
include get_lang_inc( '-admin' );
include_once 'backend/parsecsv.inc';
include_once 'backend/parsexml.inc';

if( $HTTP_GET_VARS['dumpjournal'] ) {
    $res = $db->query( 'select id,debit_acc,credit_acc,value,receipt,description,
			extract(YEAR from time), extract(MONTH from time),
			extract(DAY from time), extract(HOUR from time),
			extract(MINUTE from time)
		        from journal order by id' );
    if( !check_res_delay( $res, $LANG_err_readj ) ) {
	if( $HTTP_GET_VARS['format'] == 'xml' ) {
	    header( 'Content-type: text/xml' );
	    header( 'Content-Disposition: attachment; filename=journal.xml' );

	    echo '<?xml version="1.0" encoding="utf-8" ?>' . "\n\n<journal>\n";

	    while( $row = $res->fetchRow() ) {
		$time = sprintf( '%d-%02d-%02d %02d:%02d', $row[6], $row[7], $row[8], $row[9], $row[10] );
		echo '    <booking id="', $row[0], '" debit="', $row[1], '" credit="', $row[2],
		     '" value="', $row[3];
		if( $row[4] ) echo '" receipt="', $row[4];
		echo '" time="', $time, '">', htmlspecialchars($row[5]), "</booking>\n";
	    }

	    echo "</journal>\n";
	} else {
	    header( 'Content-type: text/comma-separated-values' );
	    header( 'Content-Disposition: attachment; filename=journal.csv' );
	    
	    while( $row = $res->fetchRow() ) {
		$time = sprintf( '%d-%02d-%02d %02d:%02d', $row[6], $row[7], $row[8], $row[9], $row[10] );
		print $row[0] . ',' . $row[1] . ',' . $row[2] . ','
		    . $row[3] . ',' . $row[4] . ',"' . $row[5] . '",'
		    . $time . "\n";
	    }
	}
	exit;
    }
}

if( $HTTP_GET_VARS['dumpaccounts'] ) {
    static $account_types = array();
    $account_types[0] = 'balance';
    $account_types[1] = 'asset';
    $account_types[2] = 'liability';
    $account_types[3] = 'revenue';
    $account_types[4] = 'expense';

    $res = $db->query( "select * from accounts order by account" );
    if( !check_res_delay( $res, $LANG_err_readacc ) ) {
	if( $HTTP_GET_VARS['format'] == 'xml' ) {
	    header( 'Content-type: text/xml' );
	    header( 'Content-Disposition: attachment; filename=accounts.xml' );

	    echo '<?xml version="1.0" encoding="utf-8" ?>' . "\n\n<accounts>\n";

	    while( $row = $res->fetchRow() ) {
		echo '    <account id="', $row[0], '" parent="', $row[1];
		$acr = trim( $row[2] );
		if( $acr ) echo '" acronym="', htmlspecialchars( $acr );
		echo '" type="', $account_types[$row[4]], '">', 
		     htmlspecialchars($row[3]), "</account>\n";
	    }

	    echo "</accounts>\n";
	} else {
	    header( 'Content-type: text/comma-separated-values' );
	    header( 'Content-Disposition: attachment; filename=accounts.csv' );
	    
	    while( $row = $res->fetchRow() )
		print $row[0] . ',' . $row[1] . ',"' . $row[2] . '","'
		    . $row[3] . '",'. $row[4] . "\n";
	}
	exit;
    }
}

if( $HTTP_GET_VARS['dumprep'] ) {
    $res = $db->query( 'select id,debit_acc,credit_acc,value,receipt,description,
			extract(YEAR from nextdue), extract(MONTH from nextdue),
			extract(DAY from nextdue), extract(HOUR from nextdue),
			extract(MINUTE from nextdue), repdays, repmonths
		        from repeated' );
    if( !check_res_delay( $res, $LANG_err_readrep ) ) {
	if( $HTTP_GET_VARS['format'] == 'xml' ) {
	    header( 'Content-type: text/xml' );
	    header( 'Content-Disposition: attachment; filename=repeated.xml' );

	    echo '<?xml version="1.0" encoding="utf-8" ?>' . "\n\n<repeated>\n";

	    while( $row = $res->fetchRow() ) {
		$time = sprintf( '%d-%02d-%02d %02d:%02d', $row[6], $row[7], $row[8], $row[9], $row[10] );
		echo '    <booking id="', $row[0], '" debit="', $row[1], '" credit="', $row[2],
		     '" value="', $row[3];
		if( $row[4] ) echo '" receipt="', $row[4];
		echo '" nextdue="', $time;
		if( $row[11] )
		    echo '" interval="', $row[11], '" repeat="daily">';
		else
		    echo '" interval="', $row[12], '" repeat="monthly">';
		echo htmlspecialchars($row[5]), "</booking>\n";
	    }

	    echo "</repeated>\n";
	} else {
	    header( 'Content-type: text/comma-separated-values' );
	    header( 'Content-Disposition: attachment; filename=repeated.csv' );
	    
	    while( $row = $res->fetchRow() ) {
		$time = sprintf( '%d-%02d-%02d %02d:%02d', $row[6], $row[7], $row[8], $row[9], $row[10] );
		print $row[0] . ',' . $row[1] . ',' . $row[2] . ','
		    . $row[3] . ',' . $row[4] . ',"' . $row[5] . '",'
		    . $time . ',' . $row[11] . ',' . $row[12] . "\n";
	    }
	}
	exit;
    }
}

include 'pagehead-html.inc';

if( $HTTP_POST_VARS['restoreaccounts'] ) {
    $data = get_xml( $HTTP_POST_FILES['accountfile']['tmp_name'], 'accounts' );
    if( $data == -1 ) # no XML file, try CSV
	$data = get_accounts_csv( $HTTP_POST_FILES['accountfile']['tmp_name'] );

    if( is_null( $data ) )
	$fail = $LANG_err_opentemp;
    if( is_integer( $data ) )
	$fail = $LANG_err_erroronline . $data;

    if( !$fail ) {
	check_res( $db->query( 'delete from journal' ), $LANG_err_delj ); 
	check_res( $db->query( 'delete from repeated' ), $LANG_err_delrep ); 
	check_res( $db->query( 'delete from accounts' ), $LANG_err_delacc );
	check_res( $db->query( 'delete from balances' ), $LANG_err_delbal );

	for( $i = 0; $i < count( $data ); ++$i ) {
	    if( $data[$i][2] != null )
		$acr = "'". str_replace( "'", "\\'", $data[$i][2] ) . "'";
	    else
		$acr = 'null';

	    if( $data[$i][3] )
		$desc = "'". str_replace( "'", "\\'", $data[$i][3] ) . "'";

	    $val = $data[$i][0] . ',' . $data[$i][1] . ',' .
		    $acr . ',' . $desc . ',' . $data[$i][4];
	    check_res( $db->query( "insert into accounts values( $val )" ), 
		$LANG_err_insertacc . ' (ID: ' . $data[$i][0] .  ')' ); 
	}
    }
}

if( $HTTP_POST_VARS['restorejournal'] ) {
    $data = get_xml( $HTTP_POST_FILES['journalfile']['tmp_name'], 'journal' );
    if( $data == -1 ) # no XML file, try CSV
	$data = get_journal_csv( $HTTP_POST_FILES['journalfile']['tmp_name'] );

    if( is_null( $data ) )
	$fail = $LANG_err_opentemp;
    if( is_integer( $data ) )
	$fail = $LANG_err_erroronline . $data;

    if( !$fail ) {
	check_res( $db->query( 'delete from journal' ), $LANG_err_delj ); 
	check_res( $db->query( 'delete from balances' ), $LANG_err_delbal );
	for( $i = 0; $i < count( $data ); ++$i ) {
	    $val = $data[$i][0] . ',' . $data[$i][1] . ',' . $data[$i][2] . ','
		. $data[$i][3] . ',' . ( $data[$i][4] ? $data[$i][4] : 'null' )
		. ",'" . str_replace( "'", "\\'", $data[$i][5] ) 
		. "','" . $data[$i][6] . "'";
	    check_res( $db->query( "insert into journal values( $val )" ), 
		$LANG_err_insertj . ' (ID: ' . $data[$i][0] .  ')' ); 
	}
    }
}

if( $HTTP_POST_VARS['restorerep'] ) {
    $data = get_xml( $HTTP_POST_FILES['repfile']['tmp_name'], 'repeated' );
    if( $data == -1 ) # no XML file, try CSV
	$data = get_repeated_csv( $HTTP_POST_FILES['repfile']['tmp_name'] );

    if( is_null( $data ) )
	$fail = $LANG_err_opentemp;
    if( is_integer( $data ) )
	$fail = $LANG_err_erroronline . $data;

    if( !$fail ) {
	check_res( $db->query( 'delete from repeated' ), $LANG_err_delrep ); 
	for( $i = 0; $i < count( $data ); ++$i ) {
	    $val = $data[$i][0] . ',' . $data[$i][1] . ',' . $data[$i][2] . ','
		. $data[$i][3] . ',' . ( $data[$i][4] ? $data[$i][4] : 'null' )
		. ",'" . str_replace( "'", "\\'", $data[$i][5] ) . "','" .
			     $data[$i][6] . "'," .
			     ( $data[$i][7] ? $data[$i][7] : 'null' ) . ','.
			     ( $data[$i][8] ? $data[$i][8] : 'null' );
	    check_res( $db->query( "insert into repeated values( $val )" ), 
		$LANG_rep_insertrep . ' (ID: ' . $data[$i][0] .  ')' ); 
	}
    }
}

if( $HTTP_GET_VARS['initdb'] )
    check_res( init_db(), $LANG_err_initdb );

if( $fail )
    print "<p class=\"error\">$LANG_error: $fail</p>";
?>

<h2><?php echo $LANG_menu_admin ?></h2>

<table class="admintbl">
  <tr>
    <th><?php echo $LANG_init ?></th>
    <td>
      <form action="<?php echo $HTTP_SERVER_VARS['PHP_SELF'] ?>" method="get">
      <p><input type="submit" name="initdb" value=" <?php echo $LANG_doinit ?> " />
      <span style="padding-left: 20px"><span class="error"><?php echo $LANG_initwarn ?></span></span></p>
      </form>
    </td>
  </tr>
  <tr>
    <th><?php echo $LANG_backup ?></th>
    <td>
      <form action="<?php echo $HTTP_SERVER_VARS['PHP_SELF'] ?>" method="get">
      <table><tr>
	  <td><strong><?php echo $LANG_fileformat ?></strong><br />
	      <input type="radio" name="format" value="csv" checked="checked" />CSV<br />
	      <input type="radio" name="format" value="xml" />XML</td>
	  <td><input type="submit" name="dumpjournal" value=" <?php echo $LANG_backupj ?> " /></td>
	  <td><input type="submit" name="dumprep" value=" <?php echo $LANG_backuprep ?> " /></td>
	  <td><input type="submit" name="dumpaccounts" value=" <?php echo $LANG_backupacc ?> " /></td>
      </tr></table>
      </form>
    </td>
  </tr>
  <tr>
    <th><?php echo $LANG_restore ?></th>
    <td>
      <form action="<?php echo $HTTP_SERVER_VARS['PHP_SELF'] ?>" method="post" enctype="multipart/form-data" > 
        <p><?php echo $LANG_replaceacc ?> <input type="file" name="accountfile" size="40" />
        <input type="submit" name="restoreaccounts"
	value="<?php echo $LANG_replace ?>" /> <br /> 
	    <span class="error">(<?php echo $LANG_replaceaccwarn ?>)</span></p> <hr />

        <p><?php echo $LANG_replacej ?> <input type="file" name="journalfile" size="40"/>
        <input type="submit" name="restorejournal" value="<?php echo $LANG_replace ?>" /></p><hr />

	<p><?php echo $LANG_replacerep ?> <input type="file" name="repfile" size="40" />
        <input type="submit" name="restorerep" value="<?php echo $LANG_replace ?>" /></p>
      </form>
    </td>
  </tr>
</table>
</body>
</html>
