#!/usr/bin/env entity

<object title="Clock">
  <window ondelete="entity:exit" title="Clock" >
    <valign>
      <object title="clock" name="clock" dragable="true" expand="false">
        <label name="time" font="10x20" text = "00:00:00"></label>
        <timer interval = "1000" action="update_clock"></timer>
        <?perl

            use Socket;
            use Devel::Peek;

            sub update_clock {
                my $node = shift;
                my $timelabel = enode('label.time');
                my $found = enode('/')->child('object.clock');

                print "node = $node\ntimelabel = $timelabel\nfound = $found\n";

                # aasdfg( - 3;  # this line is for testing the reporting of syntax errors
                my ($sec, $min, $hour, $mday) = localtime (time);
                my $str = sprintf ('%02d:%02d:%02d', $hour, $min, $sec);

                $timelabel->{text} = $str;
                $num++;
                $found->new_child("button.new-$num", 
                                  "label" => "new");

                print "$timelabel->{text}\n";

                exists($node->{foo}) ? delete($node->{foo}) : ($node->{foo} = 'bar');

                print 'exists($node->{name}) == ' . exists($node->{name}) . "\n";
                print 'exists($node->{foo})  == ' . exists($node->{foo})  . "\n";

                print "attribs of node: ", keys %$node, "\n\n";

                my $obj = enode ("object");
                @children = $obj->children ();
                foreach $child (@children) {
                    print "Child node $node\n";
                }

                print "path of node is ", $node->path (), "\n";

                my $foo = "Hello again";
                $obj->set_kv ("hello", $foo);
                my $foo2 = $obj->get_kv ("hello");
                print "foo2 is $foo2, ", (ref $foo2), ", ", (ref $foo), "\n";

                Dump $foo2;
            }
        ?>
      </object>
    </valign>
  </window>
</object>
