/*
		  Endeavour Archiver Operation Callbacks
 */

#ifndef ARCHIVEROPCB_H
#define ARCHIVEROPCB_H

#include <gtk/gtk.h>
#include "toolbar.h"
#include "findbar.h"
#include "statusbar.h"
#include "archiver.h"


extern void EDVArchiverMenuItemCB(GtkWidget *widget, gpointer data);
extern gint EDVArchiverMenuItemEnterCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVArchiverMenuItemLeaveCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

extern void EDVArchiverOPCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVArchiverOPEnterCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVArchiverOPLeaveCB(
	toolbar_item_struct *item, gint id, gpointer data
);

extern const gchar *EDVArchiverFindBarLocationCB(
	edv_findbar_struct *fb, gpointer data
);
extern void EDVArchiverFindBarStartCB(edv_findbar_struct *fb, gpointer data);
extern void EDVArchiverFindBarEndCB(
	edv_findbar_struct *fb, gint total_matches, gpointer data
);
extern void EDVArchiverFindBarMatchCB(
	const gchar *path, const struct stat *lstat_buf,
	const gchar *excerpt, gint line_index,
	gpointer data
);

extern void EDVArchiverStatusMessageCB(const gchar *message, gpointer data);
extern void EDVArchiverStatusProgressCB(gfloat progress, gpointer data);

extern void EDVArchiverOPSyncDisks(edv_archiver_struct *archiver);
extern void EDVArchiverOPWriteProtect(edv_archiver_struct *archiver);

extern void EDVArchiverOPClose(edv_archiver_struct *archiver);
extern void EDVArchiverOPExit(edv_archiver_struct *archiver);

extern void EDVArchiverOPAdd(edv_archiver_struct *archiver);
extern void EDVArchiverOPExtract(edv_archiver_struct *archiver);
extern void EDVArchiverOPExtractAll(edv_archiver_struct *archiver);
extern void EDVArchiverOPDelete(edv_archiver_struct *archiver);
extern void EDVArchiverOPSelectAll(edv_archiver_struct *archiver);
extern void EDVArchiverOPUnselectAll(edv_archiver_struct *archiver);
extern void EDVArchiverOPProperties(edv_archiver_struct *archiver);

extern void EDVArchiverOPRefresh(edv_archiver_struct *archiver);
extern void EDVArchiverOPRefreshAll(edv_archiver_struct *archiver);
extern void EDVArchiverOPCommentAndStatistics(edv_archiver_struct *archiver);


#endif	/* ARCHIVEROPCB_H */
