/* -*- c -*- */
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

#define FOCUS     1
#define LABEL_TXT 1
#define LABEL_DEF 1


#ifndef GET_COLOR_DEFINED
#define GET_COLOR_DEFINED 1

static chtype
get_color (ask_t *ask, const char *fg_field, const char *bg_field,
           const char *fg_def, const char *bg_def)
{
        char *fg;
        char *bg;

        fg = ask_get_field (ask, fg_field);
        bg = ask_get_field (ask, bg_field);

        if (fg && bg){
                return color_from_str (fg, bg);
        }
        else if (fg){
                return color_from_str (fg, bg_def);
        }
        else if (bg){
                return color_from_str (fg_def, bg);
        }
        return color_from_str (fg_def, bg_def);
}

#endif


static WINDOW *
interface_init (void)
{
        ask_t  *ask       = ask_select_default ("win_boxes");
        int     height    = -12;
        int     width     = 25;
        int     top       = 2;
        int     left      = 0;
        int     maxheight = LINES;
        int     maxwidth  = COLS;
        WINDOW *win;

        hilight_color = get_color (ask, "hilight_fg", "hilight_bg", "black", "green");
        tree_color = get_color (ask, "tree_fg", "tree_bg", "red", "black");
        text_color = get_color (ask, "text_fg", "text_bg", "lightgrey", "black");
        root_color = get_color (ask, "root_fg", "root_bg", "white", "black");
        tree_bar_color = get_color (ask, "tree_bar_fg", "tree_bar_bg", "red", "cyan");

        left = ask_get_field_int_default (ask, "left", 0);
        width = ask_get_field_int_default (ask, "width", 25);
        height = ask_get_field_int_default (ask, "height", -12);
        top = ask_get_field_int_default (ask, "top", 2);
        box_fmt = ask_get_field (ask, "box_fmt");
        if (box_fmt == NULL){
                box_fmt = " %010n (%u/%t)";
        }


        if (height <= 0)
                height += maxheight;
        if (width <= 0)
                width += maxwidth;
        if (top < 0)
                top += maxheight;
        if (left < 0)
                left += maxwidth;

        if (height > maxheight)
                height = maxheight;
        if (width > maxwidth)
                width = maxwidth;

        if (top + height > maxheight)
                top = maxheight - height;
        if (left + width > maxwidth)
                left = maxwidth - width;

        win = window_create ("boxes", height, width, top, left, 1);

        if (ask){
#if FOCUS
                if (ask_get_field_int_default (ask, "label", 1)){
                        label = label_create (win);
                }
                else {
                        label = NULL;
                }
#endif /* FOCUS */
                ask_destroy (ask);
        }
#if LABEL_DEF
        else {
                label = label_create (win);
        }
#endif /* LABEL_DEF */


#if LABEL_TXT
        if (label){
                label_set_text (label,  "select box");
        }
#endif /* LABEL_TXT */

        wattrset (win, text_color);
        return win;
}
