/*
Copyright (C) 1991 Geoffrey M. Clemm

This file is part of the Odin system.

The Odin system is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public License
as published by the Free Software Foundation (see the file COPYING).

The Odin system is distributed WITHOUT ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

geoff@boulder.colorado.edu
*/

#include "inc/System.hh"
#ifndef BSD_DIR
#include <dirent.h>
#else
#include <sys/types.h>
#ifdef BSD_BSD_DIR
#include <bsd/dir.h>
#else
#include <sys/dir.h>
#endif
#endif

#include "inc/GMC.h"
#include "inc/FileName.h"
#include "inc/Str.h"


tp_FilDsc
OpenDir(
   GMC_ARG(tp_FileName, FileName)
   )
   GMC_DCL(tp_FileName, FileName)
{
   tp_FilDsc FilDsc;

   FilDsc = (tp_FilDsc)opendir(FileName);
   if (FilDsc == NULL) {
      return ERROR; }/*if*/;
   return FilDsc;
   }/*OpenDir*/


void
CloseDir(
   GMC_ARG(tp_FilDsc, FilDsc)
   )
   GMC_DCL(tp_FilDsc, FilDsc)
{
#ifndef BSD_DIR
   int status;
#endif

   FORBIDDEN(FilDsc == NIL);
#ifndef BSD_DIR
   status = closedir((DIR *)FilDsc);
   if (status == -1) SysCallError(StdOutFD, "closedir(CloseDir)");
#else
   (void)closedir((DIR *)FilDsc);
#endif
   }/*CloseDir*/


void
ReadDir(
   GMC_ARG(tp_Str, Str),
   GMC_ARG(boolean*, EndPtr),
   GMC_ARG(tp_FilDsc, FilDsc)
   )
   GMC_DCL(tp_Str, Str)
   GMC_DCL(boolean*, EndPtr)
   GMC_DCL(tp_FilDsc, FilDsc)
{
#ifndef BSD_DIR
   struct dirent *dp;
#else
   struct direct *dp;
#endif

   FORBIDDEN(FilDsc == NIL);
   *EndPtr = FALSE;
   dp = readdir((DIR *)FilDsc);
   if (dp == NULL) {
      *EndPtr = TRUE;
      return; }/*if*/;
#ifndef BSD_DIR
   (void)strcpy(Str, dp->d_name);
#else
   (void)strncpy(Str, dp->d_name, (int)dp->d_namlen);
   Str[dp->d_namlen] = 0;
#endif
   if (strcmp(Str, ".") == 0 || strcmp(Str, "..") == 0) {
      ReadDir(Str, EndPtr, FilDsc); }/*if*/;
   }/*ReadDir*/


void
ClearDir(
   GMC_ARG(tp_FileName, DirName)
   )
   GMC_DCL(tp_FileName, DirName)
{
   tp_FilDsc FilDsc;
   tps_Str Str;
   boolean End;
   tps_FileName FileName;

   FORBIDDEN(DirName == NIL);
   FilDsc = OpenDir(DirName);
   if (FilDsc == ERROR) {
      return; }/*if*/;
   for (ReadDir(Str, &End, FilDsc); !End; ReadDir(Str, &End, FilDsc)) {
      (void)sprintf(FileName, "%s/%s", DirName, Str);
      Remove(FileName); }/*for*/;
   CloseDir(FilDsc);
   }/*ClearDir*/


