% 
% Domesday Project Settings File
% vim: syntax=indexgen
% vim: fo=tcroq 
% 
% For full details of the format of this document, please see the
% indexgenerator.project(5) manual page.

% The file should follow these rules:
% - a '%' starts a comment; comment text continues to the end of the line
% - a variable is defined as a word starting in the first column
%   followed by a )
% - the value of a variable is all text, excluding comments,
%   starting on the next line after the variable
% - a variable is ended by the string ";;" starting in the first column 
% - Additionally, shorter variables can be defined as simple key=value pairs

% Set the locale for this file
locale=en

% The Settings file version being used. This should not be changed unless you
% are upgrading to a new version of Domesday
settingsVersion = 0.2


%%%%%%%%%%%%%%%%%%%% FILES TO INDEX %%%%%%%%%%%%%%%%%%%%  

% Domesday can index files on a local file system, or on a remote 
% server. The local filesystem option will be far faster, however if your site
% has dynamic pages, you will have to go through the server to ensure that 
% Domesday sees the full page, as the user would.
% The following option has two possible choices: filsystem or server
getMethod=filesystem 
%BLS getMethod = server

% If you chose filesystem for the previous option, you get two choices of how 
% to index the files: linkfollow or dirscan.
% linkfollow - follow links from the start pages
% dirscan - scan directories (recursively) for files to include
fileSystemSearch = dirscan

% Start URLs / files / Directories
% This is where Domesday will start looking for files to index
% They must return valid files, unless the local and dirscan options were
% chosen, in which case they must be directories.
scanRoot)
/home/mark/website
%BLS http://gamma/tester.html
;;

% If using server method, you can define what headers to send
% Header take the form of:
%	Header=value
% and are written one header per line
httpHeaders)
User-Agent=IndexGenerator3.0pre1
Accept-Encoding=utf-8
Accept-Language=en
;;

% To have more control over which files are included, you can define filters.
% There are two types:
% Scan Filters - these are used to determine which files Domesday should
%     scan for links to files for indexing
% Index Filters - these determine which files are included in your index.
%
% Include filters determine which files should be included. If this is empty,
% all files will be included.
% Exclude filters specify files which should be explicitly excluded.
% Filters take the form of simple text strings - the url / path+filename will 
% be scanned for these strings;
ScanIncludeFilters = /home/ /store/
%BLS ScanIncludeFilters = htm pdf
ScanExcludeFilters)
;;

IndexIncludeFilters)
;;
IndexExcludeFilters)
/ads/
;;


% The location (and name) of the output file.
% If filsystem index option was chosen (vvs server), then this must be in
% a directory on the same directory tree as the files  being indexed a the links
% in the index will be created relative to this file. 
outputFilename=sitemap.html
%BLS outputFilename=output/ordered.html


%%%%%%%%%%%%%%%%%%%% PROJECT DETAILS %%%%%%%%%%%%%%%%%%%%  

% Type of index to generate:
%  - sitemap - a hierarchical site map, with the output structure in the same
%      fashion as the directory structure. 
%  - orderedlist - a list of items ordered by any number of fields (most
%       commonly title, thereby creating an A-Z index.
indexType = sitemap
%BLS indexType = orderedlist

% If your index page requires other files (e.g. stylesheets, images), then you
% can set up Domesday to copy them when an index is created. This option
% is mainly here to allow the use of templates in the GUI.
filesToCopy)
;;
fileCopyTarget=


%%%%%%%%%%%%%%%%%%%% SITEMAP SETTINGS %%%%%%%%%%%%%%%%%%%%  
% The following only apply if a site map style index was 
% chosen. See the next section for Ordered Lists options.

% Placeholders can be added to these for data which should be inserted by Index
% Generator. See the documentation for more details.

% The code to go at the start of the file. 
smStartTxt)
<html>
<head>
<title>Sitemap</title>
</head>
<body>
<h1>Sitemap</h1>
<p>Generated by <a href="<IG Field="IndexGenURL"/>">Domesday</a> 
<IG Field="IndexGenVersion"/> on <IG Field="GenDate"/> at 
<IG Field="GenDate" format="KK:mm a zzzz G"/>
<p>Number of files: <IG Field="FileCount"/>

;;

smEnterFolder)
<h3>Enter Folder: <IG Field="TopFolder"/></h3>
(<IG Field="fullrelfolder"/>) 
<ul>
;;

smLeaveFolder)
</ul>
;;

smLinksTxt)
<li>
<br>File Name: <IG Field="FileName"/>
<br>Real Location: <IG Field="RealLocation"/>
<br>Relative Location: <IG Field="RelLocation"/>
<br>Title: <IG Field="TITLE"/>
<br>Author: <IG Field="Author"/>
<br>Description: <IG Field="Description"/>
<br>Keywords: <IG Field="Keywords" separator=", "/>
<br>File Size: <IG Field="FileSize" format="Bytes"/> Bytes (<IG Field="FileSize" format="HumanReadable"/>)
<br>File Type: <IG Field="FileType"/>
<br>Parser: <IG Field="Parser"/>
<br>
;;

smEndTxt)
<IG Field="IndexGenVersion"/>
<IG Field="IndexGenVersion" param="silly"/>
<IG Field="gendatedsafhjasdh"/>
</body>
</html>
;;

%%%%%%%%%%%%%%%%%%%% ORDERED LIST SETTINGS %%%%%%%%%%%%%%%%%%%%  
% The file attribute used to sort the listing
% possible values are:
%	- Title
%	- Author
%	- Description
%	- Keywords
%	- FileType
%	- FileSize
%	- FileName
olSortKey = Title

%
% Articles to be ignored when sorting
%
olArticles = a an the

%
% text inserted at the beginning of a file
%
olStartTxt)
<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html>
  <head>
    <title>Ordered Site Index</title>
    <meta http-equiv="Content-Type" value="text/html; charset=utf-8"/>
    <meta name="Generator" value="IndexGenerator3.0pre1"/>
  </head>

  <body>
;;

olNavStart = <p>
olNavLink = <a href="#<IG Field="SectionChar"/>"><IG Field="SectionChar"/></a>
olNavEnd = </p><hr/>

%
% text inserted when a new section starts
%
olSecStart)
    <h1 id="<IG Field="SectionChar"/>"><IG Field="SectionChar"/></h1>
    <ol>
;;

%
% text inserted when a section ends
%
olSecEnd)
    </ol>
;;

%
% text inserted for a hyperlink
%
olLink)
    <li><a href="<IG Field="RealLocation"/>"><IG Field="FileName"/></a> - <IG Field="Title"/></li>
;;

%
% text inserted at the end of a file
%
olEndTxt)
  </body>
</html>
;;

%%%%%%%%%%%%%%%%%%%% GUI SETTINGS %%%%%%%%%%%%%%%%%%%%  

% Descriptive name for the project, used by the graphical interface.
projectName=New Project
created=0000000

% For the gui interface, the following command can be set to true to allow a
% basic interface where an index template is chosen, rather than defining all
% setting.
loadAsTheme=true

%% COMMENTED OUT: These should really be stored elsewhere. (Also makes handling
% this file a lot easier.)
%fileCount=9
%genCount=1

