import java.util.*;
import java.text.*;

/**
 * A class for handling the text mode user interface.
 *
 * <br><br>$Id: TextInterface.java,v 1.3 2002/09/06 11:44:04 howama Exp $
 */
public class TextInterface implements UserInterface{

	/** L10N resources */
	ResourceBundle messages;

	/** Error count */
	private int errorCount = 0;

	/** Quiet setting - if true, only summary ouput is produced */
	boolean quiet = false;

	private void clearLine(){
		// todo: there's gotta be a better way of doing this.
		System.out.print("                                                                                                                           \r");
	}
	
	/** 
	 * Creates the text interface object
	 * @param l10n initialised ResourceBundle containgin main strings
	 */
	public TextInterface(ResourceBundle l10n, boolean quiet){
		this.quiet = quiet;
		messages = l10n;
	}
			
	/**
	 * This is called whenever an error occurs. Note that these may nt be fatal
	 * errors. 
	 * @param message The full formatted message, as will appear in the log
	 * @param errorNo The number of the error, to be cross referenced with
	 * documentation.
	 * @param resourceID identifier for the resource in MainStrings.properties
	 * @param params Additional parameters supplied by the caller.
	 */
	public void error(String message, int errorNo, String resourceID, Object[] params){
		errorCount++;
		if (quiet) return;
		clearLine();
		System.out.println( "   " + messages.getString("ERROR") + "("+errorNo+") "  + message);
	}
	
	/**
	 * This is called whenever a warning is issued. Note that these may nt be fatal
	 * errors. 
	 * @param message The full formatted message, as will appear in the log
	 * @param errorNo The number of the error, to be cross referenced with
	 * documentation.
	 * @param resourceID identifier for the resource in MainStrings.properties
	 * @param params Additional parameters supplied by the caller.
	 */
	public void warning(String message, int warningNo, String resourceID, Object[] params){
		errorCount++;
		if (quiet) return;
		clearLine();
		System.out.println( "   " + messages.getString("WARNING") + "("+warningNo+") "  + message);
	}
	
	/**
	 * This indicates that the scanning of the files is about to begin
	 */
	public void startScan(){
		if (quiet) return;
		System.out.println(messages.getString("SCAN_STARTED"));
	}

	private int fileCount = 0;
	private String currentFile = null;
	/**
	 * This is a progress report for the scaning of the files.
	 * @param complete Number of files scaned so far.
	 */
	public void scanProgress(String current){
		fileCount++;
		if (quiet) return;
		currentFile = current;
		// TODO: X-platform checks - carridge return 
		System.out.print( IGLog.formatResource("SCANNING_FILE", new Object[] {new Integer(fileCount), current} ));
	}

	/**
	 * This indicates that the scanning of the files has completed and the
	 * output is about to be generated.
	 */
	public void startOutputGenerate(){
		if (quiet) return;
		currentFile = null;
		clearLine();
		System.out.println( messages.getString("OUTPUT_GEN_STARTED"));
	}

	public void finished(){
		// todo: add time taken
		clearLine();
		System.out.println( IGLog.formatResource("DONE", new Object[] {new Integer(fileCount), IGLog.getLogName()} ));
		if (errorCount > 0){
			// todo: format (s) better.
			// l10N
			System.out.println();
			System.out.println( IGLog.formatResource("ERROR_SUMMARY", new Object[] {new Integer(errorCount)}));
		}
	}
}
