/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void gla_ejecutar(void)
{
	gchar *comando;
	gchar *glade_file;
	gchar *tmp;
	FILE *archivo;
	gchar *nombre,*nombre_completo;
	GtkCTreeNode *nodo_arbol;
	gboolean guardar_proyecto;
	xmlDocPtr doc;
	xmlNodePtr nodo;
	
	guardar_proyecto=FALSE;
	glade_file=pro_glade_file();
	if (glade_file!=NULL) {
		edit_guardar_todo();
		tmp=pro_nombre_completo_archivo(glade_file,TRUE);
		archivo=fopen(tmp,"r");
		if (archivo==NULL) {
			gla_crear(glade_file);
		} else {
			fclose(archivo);
		}
		g_free(tmp);
		comando=g_strdup_printf("glade %s\n",glade_file);
		gen_comando(comando,NULL);
		g_free(comando);
		
		cefv_congelar_lista_combo=FALSE;
		nombre=pro_nombre_completo_archivo("main.c",FALSE);
		if (gen_existe_fichero(nombre)) {
			if (!pro_existe_archivo("main.c")) {
				nodo_arbol=arch_anadir("main.c");
				edit_anadir(nombre,nodo_arbol);
				pro_anadir("main.c");
				guardar_proyecto=TRUE;
			}
		}
		g_free(nombre);
		tmp=pro_nombre_completo_archivo(glade_file,TRUE);
		doc=xmlParseFile(glade_file);
		g_free(tmp);
		nodo=doc->root->childs->childs;
		nombre=NULL;
		do {
			if (!strcmp(nodo->name,"main_source_file")) {
				nombre=xmlNodeGetContent(nodo);
			}
			nodo=nodo->next;
		} while (nodo!=NULL);
		if (nombre!=NULL) {
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		} else {
			nombre=g_strdup("interface.c");
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		}
		if (gen_existe_fichero(nombre_completo)) {
			if (pro_existe_archivo(nombre)) {
				edit_recargar_archivo(nombre);
			} else {
				nodo_arbol=arch_anadir(nombre);
				edit_anadir(nombre_completo,nodo_arbol);
				pro_anadir(nombre);
				guardar_proyecto=TRUE;
			}
		}
		g_free(nombre);
		g_free(nombre_completo);
		nodo=doc->root->childs->childs;
		nombre=NULL;
		do {
			if (!strcmp(nodo->name,"main_header_file")) {
				nombre=xmlNodeGetContent(nodo);
			}
			nodo=nodo->next;
		} while (nodo!=NULL);
		if (nombre!=NULL) {
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		} else {
			nombre=g_strdup("interface.h");
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		}
		if (gen_existe_fichero(nombre_completo)) {
			if (pro_existe_archivo(nombre)) {
				edit_recargar_archivo(nombre);
			} else {
				nodo_arbol=arch_anadir(nombre);
				edit_anadir(nombre_completo,nodo_arbol);
				pro_anadir(nombre);
				guardar_proyecto=TRUE;
			}
		}
		g_free(nombre);
		g_free(nombre_completo);
		nodo=doc->root->childs->childs;
		nombre=NULL;
		do {
			if (!strcmp(nodo->name,"handler_source_file")) {
				nombre=xmlNodeGetContent(nodo);
			}
			nodo=nodo->next;
		} while (nodo!=NULL);
		if (nombre!=NULL) {
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		} else {
			nombre=g_strdup("callbacks.c");
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		}
		if (gen_existe_fichero(nombre_completo)) {
			if (pro_existe_archivo(nombre)) {
				edit_recargar_archivo(nombre);
			} else {
				nodo_arbol=arch_anadir(nombre);
				edit_anadir(nombre_completo,nodo_arbol);
				pro_anadir(nombre);
				guardar_proyecto=TRUE;
			}
		}
		g_free(nombre);
		g_free(nombre_completo);
		nodo=doc->root->childs->childs;
		nombre=NULL;
		do {
			if (!strcmp(nodo->name,"handler_header_file")) {
				nombre=xmlNodeGetContent(nodo);
			}
			nodo=nodo->next;
		} while (nodo!=NULL);
		if (nombre!=NULL) {
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		} else {
			nombre=g_strdup("callbacks.h");
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		}
		if (gen_existe_fichero(nombre_completo)) {
			if (pro_existe_archivo(nombre)) {
				edit_recargar_archivo(nombre);
			} else {
				nodo_arbol=arch_anadir(nombre);
				edit_anadir(nombre_completo,nodo_arbol);
				pro_anadir(nombre);
				guardar_proyecto=TRUE;
			}
		}
		g_free(nombre);
		g_free(nombre_completo);
		nodo=doc->root->childs->childs;
		nombre=NULL;
		do {
			if (!strcmp(nodo->name,"support_source_file")) {
				nombre=xmlNodeGetContent(nodo);
			}
			nodo=nodo->next;
		} while (nodo!=NULL);
		if (nombre!=NULL) {
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		} else {
			nombre=g_strdup("support.c");
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		}
		if (gen_existe_fichero(nombre_completo)) {
			if (pro_existe_archivo(nombre)) {
				edit_recargar_archivo(nombre);
			} else {
				nodo_arbol=arch_anadir(nombre);
				edit_anadir(nombre_completo,nodo_arbol);
				pro_anadir(nombre);
				guardar_proyecto=TRUE;
			}
		}
		g_free(nombre);
		g_free(nombre_completo);
		nodo=doc->root->childs->childs;
		nombre=NULL;
		do {
			if (!strcmp(nodo->name,"support_header_file")) {
				nombre=xmlNodeGetContent(nodo);
			}
			nodo=nodo->next;
		} while (nodo!=NULL);
		if (nombre!=NULL) {
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		} else {
			nombre=g_strdup("support.h");
			nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);
		}
		if (gen_existe_fichero(nombre_completo)) {
			if (pro_existe_archivo(nombre)) {
				edit_recargar_archivo(nombre);
			} else {
				nodo_arbol=arch_anadir(nombre);
				edit_anadir(nombre_completo,nodo_arbol);
				pro_anadir(nombre);
				guardar_proyecto=TRUE;
			}
		}
		g_free(nombre);
		g_free(nombre_completo);

		xmlFreeDoc(doc);
		if (guardar_proyecto) {
			pro_guardar();
		}
	}
	g_free(glade_file);
}

void gla_crear(gchar *nombre)
{
	xmlDocPtr doc;
	xmlNodePtr nodo;
	gchar *proyecto;
	gchar *pixdir;
	gchar *srcdir;
	gchar *libs;
	gchar *lenguaje;
	gchar *ejecutable;

	DEBUG_MSG(creando archivo para el glade);
	ejecutable=pro_ejecutable();
	lenguaje=pro_lenguaje();
	libs=pro_librerias_lincado();
	proyecto=pro_nombre();
	pixdir=pro_pixdir();
	srcdir=pro_srcdir();
	doc=xmlNewDoc("1.0");
	nodo=xmlNewNode(NULL,"GTK-Interface");
	doc->root=nodo;
	nodo=xmlNewChild(nodo,NULL,"project",NULL);
	xmlNewChild(nodo,NULL,"name",proyecto);
	xmlNewChild(nodo,NULL,"program_name",ejecutable);
	xmlNewChild(nodo,NULL,"source_directory",srcdir);
	xmlNewChild(nodo,NULL,"pixmaps_directory",pixdir);
	if (lenguaje[0]=='0') {
		xmlNewChild(nodo,NULL,"languaje","C");
	} else {
		xmlNewChild(nodo,NULL,"languaje","C++");
	}
	if (libs[LGNOME]=='1') {
		xmlNewChild(nodo,NULL,"gnome_support","True");
	} else {
		xmlNewChild(nodo,NULL,"gnome_support","False");
	}
	if (libs[LGETTEXT]=='1') {
		xmlNewChild(nodo,NULL,"gettext_support","True");
	} else {
		xmlNewChild(nodo,NULL,"gettext_support","False");
	}
	xmlNewChild(nodo,NULL,"output_build_files","False");
	g_free(proyecto);
	g_free(srcdir);
	g_free(pixdir);
	g_free(libs);
	g_free(lenguaje);
	g_free(ejecutable);

	xmlSaveFile(nombre,doc);
	xmlFreeDoc(doc);
}
